//
//  TMGSampleViewController.m
//  TMGDemoAudio
//
//  Created by RoonieChen on 2021/5/14.
//  Copyright © 2021 tobinchen. All rights reserved.
//

#import "TMGSampleViewController.h"
#import "TMGRealTimeViewController.h"
#import "TMGPTTViewController.h"
#import "EnginePollHelper.h"
#import "GMESDK/TMGEngine.h"
#import "APPIDKeys.h"
#import "DispatchCenter.h"
@interface TMGSampleViewController ()

@property (nonatomic, strong) UIScrollView *backScrollView;

@property (nonatomic, strong) UILabel *appIDLabel;

@property (nonatomic, strong) UITextField *appIDTF;

@property (nonatomic, strong) UILabel *keyLabel;

@property (nonatomic, strong) UITextField *keyTF;

@property (nonatomic, strong) UILabel *openIDLabel;

@property (nonatomic, strong) UITextField *openIDTF;

@property (nonatomic, strong) UIButton *btnInit;

@property (nonatomic, strong) UIButton *btnUnInit;

@property (nonatomic, strong) UIButton *btnRealTime;

@property (nonatomic, strong) UIButton *btnPTT;

@property (nonatomic, assign) BOOL isSDKInit;

@end

@implementation TMGSampleViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
    [self configSDK];
}

- (void)configSDK {
}

- (void)setupUI {
    [self.view addSubview:self.backScrollView];
    [self.backScrollView addSubview:self.appIDLabel];
    [self.backScrollView addSubview:self.appIDTF];
    [self.backScrollView addSubview:self.keyLabel];
    [self.backScrollView addSubview:self.keyTF];
    [self.backScrollView addSubview:self.openIDTF];
    [self.backScrollView addSubview:self.openIDLabel];
    [self.backScrollView addSubview:self.btnInit];
    [self.backScrollView addSubview:self.btnUnInit];
    [self.backScrollView addSubview:self.btnRealTime];
    [self.backScrollView addSubview:self.btnPTT];
    
    self.appIDTF.text = SDKAPPID3RD;
    self.keyTF.text = AUTHKEY;
    
    srand((unsigned)time(0));
    int openid = rand() % 10000 + 10000;
    self.openIDTF.text = [NSString stringWithFormat:@"%d", openid];
    
    
    [self layout];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:YES animated:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.navigationController setNavigationBarHidden:NO animated:animated];
}

- (void)layout {
    CGFloat leftLabelW = 60;
    CGFloat leftlabelH = 30;
    CGFloat tfW = 150;
    CGFloat tfH = leftlabelH;
    CGFloat margin = 5;
    CGFloat left = (self.backScrollView.frame.size.width - leftLabelW - tfW - margin)/2;
    CGFloat vMargin = 20;
    self.appIDLabel.frame = CGRectMake(left, 100, leftLabelW, leftlabelH);
    self.appIDTF.frame = CGRectMake(CGRectGetMaxX(self.appIDLabel.frame) + margin, self.appIDLabel.frame.origin.y, tfW, tfH);
    self.keyLabel.frame = CGRectMake(left, CGRectGetMaxY(self.appIDLabel.frame) + vMargin, leftLabelW, leftlabelH);
    self.keyTF.frame = CGRectMake(CGRectGetMaxX(self.keyLabel.frame) + margin, self.keyLabel.frame.origin.y, tfW, tfH);
    self.openIDLabel.frame = CGRectMake(left, CGRectGetMaxY(self.keyLabel.frame) + vMargin, leftLabelW, leftlabelH);
    self.openIDTF.frame = CGRectMake(CGRectGetMaxX(self.openIDLabel.frame) + margin, self.openIDLabel.frame.origin.y, tfW, tfH);
    self.btnInit.frame = CGRectMake(left - 37, CGRectGetMaxY(self.openIDTF.frame) + 30, 100, leftlabelH);
    self.btnUnInit.frame = CGRectMake(CGRectGetMaxX(self.btnInit.frame) + margin * 3, self.btnInit.frame.origin.y, 100, leftlabelH);
    self.btnRealTime.frame = CGRectMake(left - 32, CGRectGetMaxY(self.btnInit.frame) + 30, 230, leftlabelH);
    self.btnPTT.frame = CGRectMake(left - 7, CGRectGetMaxY(self.btnRealTime.frame) + 30, 230, leftlabelH);
    
    self.backScrollView.contentSize = CGSizeMake(self.backScrollView.frame.size.width,CGRectGetMaxY(self.btnPTT.frame) + 10);
}

#pragma mark - Action

- (void)btnInitClick {
    // step 1/11: get ITMGContext
    //https://cloud.tencent.com/document/product/607/18238#1.E3.80.81.E8.8E.B7.E5.8F.96.E5.8D.95.E4.BE.8B
    ITMGContext* _context = [ITMGContext GetInstance];
    
    // step 2/11: Set GME CallBack
    //https://cloud.tencent.com/document/product/607/15210#.E6.B3.A8.E5.86.8C.E5.9B.9E.E8.B0.83
     _context.TMGDelegate = [DispatchCenter getInstance];
    
    // Step 3/11 Init GME
    //https://cloud.tencent.com/document/product/607/15221#.E5.88.9D.E5.A7.8B.E5.8C.96-sdk
    QAVResult result = [_context InitEngine:self.appIDTF.text openID:self.openIDTF.text];
    if (result == QAV_OK) {
        self.isSDKInit = YES;
    }
    
    // Step 4/11: Poll to trigger callback
    //https://cloud.tencent.com/document/product/607/15221#.E8.A7.A6.E5.8F.91.E4.BA.8B.E4.BB.B6.E5.9B.9E.E8.B0.83
    [EnginePollHelper createEnginePollHelper];
    NSLog(@"%ld",(long)result);
}

- (void)btnUnInitClick {
    QAVResult result = [[ITMGContext GetInstance] Uninit];
    if (result == QAV_OK) {
        self.isSDKInit = NO;
    }
    NSLog(@"%ld",(long)result);
}

- (void)btnPTTClick {
    if (!self.isSDKInit) {
        UIAlertController * alert = [UIAlertController alertControllerWithTitle:@"请先初始化sdk" message:NULL preferredStyle:UIAlertControllerStyleAlert];
        UIAlertAction * action = [UIAlertAction actionWithTitle:@"好的" style:UIAlertActionStyleDestructive handler:nil];
        [alert addAction:action];
        [self presentViewController:alert animated:YES completion:nil];
        return;
    }
    TMGPTTViewController *pttVC = [[TMGPTTViewController alloc]init];
    pttVC.openId = self.openIDTF.text;
    pttVC.authKey = self.keyTF.text;
    pttVC.appId = self.appIDTF.text;
    [self.navigationController pushViewController:pttVC animated:YES];
}

- (void)btnRealTimeClick {
    if (!self.isSDKInit) {
        UIAlertController * alert = [UIAlertController alertControllerWithTitle:@"请先初始化sdk" message:NULL preferredStyle:UIAlertControllerStyleAlert];
        UIAlertAction * action = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDestructive handler:nil];
        [alert addAction:action];
        [self presentViewController:alert animated:YES completion:nil];
        return;
    }
    TMGRealTimeViewController *rtVC = [[TMGRealTimeViewController alloc]init];
    rtVC.openId = self.openIDTF.text;
    rtVC.authKey = self.keyTF.text;
    rtVC.appId = self.appIDTF.text;
    [self.navigationController pushViewController:rtVC animated:YES];
}

- (void)backTap:(UITapGestureRecognizer *)tapGes {
    [self.view.window endEditing:YES];
}

#pragma mark - Lazy Loading

- (UIScrollView *)backScrollView {
    if (!_backScrollView) {
        _backScrollView = [[UIScrollView alloc]initWithFrame:self.view.bounds];
        _backScrollView.backgroundColor = [UIColor whiteColor];
        UITapGestureRecognizer *tapGes = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(backTap:)];
        [_backScrollView addGestureRecognizer:tapGes];
    }
    return _backScrollView;
}

- (UILabel *)appIDLabel {
    if (!_appIDLabel) {
        _appIDLabel = [[UILabel alloc]init];
        _appIDLabel.text = @"AppID";
        
    }
    return _appIDLabel;
}

-(UITextField *)appIDTF {
    if (!_appIDTF) {
        _appIDTF = [[UITextField alloc]init];
        _appIDTF.borderStyle = UITextBorderStyleRoundedRect;
    }
    return _appIDTF;
}

- (UILabel *)keyLabel {
    if (!_keyLabel) {
        _keyLabel = [[UILabel alloc]init];
        _keyLabel.text= @"key";
    }
    return _keyLabel;
}

-(UITextField *)keyTF {
    if (!_keyTF) {
        _keyTF = [[UITextField alloc]init];
        _keyTF.borderStyle = UITextBorderStyleRoundedRect;
        _keyTF.secureTextEntry = YES;

    }
    return _keyTF;
}

- (UILabel *)openIDLabel {
    if (!_openIDLabel) {
        _openIDLabel = [[UILabel alloc]init];
        _openIDLabel.text = @"openId";
    }
    return _openIDLabel;
}

-(UITextField *)openIDTF {
    if (!_openIDTF) {
        _openIDTF = [[UITextField alloc]init];
        _openIDTF.borderStyle = UITextBorderStyleRoundedRect;

    }
    return _openIDTF;
}

- (UIButton *)btnInit {
    if (!_btnInit) {
        _btnInit = [UIButton buttonWithType:UIButtonTypeSystem];
        [_btnInit setTitle:@"Init" forState:UIControlStateNormal];
        [_btnInit addTarget:self action:@selector(btnInitClick) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btnInit;
}

- (UIButton *)btnUnInit {
    if (!_btnUnInit) {
        _btnUnInit = [UIButton buttonWithType:UIButtonTypeSystem];
        [_btnUnInit setTitle:@"UnInit" forState:UIControlStateNormal];
        [_btnUnInit addTarget:self action:@selector(btnUnInitClick) forControlEvents:UIControlEventTouchUpInside];


    }
    return _btnUnInit;
}

- (UIButton *)btnPTT {
    if (!_btnPTT) {
        _btnPTT = [UIButton buttonWithType:UIButtonTypeSystem];
        [_btnPTT addTarget:self action:@selector(btnPTTClick) forControlEvents:UIControlEventTouchUpInside];
        [_btnPTT setTitle:@"语音消息与视频转文字（PTT）" forState:UIControlStateNormal];
        [_btnPTT.titleLabel setFont:[UIFont systemFontOfSize:15]];

    }
    return _btnPTT;
}

- (UIButton *)btnRealTime {
    if (!_btnRealTime) {
        _btnRealTime = [UIButton buttonWithType:UIButtonTypeSystem];
        [_btnRealTime addTarget:self action:@selector(btnRealTimeClick) forControlEvents:UIControlEventTouchUpInside];
        [_btnRealTime setTitle:@"实时语音（Real Time）" forState:UIControlStateNormal];
        [_btnRealTime.titleLabel setFont:[UIFont systemFontOfSize:15]];

    }
    return _btnRealTime;
}

@end
