#pragma once

#import <Foundation/Foundation.h>

#define QAV_RESULT(label, value) QAV_Result_##label = value

/*!
 @discussion    错误码，方法的返回值和异步回调请参考该错误码
 */
typedef NS_ENUM(NSInteger, QAVResult) {

    QAV_OK = 0,       ///< QAV_OK 成功操作。
///QAV_ERR_FAIL = 1,  如果需要对所有错误码统一处理，请使用!AV_OK；
///如果需要单独处理每一类错误，请关注接口返回的错误类型。
///此错误码没有明确含义，且2.4以后版本不再返回，故删除。
///---------------------------------------------------------------------------------------
/// @name 客户端错误
///---------------------------------------------------------------------------------------
  

    QAV_ERR_REPETITIVE_OPERATION = 1001,    ///< 重复操作。已经在进行某种操作，再次去做同样的操作，则返回这个错误。
    QAV_ERR_EXCLUSIVE_OPERATION  = 1002,    ///< 互斥操作。已经在进行某种操作，再次去做同类型的其他操作，则返回这个错误。
    QAV_ERR_HAS_IN_THE_STATE     = 1003,    ///< 已经处于所要状态，无需再操作。如设备已经打开，再次去打开，就返回这个错误码。
    QAV_ERR_INVALID_ARGUMENT     = 1004,    ///< 错误参数。
    QAV_ERR_TIMEOUT              = 1005,    ///< 操作超时。
    QAV_ERR_NOT_IMPLEMENTED      = 1006,    ///< 功能未实现。
    QAV_ERR_NOT_IN_MAIN_THREAD   = 1007,    ///< 不在主线程中执行操作

    QAV_ERR_CONTEXT_NOT_START    = 1101,    ///< AVContext没有启动。
    QAV_ERR_ROOM_NOT_EXIST       = 1201,    ///< 房间不存在。

    QAV_ERR_DEVICE_NOT_EXIST     = 1301,    ///< 设备不存在。

    QAV_ERR_SERVER_FAILED                    = 10001,   ///< 服务器返回一般错误
    QAV_ERR_SERVER_NO_PERMISSION             = 10003,   ///< 没有权限
    QAV_ERR_SERVER_REQUEST_ROOM_ADDRESS_FAIL = 10004,   ///< 进房间获取房间地址失败
    QAV_ERR_SERVER_CONNECT_ROOM_FAIL_INFO    = 10005,   ///< 进房间连接房间失败
    QAV_ERR_SERVER_FREE_FLOW_AUTH_FAIL       = 10006,   ///< 免流情况下，免流签名校验失败，导致进房获取房间地址失败
    QAV_ERR_SERVER_ROOM_DISSOLVED            = 10007,   ///< 游戏应用房间超过90分钟，强制下线

    QAV_ERR_IMSDK_FAIL                                     = 6999,          ///< IMSDK失败
    QAV_ERR_IMSDK_TIMEOUT                                  = 7000,          ///< IMSDK超时
    QAV_ERR_HTTP_REQ_FAIL                                   = 7001,
    QAV_ERR_3DVOICE_ERR_FILE_DAMAGED                        = 7002,//3d voice model file is damaged.
    QAV_ERR_3DVOICE_ERR_NOT_INITED                          = 7003,//should call InitSpatializer first
    QAV_ERR_UNKNOWN                                        = 65536,         ///< 无效值

    QAV_ERR_NET_REQUEST_FALLED = 7004,
    QAV_ERR_CHARGE_OVERDUE     = 7005,
    QAV_ERR_AUTH_FIALD         = 7006,
    QAV_ERR_IN_OTHER_ROOM      = 7007,
    QAV_ERR_DISSOLVED_OVERUSER = 7008,
    QAV_ERR_NO_PERMISSION      = 7009,
    QAV_ERR_FILE_CANNOT_ACCESS = 7010,
    QAV_ERR_FILE_DAMAGED       = 7011,
    QAV_ERR_SERVICE_NOT_OPENED = 7012,
    QAV_ERR_USER_CANCELED      = 7013,
    QAV_ERR_LOAD_LIB_FAILED    = 7014, 
    QAV_ERR_SDK_NOT_FULL_UPDATE= 7015,//升级SDK的时候没有升级所有的文件,导致某些模块不匹配@name 实时语音伴奏相关错误
    QAV_ERR_ROOMMANAGER_TIMESTAMP_CHECK_FAIL = 7016,
    QAV_ERR_ASR_CONNECT_CLOSED = 7017,
    QAV_ERR_MUTESWITCH_DECTECT_ERR = 7018,//iOS静音开关检测错误
///---------------------------------------------------------------------------------------
/// @name 实时语音伴奏相关错误
///---------------------------------------------------------------------------------------
    QAV_ERR_ACC_OPENFILE_FAILED                 = 4001,        ///< 打开文件失败
    QAV_ERR_ACC_FILE_FORAMT_NOTSUPPORT          = 4002,        ///< 不支持的文件格式
    QAV_ERR_ACC_DECODER_FAILED                  = 4003,        ///< 解码失败
    QAV_ERR_ACC_BAD_PARAM                       = 4004,        ///< 参数错误
    QAV_ERR_ACC_MEMORY_ALLOC_FAILED             = 4005,        ///< 内存分配失败
    QAV_ERR_ACC_CREATE_THREAD_FAILED            = 4006,        ///< 创建线程失败
    QAV_ERR_ACC_STATE_ILLIGAL                   = 4007,        ///< 状态非法
    QAV_ERR_START_ACC_FIRST                     = 4008,        ///< 设备采集播放延迟录制开始前,要先开启伴奏
    QAV_ERR_START_ACC_IS_STARTED                = 4009,        ///< 设备采集播放延迟预览开始前,要先停止伴奏
    QAV_ERR_HARDWARE_TEST_RECORD_IS_STARTED     = 4010,        ///<设备采集播放延迟预览前,要先停止录制
    QAV_ERR_HARDWARE_TEST_PREVIEW_IS_STARTED    = 4011,        ///<设备采集播放延迟录制开始前,要先停止预览
    QAV_ERR_HARDWARE_TEST_PREVIEW_DATA_IS_EMPTY = 4012,        ///<设备采集播放延迟录制开始前,要先停止预览

///---------------------------------------------------------------------------------------
/// @name 实时语音音效相关错误
///---------------------------------------------------------------------------------------
    QAV_ERR_EFFECT_OPENFILE_FAILED         = 4051,        ///< 打开文件失败
    QAV_ERR_EFFECT_FILE_FORAMT_NOTSUPPORT  = 4052,        ///< 不支持的文件格式
    QAV_ERR_EFFECT_DECODER_FAILED          = 4053,        ///< 解码失败
    QAV_ERR_EFFECT_BAD_PARAM               = 4054,       ///< 参数错误
    QAV_ERR_EFFECT_MEMORY_ALLOC_FAILED     = 4055,       ///< 内存分配失败
    QAV_ERR_EFFECT_CREATE_THREAD_FAILED    = 4056,        ///< 创建线程失败
    QAV_ERR_EFFECT_STATE_ILLIGAL           = 4057,        ///< 状态非法
    
    QAV_ERR_SYSTEM_AUDIO_HOOK_NOT_FIND_DRIVER = 6002,
    QAV_ERR_SYSTEM_AUDIO_HOOK_PRIVILEGEDTASK_LOAD_FAILED = 6003,
    QAV_ERR_SYSTEM_AUDIO_HOOK_NEED_RESTART_APP = 6004,
    QAV_ERR_SYSTEM_AUDIO_HOOK_SYSTEM_ERROR = 6005,
    QAV_ERR_SYSTEM_AUDIO_HOOK_DRIVER_INSTALL_FAILED = 6006,
    //for recorder
    QAV_ERR_VOICE_RECORDER_PARAM_NULL                    = 0x1001,
    QAV_ERR_VOICE_RECORDER_INIT_ERROR                    = 0x1002,
    QAV_ERR_VOICE_RECORDER_RECORDING_ERROR               = 0x1003,
    QAV_ERR_VOICE_RECORDER_NO_AUDIO_DATA_WARN            = 0x1004,
    QAV_ERR_VOICE_RECORDER_OPENFILE_ERROR                = 0x1005,
    QAV_ERR_VOICE_RECORDER_MIC_PERMISSION_ERROR          = 0x1006,
    QAV_ERR_VOICE_RECORDER_VOICE_RECORD_TOO_SHORT        = 0x1007,
    QAV_ERR_VOICE_RECORD_NOT_START                       = 0x1008,
    
    QAV_ERR_VOICE_UPLOAD_FILE_ACCESSERROR                = 0x2001, //读文件错误
    QAV_ERR_VOICE_UPLOAD_SIGN_CHECK_FAIL                 = 0x2002, //鉴权失败
    QAV_ERR_VOICE_UPLOAD_COS_INTERNAL_FAIL               = 0x2003, //上传cos失败
    QAV_ERR_VOICE_UPLOAD_GET_TOKEN_NETWORK_FAIL          = 0x2004, // 访问业务服务器的时候网络出错
    QAV_ERR_VOICE_UPLOAD_SYSTEM_INNER_ERROR              = 0x2005, //服务器内部错误
    QAV_ERR_VOICE_UPLOAD_RSP_DATA_DECODE_FAIL            = 0x2006, //解析json失败
    QAV_ERR_VOICE_UPLOAD_APPINFO_UNSET                   = 0x2008, //未设置ptt authbuffer

    //for downlaod
    QAV_ERR_VOICE_DOWNLOAD_FILE_ACCESS_ERROR             = 0x3001,       //12289 写文件失败
    QAV_ERR_VOICE_DOWNLOAD_SIGN_CHECK_FAIL               = 0x3002,       //12290 TLS签名校验失败，可以尝试重新获取
    QAV_ERR_VOICE_DOWNLOAD_COS_INTERNAL_FAIL             = 0x3003,       //12291 COS存储系统内部失败
    QAV_ERR_VOICE_DOWNLOAD_REMOTEFILE_ACCESS_ERROR       = 0x3004,       //12292 访问cos失败
    QAV_ERR_VOICE_DOWNLOAD_GET_SIGN_NETWORK_FAIL         = 0x3005,       //12293 获取下载参数过程中，http网络失败
    QAV_ERR_VOICE_DOWNLOAD_SYSTEM_INNER_ERROR            = 0x3006,       //12294 业务服务器内部错误
    QAV_ERR_VOICE_DOWNLOAD_GET_SIGN_RSP_DATA_DECODE_FAIL = 0x3007,       //12295 获取下载参数过程中，回包解包失败
    QAV_ERR_VOICE_DOWNLOAD_APPINFO_UNSET                 = 0x3009,       //12297 app info为空

    //for player
    QAV_ERR_VOICE_PLAYER_INIT_ERROR                      = 0x5001, //内部错误 如初始化播放器错误,解码失败等等，需要结合日志定位问题
    QAV_ERR_VOICE_PLAYER_PLAYING_ERROR                   = 0x5002, //
    QAV_ERR_VOICE_PLAYER_PARAM_NULL                      = 0x5003, //参数为空
    QAV_ERR_VOICE_PLAYER_OPEN_FILE_ERROR                 = 0x5004, //打开音频文件失败
    QAV_ERR_VOICE_PLAYER_NOT_START                       = 0x5005, //音频未开始播放
    
    //for s2t/streaming
    QAV_ERR_VOICE_S2T_INTERNAL_ERROR                     = 0x8001,       //32769 内部错误
    QAV_ERR_VOICE_S2T_NETWORK_FAIL                       = 0x8002,       //32770 http网络失败
    QAV_ERR_VOICE_S2T_RSP_DATA_DECODE_FAIL               = 0x8004,       //32772 回包解包失败
    QAV_ERR_VOICE_S2T_APPINFO_UNSET                      = 0x8006,       //32774 app info为空
    QAV_ERR_VOICE_STREAMIN_RECORD_SUC_REC_FAIL           = 0x8007,       //32775 流式语音转文本失败,音频文件上传失败,录音成功并保存在本地
    QAV_ERR_VOICE_S2T_SIGN_CHECK_FAIL                    = 0x8008,       //32776 authbuffer校验失败
    QAV_ERR_VOICE_STREAMIN_UPLOADANDRECORD_SUC_REC_FAIL  = 0x8009,       //32777 语音转文本失败,录音保存本地成功,上传音频文件到服务器成功了
    QAV_ERR_VOICE_ERR_VOICE_S2T__PARAM_NULL              = 0x8010,       //32784 file id is NULL
    QAV_ERR_VOICE_S2T_AUTO_SPEECH_REC_ERROR              = 0x8011,       //32785 AudioFileDecode error,asr error,http param error,etc
    QAV_ERR_VOICE_STREAMIN_RUNING_ERROR                  = 0x8012,       //32786
	QAV_ERR_VOICE_S2T_TRNSLATE_SERVICE_NOT_AVALIABLE     = 0x8013,       //Translate function service not avaliable
    QAV_ERR_VOICE_S2T_TRNSLATE_LANGUAGE_NOT_SUPPORTED    = 0x8014,       //Translate language not supported
    QAV_ERR_VOICE_S2T_TRNSLATE_FILEID_NOT_EXIST          = 0x8015,       //file ID not exist
};


