#pragma once
#include"tmg_type_adv.h"
#include <stdint.h>

class ITMGAudioRecordCtrl {
public:
	virtual ~ITMGAudioRecordCtrl(){};

	virtual int StartRecord(AUDIO_RECORDING_TYPE type, const char* dstFile, const char* accMixFile, const char* accPlayFile) = 0;
	virtual int StopRecord() = 0;
	virtual int PauseRecord() = 0;
	virtual int ResumeRecord() = 0;
	virtual int SetAccompanyFile(const char* accPlayFile) = 0;
	virtual int GetAccompanyTotalTimeByMs() = 0;
	virtual int SetRecordTimeByMs(int timePlay, int timeRecord) = 0;
	virtual int GetRecordTimeByMs() = 0;
	virtual int SetRecordKaraokeType(int type) = 0;
	virtual int GetRecordFileDurationByMs() = 0;

	virtual int StartPreview() = 0;
	virtual int StopPreview() = 0;
	virtual int PausePreview() = 0;
	virtual int ResumePreview() = 0;
	virtual int SetPreviewTimeByMs(int time) = 0;
	virtual int GetPreviewTimeByMs() = 0;
	virtual int SetMixWeights(float mic, float acc) = 0;
	virtual int AdjustAudioTimeByMs(int time) = 0;
	virtual int MixRecordFile(bool needMicData) = 0;
	virtual int CancelMixRecordFile() = 0;
	virtual int CleanTask() = 0;
};

QAVSDK_API ITMGAudioRecordCtrl* QAVSDK_CALL ITMGAudioRecordCtrlGetInstance();

class IAudioDataCallback {
 public:
    virtual void OnAudioDataCallback(AUDIO_DATA_TYPE audioDatType, uint64_t timestamp,
        int sampleRate, int channelCount, int bitsType, int length, unsigned char * pcmData) = 0;
};

class ITMGAudioDataObserver {
 public:
    virtual ~ITMGAudioDataObserver() {
    }

    virtual int RegisteAudioDataCallback(AUDIO_DATA_TYPE dataType, IAudioDataCallback* callback) = 0;

    virtual int UnRegisteAudioDataCallback(AUDIO_DATA_TYPE dataType) = 0;

    virtual int SetAudioDataFormat(AUDIO_DATA_TYPE audioType, int sampleRate, int channelCount) = 0;
};

QAVSDK_API ITMGAudioDataObserver* QAVSDK_CALL ITMGAudioDataObserverGetInstance();