// Copyright 1998-2017 Epic Games, Inc. All Rights Reserved.

using UnrealBuildTool;
using System;
using System.IO;

public class GMESDK : ModuleRules
{
#if WITH_FORWARDED_MODULE_RULES_CTOR
	public GMESDK(ReadOnlyTargetRules Target) : base(Target)
#else
    public GMESDK(TargetInfo Target)
#endif
	{
        string GMELibPath = string.Empty;
		string PluginPath = ModuleDirectory;
		System.Console.WriteLine("-------------- PluginPath = " + PluginPath);
        string GMEThirdPartyDir = Path.GetFullPath(Path.Combine(ModuleDirectory, "../ThirdParty/GMESDKLibrary"));
		System.Console.WriteLine("-------------- GMEThirdPartyDir = " + GMEThirdPartyDir);
        System.Console.WriteLine("-------------- GMEBuildTarget = " + Target.Platform);
		
		PrivatePCHHeaderFile = "Private/GMEAppDelegate.h";
		PublicIncludePaths.AddRange(
			new string[] {
				Path.Combine(PluginPath, "Public"),
				Path.Combine(PluginPath, "Public/GMESDK"),
				// ... add public include paths required here ...
			}
			);
		
		PrivateIncludePaths.AddRange(
			new string[] {
				Path.Combine(PluginPath, "Private"),
				// ... add other private include paths required here ...
			}
			);
			
		
		PublicDependencyModuleNames.AddRange(
			new string[]
			{
				"Core",
				"Projects",
				"GMESDKLibrary"
				// ... add other public dependencies that you statically link with here ...
			}
			);
			
		
		PrivateDependencyModuleNames.AddRange(
			new string[]
			{
				// ... add private dependencies that you statically link with here ...	
			}
			);		
		DynamicallyLoadedModuleNames.AddRange(
			new string[]
			{
				// ... add any modules that your module loads dynamically here ...
			}
			);

        if (Target.Platform == UnrealTargetPlatform.Android)
        {
            PrivateDependencyModuleNames.AddRange(new string[] { "Launch" });

            string aplPath = Path.Combine(PluginPath, "GMESDK_APL.xml");
            System.Console.WriteLine("-------------- AplPath = " + aplPath);
            //AdditionalPropertiesForReceipt.Add(new ReceiptProperty("AndroidPlugin", aplPath));
			AdditionalPropertiesForReceipt.Add("AndroidPlugin", aplPath); 
        }
        else if (Target.Platform == UnrealTargetPlatform.IOS )
        {
            PrivateIncludePaths.Add("GMESDK/Private/iOS");
            PublicIncludePaths.AddRange(new string[] {"Runtime/ApplicationCore/Public/Apple", "Runtime/ApplicationCore/Public/IOS"});

            PrivateDependencyModuleNames.AddRange(
                new string[]
                {
                    "ApplicationCore"
                    // ... add private dependencies that you statically link with here ...
                }
                );
        }

        if (Target.Platform == UnrealTargetPlatform.Win64)
        {
            string OSVersion = "x64";
            string libDir = OSVersion;
            GMELibPath = Path.Combine(GMEThirdPartyDir, libDir);
            Console.WriteLine("GMELibPath:" + GMELibPath);
			string libFilePath = Path.Combine(GMELibPath, "gmesdk.lib");
			Console.WriteLine("GMELibFilePath:" + GMELibPath);
			PublicAdditionalLibraries.Add(libFilePath);

            string binariesDir = Path.Combine(ModuleDirectory, "../../Binaries", Target.Platform.ToString());
            if (!Directory.Exists(binariesDir))
                Directory.CreateDirectory(binariesDir);

            string[] dllNames = new string[] {
                    "gmesdk.dll",
                    "libgmecrypto-1_1-x64.dll",
                    "libgmessl-1_1-x64.dll"
                };

            foreach (string dllName in dllNames)
            {
                RuntimeDependencies.Add("$(TargetOutputDir)/"+ dllName, Path.Combine(GMELibPath, dllName));
            }

            try
            {
                foreach (string dllName in dllNames)
                {
                    System.Console.WriteLine("src dll=" + dllName + " dst dir=" + binariesDir);
                    File.Copy(Path.Combine(GMELibPath, dllName), Path.Combine(binariesDir, dllName), true);
                }
            }
            catch (Exception e)
            {
                System.Console.WriteLine("copy dll exception,maybe have exists,err=", e.ToString());
            }
        }
#if UE_5_0_OR_LATER
#else
        else if (Target.Platform == UnrealTargetPlatform.Win32)
        {
            string OSVersion = "x86";
            string libDir = OSVersion;
            GMELibPath = Path.Combine(GMEThirdPartyDir, libDir);
            Console.WriteLine("GMELibPath:" + GMELibPath);
			string libFilePath = Path.Combine(GMELibPath, "gmesdk.lib");
			Console.WriteLine("GMELibFilePath:" + GMELibPath);
			PublicAdditionalLibraries.Add(libFilePath);

            string binariesDir = Path.Combine(ModuleDirectory, "../../Binaries", Target.Platform.ToString());
            if (!Directory.Exists(binariesDir))
                Directory.CreateDirectory(binariesDir);

            string[] dllNames = new string[] {
                    "gmesdk.dll",
                    "libgmecrypto-1_1.dll",
                    "libgmessl-1_1.dll"
                };

            foreach (string dllName in dllNames)
            {
               RuntimeDependencies.Add("$(TargetOutputDir)/" + dllName, Path.Combine(GMELibPath, dllName));
            }

            try
            {
                foreach (string dllName in dllNames)
                {
                    System.Console.WriteLine("src dll=" + dllName + " dst dir=" + binariesDir);
                    File.Copy(Path.Combine(GMELibPath, dllName), Path.Combine(binariesDir, dllName), true);
                }
            }
            catch (Exception e)
            {
                System.Console.WriteLine("copy dll exception,maybe have exists,err=", e.ToString());
            }
        }
		
		
#endif
        else if (Target.Platform == UnrealTargetPlatform.Android)
        {
            string libDir = ("Android/GME/libs");
            string ArchDir = "armeabi-v7a";
            GMELibPath = Path.Combine(Path.Combine(GMEThirdPartyDir, libDir), ArchDir);
            System.Console.WriteLine("--------------Android GME Lib path = " + GMELibPath);
            PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "libgmesdk.so"));

            ArchDir = "arm64-v8a";
            GMELibPath = Path.Combine(Path.Combine(GMEThirdPartyDir, libDir), ArchDir);
            System.Console.WriteLine("--------------Android GME Lib path = " + GMELibPath);
            PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "libgmesdk.so"));

            ArchDir = "x86";
            GMELibPath = Path.Combine(Path.Combine(GMEThirdPartyDir, libDir), ArchDir);
            System.Console.WriteLine("--------------Android GME Lib path = " + GMELibPath);
            PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "libgmesdk.so"));

            ArchDir = "x86_64";
            GMELibPath = Path.Combine(Path.Combine(GMEThirdPartyDir, libDir), ArchDir);
            System.Console.WriteLine("--------------Android GME Lib path = " + GMELibPath);
            PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "libgmesdk.so"));
        }
        else if (Target.Platform == UnrealTargetPlatform.Mac)
        {
            GMELibPath = GMEThirdPartyDir;
            string strLib = GMELibPath + "/Mac/libGMESDK.a";
            PublicAdditionalLibraries.Add(strLib);
            System.Console.WriteLine("---framework path:" + strLib);

            PublicAdditionalLibraries.AddRange(
                new string[] {
					"c++",
                    "z",
                    "iconv",
                    "resolv",
                }
                );

            PublicFrameworks.AddRange(
                new string[] {
                    "Foundation",
                    "AVFoundation",
                    "CoreTelephony",
                    "Security",
                    "SystemConfiguration",
                    "AudioToolbox",
                    "CoreMedia",
                    "CoreAudio",
                    "CoreVideo",
                    "OpenAL",
                }
                );
        }
        else if (Target.Platform == UnrealTargetPlatform.IOS)
        {
            GMELibPath = GMEThirdPartyDir;
            string strLib = GMELibPath + "/iOS/libGMESDK.a";
            PublicAdditionalLibraries.Add(strLib);
            System.Console.WriteLine("---framework path:" + strLib);

            PublicAdditionalLibraries.AddRange(
                new string[] {
                    "c++",
                    "c++.1",
                    "z",
                    "iconv",
                    "resolv",
                }
                );

            PublicFrameworks.AddRange(
                new string[] {
                    "Foundation",
                    "AVFoundation",
                    "CoreTelephony",
                    "Security",
                    "SystemConfiguration",
                    "AudioToolbox",
                    "CoreMedia",
                    "CoreAudio",
                    "CoreVideo",
                    "OpenAL",
                }
                );
        }
#if UE_4_26_OR_LATER
        else if (Target.Platform == UnrealTargetPlatform.Parse("PS5"))
        {
            GMELibPath = Path.Combine(GMEThirdPartyDir, "PS5");
			Console.WriteLine("PS5 GMELibPath:" + GMELibPath);
			PublicSystemLibraryPaths.Add(GMELibPath);
			PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "libGME.a"));
        }
#endif
#if UE_4_26_OR_LATER
        else if (Target.Platform == UnrealTargetPlatform.Parse("PS4"))
#else
        else if (Target.Platform == UnrealTargetPlatform.PS4)
#endif
        {
            GMELibPath = Path.Combine(GMEThirdPartyDir, "PS4");
			Console.WriteLine("PS4 GMELibPath:" + GMELibPath);
#if UE_4_26_OR_LATER
			PublicSystemLibraryPaths.Add(GMELibPath);
            PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "libGME.a"));
#else
            PublicLibraryPaths.Add(GMELibPath);
            PublicAdditionalLibraries.AddRange(
                new string[] {
                    "GME",
                    "UDT",
                    "TRAE",
                }
            );
#endif
        }
#if UE_4_26_OR_LATER
        else if (Target.Platform == UnrealTargetPlatform.Parse("XboxOne"))
#else
        else if (Target.Platform == UnrealTargetPlatform.XboxOne)
#endif
        {
            GMELibPath = Path.Combine(GMEThirdPartyDir, "XboxOne");
			Console.WriteLine("XboxOne GMELibPath:" + GMELibPath);
			PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "gmesdk.lib"));

            string binariesDir = Path.Combine(ModuleDirectory, "../../Binaries", Target.Platform.ToString());
            if (!Directory.Exists(binariesDir))
                Directory.CreateDirectory(binariesDir);

            string[] dllNames = new string[] {
                    "gmesdk.dll",
                };
        }
#if UE_4_26_OR_LATER
        else if (Target.Platform == UnrealTargetPlatform.Parse("Switch"))
#else
        else if (Target.Platform == UnrealTargetPlatform.Switch)
#endif
        {
            GMELibPath = Path.Combine(GMEThirdPartyDir, "NX64");
			Console.WriteLine("Switch GMELibPath:" + GMELibPath);
            PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "libGME.a"));
            PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "libTRAE.a"));
            PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "libUDT.a"));
		}
#if UE_4_26_OR_LATER
        else if (Target.Platform == UnrealTargetPlatform.Parse("XSX"))
        {
            GMELibPath = Path.Combine(GMEThirdPartyDir, Target.Platform.ToString());
            Console.WriteLine("GMELibPath:" + GMELibPath);
			
            PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "gmesdk.lib"));
			
            string binariesDir = Path.Combine(ModuleDirectory, "../../Binaries", Target.Platform.ToString());
            if (!Directory.Exists(binariesDir))
                Directory.CreateDirectory(binariesDir);

            string dllName = "gmesdk.dll";
            RuntimeDependencies.Add("$(TargetOutputDir)/" + dllName, Path.Combine(GMELibPath, dllName));
            // RuntimeDependencies.Add(Path.Combine(GMELibPath, dllName));
        }
#endif
        else
        {
            Console.WriteLine("GMESDK.build.cs Unsupported Platform by now!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Target = " + Target.Platform);
        }
    }
}

