/*
 * Decompiled with CFR 0.152.
 */
package com.gme.sharpgme.jni;

public class RingBuffer {
    private final int DEFAULT_SIZE = 1000;
    public int c_totalSize = 1000;
    public byte[] m_pBuf;
    public int m_read = 0;
    public int m_write = 0;
    public boolean m_isEmpty = true;

    public RingBuffer() {
        this.m_pBuf = null;
        this.c_totalSize = 1000;
        this.m_isEmpty = true;
        this.m_read = 0;
        this.m_write = 0;
        this.m_pBuf = new byte[this.c_totalSize];
    }

    public RingBuffer(int totalbufsize) {
        this.c_totalSize = totalbufsize;
        this.m_isEmpty = true;
        this.m_read = 0;
        this.m_write = 0;
        this.m_pBuf = new byte[this.c_totalSize];
    }

    public void Push(byte[] pBuf, int len) {
        if (this.m_pBuf == null) {
            return;
        }
        if (this.RemainWrite() < len) {
            return;
        }
        if (this.c_totalSize - this.m_write >= len) {
            System.arraycopy(pBuf, 0, this.m_pBuf, this.m_write, len);
        } else {
            System.arraycopy(pBuf, 0, this.m_pBuf, this.m_write, this.c_totalSize - this.m_write);
            System.arraycopy(pBuf, this.c_totalSize - this.m_write, this.m_pBuf, 0, len - (this.c_totalSize - this.m_write));
        }
        this.m_write = (this.m_write + len) % this.c_totalSize;
        this.m_isEmpty = false;
    }

    public int RemainRead() {
        if (this.m_write < this.m_read) {
            return this.c_totalSize - this.m_read + this.m_write;
        }
        if (this.m_write > this.m_read) {
            return this.m_write - this.m_read;
        }
        return this.m_isEmpty ? 0 : this.c_totalSize;
    }

    public int RemainWrite() {
        return this.c_totalSize - this.RemainRead();
    }

    public void Clear() {
        this.m_read = this.m_write = 0;
        this.m_isEmpty = true;
    }

    public boolean Pop(byte[] pBuf, int len) {
        if (this.m_pBuf == null) {
            return false;
        }
        if (this.RemainRead() < len || len <= 0) {
            return false;
        }
        if (this.c_totalSize - this.m_read >= len) {
            System.arraycopy(this.m_pBuf, this.m_read, pBuf, 0, len);
        } else {
            System.arraycopy(this.m_pBuf, this.m_read, pBuf, 0, this.c_totalSize - this.m_read);
            System.arraycopy(this.m_pBuf, 0, pBuf, this.c_totalSize - this.m_read, len - (this.c_totalSize - this.m_read));
        }
        this.m_read = (this.m_read + len) % this.c_totalSize;
        this.m_isEmpty = this.m_read == this.m_write;
        return true;
    }
}

