/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.util.Log;
import com.gme.av.sdk.GMELibLoader;
import com.gme.av.wrapper.GMEJavaInstance;

public class QLog {
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int VERBOSE = 4;
    private static volatile boolean useAvsdkLogger = true;

    public static void d(String tag, String msg) {
        if (useAvsdkLogger) {
            QLog.writeLog(3, tag, msg);
        } else {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void d(String tag, String msg, Exception e) {
        if (useAvsdkLogger) {
            QLog.writeLog(3, tag, msg, e);
        } else {
            Log.d((String)tag, (String)msg, (Throwable)e);
        }
    }

    public static void w(String tag, String msg) {
        if (useAvsdkLogger) {
            QLog.writeLog(1, tag, msg);
        } else {
            Log.w((String)tag, (String)msg);
        }
    }

    public static void w(String tag, String msg, Exception e) {
        if (useAvsdkLogger) {
            QLog.writeLog(1, tag, msg, e);
        } else {
            Log.w((String)tag, (String)msg, (Throwable)e);
        }
    }

    public static void e(String tag, String msg) {
        if (useAvsdkLogger) {
            QLog.writeLog(1, tag, msg);
        } else {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void e(String tag, String msg, Exception e) {
        if (useAvsdkLogger) {
            QLog.writeLog(1, tag, msg, e);
        } else {
            Log.e((String)tag, (String)msg, (Throwable)e);
        }
    }

    public static void i(String tag, String msg) {
        if (useAvsdkLogger) {
            QLog.writeLog(2, tag, msg);
        } else {
            Log.i((String)tag, (String)msg);
        }
    }

    public static void i(String tag, String msg, Exception e) {
        if (useAvsdkLogger) {
            QLog.writeLog(2, tag, msg, e);
        } else {
            Log.i((String)tag, (String)msg, (Throwable)e);
        }
    }

    public static void v(String tag, String msg) {
        if (useAvsdkLogger) {
            QLog.writeLog(4, tag, msg);
        } else {
            Log.i((String)tag, (String)msg);
        }
    }

    public static void v(String tag, String msg, Exception e) {
        if (useAvsdkLogger) {
            QLog.writeLog(4, tag, msg, e);
        } else {
            Log.i((String)tag, (String)msg, (Throwable)e);
        }
    }

    private static void writeLog(int level, String tag, String msg) {
        QLog.writeLog(level, tag, msg, null);
    }

    private static void writeLog(int level, String tag, String msg, Exception e) {
        String temp = String.format("[%s]%s", tag, msg);
        if (e != null) {
            temp = temp + ", " + Log.getStackTraceString((Throwable)e);
        }
        if (GMELibLoader.isLoadLibrary()) {
            QLog.nativeWriteLog(level, temp);
        } else {
            Log.i((String)tag, (String)("so not load. " + temp));
        }
    }

    private static native void nativeWriteLog(int var0, String var1);

    private static native String natvieGetLogDir();

    public static String getLogDir() {
        return QLog.natvieGetLogDir();
    }

    public static String getDefaultDir() {
        String externalFilesDir = "";
        try {
            Context context = null;
            context = GMEJavaInstance.getmActivity();
            if (context != null) {
                externalFilesDir = context.getExternalFilesDir(null).getAbsolutePath();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return externalFilesDir;
    }

    public static String getNativeLibraryDir() {
        String nativeLibraryDir = "";
        try {
            Context context = null;
            context = GMEJavaInstance.getmActivity();
            if (context != null) {
                ApplicationInfo appinfo = context.getApplicationInfo();
                nativeLibraryDir = appinfo.nativeLibraryDir;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nativeLibraryDir;
    }
}

