/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.ptt;

import android.util.Base64;
import com.gme.av.utils.QLog;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class TokenFetcher {
    public static final String TAG = "TokenFetcher";
    private int StreamRecTimeOut = 30;
    private final int MILLONSECOND = 1000;
    private static TokenFetcher s_instance = null;
    private AppInfo mAppInfo = new AppInfo();

    private TokenFetcher() {
        this.mAppInfo.sdk_appid = "1400029763";
        this.mAppInfo.appidat3rd = "1400029763";
        this.mAppInfo.accounttype = "12346";
        this.mAppInfo.authBuffer = null;
        this.mAppInfo.identifier = "354589908";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TokenFetcher getInstance() {
        Class<TokenFetcher> clazz = TokenFetcher.class;
        synchronized (TokenFetcher.class) {
            if (s_instance == null) {
                s_instance = new TokenFetcher();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_instance;
        }
    }

    public void setAppInfo(AppInfo info) {
        this.mAppInfo = info;
        if (this.mAppInfo.authBuffer != null) {
            String base64authBufferString = Base64.encodeToString((byte[])this.mAppInfo.authBuffer, (int)0);
            QLog.i(TAG, String.format("setAppInfo authbuffer=%s", base64authBufferString));
        } else {
            QLog.i(TAG, String.format("setAppInfo authbuffer is null", new Object[0]));
        }
    }

    public AppInfo getAppInfo() {
        return this.mAppInfo;
    }

    public void SetStreamingRecTimeOut(int TimeOut) {
        this.StreamRecTimeOut = TimeOut;
    }

    public void httpRequestWithBody(final String strUrl, final byte[] recordData, int end, final HttpRequestListener listener, final Object param) {
        Thread fetchTask = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int errCode = 0;
                String resp = "";
                OutputStream out = null;
                BufferedReader reader = null;
                HttpURLConnection conn = null;
                try {
                    URL url = new URL(strUrl);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(TokenFetcher.this.StreamRecTimeOut * 1000);
                    conn.setReadTimeout(TokenFetcher.this.StreamRecTimeOut * 1000);
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Connection", "Keep-Alive");
                    out = new DataOutputStream(conn.getOutputStream());
                    out.write(recordData);
                    out.flush();
                    int rcode = conn.getResponseCode();
                    if (rcode == 200) {
                        reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            resp = resp + line;
                        }
                    } else {
                        QLog.e(TokenFetcher.TAG, "httpRequestWithBody|connect failed. http response code =" + rcode);
                        errCode = rcode;
                    }
                    QLog.e(TokenFetcher.TAG, "httpRequestWithBody|rcode=" + rcode + ", strUrl=" + strUrl + ", resp=" + resp);
                }
                catch (IOException e) {
                    errCode = 1;
                    QLog.e(TokenFetcher.TAG, "httpRequestWithBody|IOException." + e.getMessage());
                    e.printStackTrace();
                }
                catch (Exception e) {
                    errCode = 1;
                    QLog.e(TokenFetcher.TAG, "httpRequestWithBody| unkown error." + e.getMessage());
                    e.printStackTrace();
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            QLog.e(TokenFetcher.TAG, e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            QLog.e(TokenFetcher.TAG, e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                    if (listener != null) {
                        listener.onCompleted(errCode, resp, param);
                    }
                }
            }
        });
        fetchTask.start();
    }

    public void httpRequest(final String strUrl, final String reqJson, final HttpRequestListener listener, final Object param) {
        Thread fetchTask = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int errCode = 0;
                String resp = "";
                OutputStream out = null;
                BufferedReader reader = null;
                HttpURLConnection conn = null;
                try {
                    URL url = new URL(strUrl);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(60000);
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Connection", "Keep-Alive");
                    out = new DataOutputStream(conn.getOutputStream());
                    out.write(reqJson.getBytes());
                    out.flush();
                    int rcode = conn.getResponseCode();
                    QLog.e(TokenFetcher.TAG, "httpRequest|rcode=" + rcode + ", strUrl=" + strUrl);
                    if (rcode == 200) {
                        reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            resp = resp + line;
                        }
                    } else {
                        QLog.e(TokenFetcher.TAG, "httpRequest|connect failed. http response code =" + rcode);
                        errCode = rcode;
                    }
                    QLog.e(TokenFetcher.TAG, "httpRequest|rcode=" + rcode + ", strUrl=" + strUrl + ", resp=" + resp);
                }
                catch (IOException e) {
                    errCode = 1;
                    QLog.e(TokenFetcher.TAG, "httpRequest|IOException.");
                    e.printStackTrace();
                    QLog.e(TokenFetcher.TAG, e.getMessage());
                }
                catch (Exception e) {
                    errCode = 1;
                    QLog.e(TokenFetcher.TAG, "httpRequest| unkown error.");
                    e.printStackTrace();
                    QLog.e(TokenFetcher.TAG, e.getMessage());
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            QLog.e(TokenFetcher.TAG, e.getMessage());
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            QLog.e(TokenFetcher.TAG, e.getMessage());
                        }
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                    if (listener != null) {
                        listener.onCompleted(errCode, resp, param);
                    }
                }
            }
        });
        fetchTask.start();
    }

    public static interface HttpRequestListener {
        public void onCompleted(int var1, String var2, Object var3);
    }

    public static class AppInfo {
        public String sdk_appid;
        public String accounttype;
        public byte[] authBuffer;
        public String identifier;
        public String appidat3rd;
    }
}

