/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.audiodispatcher;

import com.gme.av.audiodispatcher.GMEAudioBroadcast;
import com.gme.av.utils.QLog;
import com.gme.av.wrapper.GMEJavaInstance;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class AudioDispatcher {
    private static final String TAG = "AudioDispatcher";
    private static AudioDispatcher mAudioDispatcher;
    private static ArrayBlockingQueue<byte[]> mQueue;
    private static final int TRY_BIND_SOCKET_TIMES = 20;
    private SocketClient mSocketClient;
    private ServerSocket mServerSocket;
    private int mPort = 7878;
    private AtomicBoolean mIsSendingAudioData = new AtomicBoolean(false);
    private AtomicBoolean mIsWaitingClient = new AtomicBoolean(false);

    public static AudioDispatcher getInstance() {
        if (mAudioDispatcher == null) {
            mAudioDispatcher = new AudioDispatcher();
        }
        return mAudioDispatcher;
    }

    public void offerAudioData(byte[] data) {
        if (data != null) {
            if (mQueue.remainingCapacity() <= 1) {
                mQueue.poll();
            }
            mQueue.add(data);
        }
    }

    public boolean isNeedOfferAudioData() {
        return this.mIsSendingAudioData.get();
    }

    public void onAudioCaptureChange(boolean enable) {
        GMEAudioBroadcast.getInstance().onAudioCaptureChange(enable);
    }

    public void onAudioEnableBroadcast(boolean enable) {
        if (enable) {
            GMEAudioBroadcast.getInstance().registerBroadcast(GMEJavaInstance.getmActivity());
        } else {
            GMEAudioBroadcast.getInstance().unRegisterBroadcast(GMEJavaInstance.getmActivity());
        }
    }

    private byte[] pollAudioData() {
        return mQueue.poll();
    }

    private void clearAudioQueue() {
        mQueue.clear();
    }

    boolean startServer() {
        QLog.e(TAG, "startServer");
        if (this.mIsSendingAudioData.get()) {
            QLog.i(TAG, "AudioDispatcher is sending audio data. request refuse");
            return false;
        }
        if (this.mIsWaitingClient.get()) {
            QLog.i(TAG, "AudioDispatcher Server is ready and waiting accept.");
            return true;
        }
        this.mServerSocket = this.TryBindSocket();
        if (this.mServerSocket == null) {
            QLog.i(TAG, "AudioDispatcher Server TryBindSocket failed");
            return false;
        }
        QLog.i(TAG, "AudioDispatcher Server start");
        new AudioServer().start();
        return true;
    }

    public int getPort() {
        return this.mPort;
    }

    public void onRecordStateChange(boolean isRecord) {
        if (!isRecord) {
            QLog.e(TAG, "onRecordStateChange:" + isRecord + " try closeSocketClient");
            this.closeSocketClient();
        }
    }

    public void closeSocketClient() {
        if (this.mSocketClient != null) {
            this.mSocketClient.stopClient();
        }
    }

    private ServerSocket TryBindSocket() {
        ServerSocket serverSocket = null;
        int tryTimes = 0;
        boolean run = true;
        do {
            try {
                serverSocket = new ServerSocket(++this.mPort);
                QLog.e(TAG, "try to bind Socket" + this.mPort);
            }
            catch (BindException e) {
                e.printStackTrace();
                if (++tryTimes >= 20) break;
                QLog.e(TAG, "BindException" + e.getMessage());
                continue;
            }
            catch (IOException e) {
                QLog.e(TAG, "IOException" + e.getMessage());
                break;
            }
            run = false;
        } while (run);
        return serverSocket;
    }

    static {
        mQueue = new ArrayBlockingQueue(10);
    }

    class SocketClient
    extends Thread {
        private Socket mSocket;
        private boolean mFlag = true;

        public SocketClient(Socket socket) {
            this.mSocket = socket;
            AudioDispatcher.this.clearAudioQueue();
            AudioDispatcher.this.mIsSendingAudioData.set(true);
        }

        public void stopClient() {
            this.mFlag = false;
        }

        @Override
        public void run() {
            super.run();
            QLog.e(AudioDispatcher.TAG, "start Send audio data");
            try {
                DataOutputStream dos = new DataOutputStream(this.mSocket.getOutputStream());
                do {
                    byte[] outData;
                    if ((outData = AudioDispatcher.this.pollAudioData()) == null) {
                        Thread.sleep(10L);
                        continue;
                    }
                    dos.write(outData);
                } while (this.mFlag);
                dos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                QLog.e(AudioDispatcher.TAG, e.getMessage());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.mSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            AudioDispatcher.this.mIsSendingAudioData.set(false);
            QLog.e(AudioDispatcher.TAG, "stop Send audio data");
        }
    }

    class AudioServer
    extends Thread {
        private AudioServer() {
            QLog.e(AudioDispatcher.TAG, "AudioServer start");
            AudioDispatcher.this.mIsWaitingClient.set(true);
        }

        @Override
        public void run() {
            try {
                Socket socketClient = AudioDispatcher.this.mServerSocket.accept();
                AudioDispatcher.this.mSocketClient = new SocketClient(socketClient);
                AudioDispatcher.this.mSocketClient.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            AudioDispatcher.this.mIsWaitingClient.set(false);
            QLog.e(AudioDispatcher.TAG, "AudioServer end");
        }
    }
}

