/*
 * Decompiled with CFR 0.152.
 */
package com.gme.TMG;

import android.content.Intent;
import com.gme.TMG.ITMGAudioCtrl;
import com.gme.TMG.ITMGContext;
import com.gme.TMG.TMGCallbackHelper;
import com.gme.TMG.TMGContext;
import com.gme.av.audiodispatcher.AudioDispatcher;
import com.gme.av.utils.QLog;
import com.gme.sharpgme.jni.AudioDeviceInterface;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TMGAudioCtrl
extends ITMGAudioCtrl {
    TMGContext mTmgContext = null;
    private TimerTask _watchTimertask = null;
    private Timer _watchTimer = null;

    TMGAudioCtrl(TMGContext tmgContext) {
        this.mTmgContext = tmgContext;
    }

    @Override
    public int EnableAudioCaptureDevice(boolean isEnabled) {
        AudioDeviceInterface.setStartRecordRefuse(false);
        AudioDispatcher.getInstance().onRecordStateChange(isEnabled);
        return this.nativeEnableAudioCaptureDevice(isEnabled);
    }

    @Override
    public boolean IsAudioCaptureDeviceEnabled() {
        return this.nativeIsAudioCaptureDeviceEnabled();
    }

    @Override
    public int EnableAudioPlayDevice(boolean isEnabled) {
        return this.nativeEnableAudioPlayDevice(isEnabled);
    }

    @Override
    public boolean IsAudioPlayDeviceEnabled() {
        return this.nativeIsAudioPlayDeviceEnabled();
    }

    @Override
    public int SetSpeakerVolumeByOpenID(String openId, int volume) {
        return this.nativeSetSpeakerVolumeByOpenID(openId, volume);
    }

    @Override
    public int GetSpeakerVolumeByOpenID(String openId) {
        return this.nativeGetSpeakerVolumeByOpenID(openId);
    }

    @Override
    public int EnableAudioSend(boolean isEnabled) {
        AudioDeviceInterface.setStartRecordRefuse(false);
        return this.nativeEnableAudioSend(isEnabled);
    }

    @Override
    public int EnableAudioRecv(boolean isEnabled) {
        return this.nativeEnableAudioRecv(isEnabled);
    }

    @Override
    public boolean IsAudioSendEnabled() {
        return this.nativeIsAudioSendEnabled();
    }

    @Override
    public boolean IsAudioRecvEnabled() {
        return this.nativeIsAudioRecvEnabled();
    }

    @Override
    public int EnableMic(boolean isEnabled) {
        int ret1 = this.EnableAudioCaptureDevice(isEnabled);
        int ret2 = this.EnableAudioSend(isEnabled);
        if (ret1 == 0 && ret2 == 0) {
            return 0;
        }
        if (ret1 != 0) {
            return ret1;
        }
        return ret2;
    }

    @Override
    public int GetMicState() {
        return this.IsAudioCaptureDeviceEnabled() && this.IsAudioSendEnabled() ? 1 : 0;
    }

    @Override
    public int GetSpeakerState() {
        return this.IsAudioPlayDeviceEnabled() && this.IsAudioRecvEnabled() ? 1 : 0;
    }

    @Override
    public int EnableSpeaker(boolean isEnabled) {
        int ret1 = this.EnableAudioPlayDevice(isEnabled);
        int ret2 = this.EnableAudioRecv(isEnabled);
        if (ret1 == 0 && ret2 == 0) {
            return 0;
        }
        if (ret1 != 0) {
            return ret1;
        }
        return ret2;
    }

    @Override
    public int GetMicLevel() {
        return this.nativeGetMicDynamicVolume();
    }

    @Override
    public int SetMicVolume(int volume) {
        return this.nativeSetMicVolume(volume);
    }

    @Override
    public int GetMicVolume() {
        return this.nativeGetMicVolume();
    }

    @Override
    public int GetSpeakerLevel() {
        return this.nativeGetSpeakerDynamicVolume();
    }

    @Override
    public int SetSpeakerVolume(int volume) {
        return this.nativeSetSpeakerVolume(volume);
    }

    @Override
    public int GetSpeakerVolume() {
        return this.nativeGetSpeakerVolume();
    }

    @Override
    public int EnableLoopBack(boolean enable) {
        return this.nativeEnableLoopback(enable);
    }

    @Override
    public int AddAudioBlackList(String openId) {
        return this.nativeAddAudioBlackList(openId);
    }

    @Override
    public int RemoveAudioBlackList(String openId) {
        return this.nativeRemoveAudioBlackList(openId);
    }

    @Override
    public boolean IsOpenIdInAudioBlackList(String openId) {
        return this.nativeIsOpenIdInAudioBlackList(openId);
    }

    @Override
    public int GetSendStreamLevel() {
        return this.nativeGetDynamicVolumeById("");
    }

    @Override
    public int SetAudioMixCount(int count) {
        return this.nativeSetAudioMixCount(count);
    }

    @Override
    public int GetRecvStreamLevel(String openId) {
        return this.nativeGetDynamicVolumeById(openId);
    }

    @Override
    public int InitSpatializer(String modelPath) {
        return this.nativeInitSpatializer(modelPath);
    }

    @Override
    public int EnableSpatializer(boolean bEnable, boolean applyTeam) {
        return this.nativeEnableSpatializer(bEnable, applyTeam);
    }

    @Override
    public boolean IsEnableSpatializer() {
        return this.nativeIsEnableSpatializer();
    }

    @Override
    public int AddSameTeamSpatializer(String strOpenID3D) {
        return this.nativeAddSameTeamSpatializer(strOpenID3D);
    }

    @Override
    public int RemoveSameTeamSpatializer(String strOpenID3D) {
        return this.nativeRemoveSameTeamSpatializer(strOpenID3D);
    }

    @Override
    public int AddSpatializerBlacklist(String strOpenID3D) {
        return this.nativeAddSpatializerBlacklist(strOpenID3D);
    }

    @Override
    public int RemoveSpatializerBlacklist(String strOpenID3D) {
        return this.nativeRemoveSpatializerBlacklist(strOpenID3D);
    }

    @Override
    public int ClearSpatializerBlacklist() {
        return this.nativeClearSpatializerBlacklist();
    }

    @Override
    public int TrackingVolume(float fTrackingTimeS) {
        QLog.i("API", String.format("TrackingVolume. times=%s", Float.valueOf(fTrackingTimeS)));
        return this.nativeTrackingVolume(fTrackingTimeS);
    }

    @Override
    public int StopTrackingVolume() {
        QLog.i("API", "StopTrackingVolume");
        return this.nativeStopTrackingVolume();
    }

    @Override
    public int EnableAudioDispatcher(boolean enable) {
        return this.nativeEnableAudioDispatcher(enable);
    }

    private void UpdateSpeakingMemberVolume(String userVolumes) throws JSONException {
        QLog.i("API", "UpdateSpeakingMemberVolume\uff1a" + userVolumes);
        if (this.mTmgContext != null) {
            HashMap<String, Integer> mapRet = new HashMap<String, Integer>();
            if (userVolumes != null && userVolumes.length() > 0) {
                JSONArray root = new JSONArray(userVolumes);
                for (int i = 0; i < root.length(); ++i) {
                    JSONObject obj = root.getJSONObject(i);
                    String openId = obj.getString("open_id");
                    String volume = obj.getString("volume");
                    mapRet.put(openId, Integer.valueOf(volume));
                }
            }
            if (this.mTmgContext.mTmgDelegate != null) {
                Intent it = TMGCallbackHelper.GetMapIntent(mapRet);
                this.mTmgContext.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVNET_TYPE_USER_VOLUMES, it);
            }
        }
    }

    public native int nativeSetSpeakerVolumeByOpenID(String var1, int var2);

    public native int nativeGetSpeakerVolumeByOpenID(String var1);

    public native int nativeSetMicVolume(int var1);

    public native int nativeGetMicVolume();

    public native int nativeGetMicDynamicVolume();

    public native int nativeGetDynamicVolumeById(String var1);

    public native int nativeSetSpeakerVolume(int var1);

    public native int nativeGetSpeakerVolume();

    public native int nativeGetSpeakerDynamicVolume();

    public native int nativeEnableAudioCaptureDevice(boolean var1);

    public native int nativeEnableAudioPlayDevice(boolean var1);

    public native boolean nativeIsAudioCaptureDeviceEnabled();

    public native boolean nativeIsAudioPlayDeviceEnabled();

    public native int nativeEnableAudioSend(boolean var1);

    public native int nativeEnableAudioRecv(boolean var1);

    public native boolean nativeIsAudioSendEnabled();

    public native boolean nativeIsAudioRecvEnabled();

    public native int nativeEnableLoopback(boolean var1);

    public native int nativeAddAudioBlackList(String var1);

    public native int nativeRemoveAudioBlackList(String var1);

    public native boolean nativeIsOpenIdInAudioBlackList(String var1);

    public native int nativeSetAudioMixCount(int var1);

    public native int nativeInitSpatializer(String var1);

    public native int nativeEnableSpatializer(boolean var1, boolean var2);

    public native boolean nativeIsEnableSpatializer();

    public native int nativeEnableAudioDispatcher(boolean var1);

    public native int nativeAddSameTeamSpatializer(String var1);

    public native int nativeRemoveSameTeamSpatializer(String var1);

    public native int nativeAddSpatializerBlacklist(String var1);

    public native int nativeRemoveSpatializerBlacklist(String var1);

    public native int nativeClearSpatializerBlacklist();

    public native int nativeTrackingVolume(float var1);

    public native int nativeStopTrackingVolume();
}

