/*
 * Decompiled with CFR 0.152.
 */
package com.gme.sharpgme.jni;

import android.content.Context;
import android.media.AudioManager;
import com.gme.av.utils.ClientInfo;
import java.util.StringTokenizer;

public class VivoKTVHelper {
    private static final String TAG = "VivoKTVHelper";
    private static final String KEY_KTV_MODE = "vivo_ktv_mode";
    private static final String KEY_VOL_MIC = "vivo_ktv_volume_mic";
    private static final String KEY_MIC_SRC = "vivo_ktv_rec_source";
    private static final String KEY_MIC_TYPE = "vivo_ktv_mic_type";
    private static final String KEY_PRESET = "vivo_ktv_preset_effect";
    private static final String KEY_PLAY_SRC = "vivo_ktv_play_source";
    private static final String KEY_EXT_SPKR = "vivo_ktv_ext_speaker";
    private final Object mParamLock = new Object();
    private AudioManager mAudioManager;
    private Context mContext;
    private static VivoKTVHelper mVivoKTVHelper;

    public VivoKTVHelper(Context context) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    public static VivoKTVHelper getInstance(Context context) {
        if (mVivoKTVHelper == null) {
            mVivoKTVHelper = new VivoKTVHelper(context);
        }
        return mVivoKTVHelper;
    }

    public boolean isDeviceSupportKaraoke() {
        String build = ClientInfo.MODEL;
        if (build.trim().contains("vivo")) {
            String value;
            int state;
            String result = this.mAudioManager.getParameters(KEY_MIC_TYPE);
            StringTokenizer st = new StringTokenizer(result, "=");
            int tokens = st.countTokens();
            if (tokens != 2) {
                return false;
            }
            String tag = st.nextToken();
            if (tag.equals(KEY_MIC_TYPE) && ((state = Integer.parseInt(value = st.nextToken())) == 1 || state == 0)) {
                return true;
            }
        }
        return false;
    }

    public void openKTVDevice() {
        this.mAudioManager.setParameters("vivo_ktv_mode=1");
        this.isDeviceSupportKaraoke();
    }

    public void closeKTVDevice() {
        this.mAudioManager.setParameters("vivo_ktv_mode=0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMicVolParam(int param) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append(KEY_VOL_MIC).append("=").append(param);
                this.mAudioManager.setParameters(sBuilder.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoiceOutParam(int param) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                this.mAudioManager.setParameters("vivo_ktv_rec_source=" + param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreModeParam(int param) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                this.mAudioManager.setParameters("vivo_ktv_preset_effect=" + param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayFeedbackParam(int param) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                this.mAudioManager.setParameters("vivo_ktv_play_source=" + param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtSpeakerParam(int param) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append(KEY_EXT_SPKR).append("=").append(param);
                this.mAudioManager.setParameters(sBuilder.toString());
            }
        }
    }

    public int getExtSpeakerParam() {
        return this.getKTVParam(KEY_EXT_SPKR);
    }

    public int getPlayFeedbackParam() {
        return this.getKTVParam(KEY_PLAY_SRC);
    }

    public int getPreModeParam() {
        return this.getKTVParam(KEY_PRESET);
    }

    public int getMicTypeParam() {
        return this.getKTVParam(KEY_MIC_TYPE);
    }

    public int getVoiceOutParam() {
        return this.getKTVParam(KEY_MIC_SRC);
    }

    public int getMicVolParam() {
        return this.getKTVParam(KEY_VOL_MIC);
    }

    private int getKTVParam(String tag) {
        String tagret;
        String result;
        StringTokenizer st;
        int tokens;
        String build = ClientInfo.MODEL;
        if (build.trim().contains("vivo") && (tokens = (st = new StringTokenizer(result = this.mAudioManager.getParameters(tag), "=")).countTokens()) == 2 && tag.equals(tagret = st.nextToken())) {
            String value = st.nextToken();
            return Integer.parseInt(value.trim());
        }
        return 0;
    }
}

