/*
 * Decompiled with CFR 0.152.
 */
package com.gme.sharpgme.jni;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import com.gme.av.utils.ClientInfo;
import com.gme.av.utils.QLog;
import com.gme.sharpgme.jni.AudioDeviceInterface;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class TraeMediaPlayer
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    private static final String TAG = "TRAEJava";
    public static final int TRAE_MEDIAPLAER_DATASOURCE_RSID = 0;
    public static final int TRAE_MEDIAPLAER_DATASOURCE_URI = 1;
    public static final int TRAE_MEDIAPLAER_DATASOURCE_FILEPATH = 2;
    public static final int TRAE_MEDIAPLAER_STOP = 100;
    private MediaPlayer mMediaPlay = null;
    private OnCompletionListener mCallback;
    private Context _context;
    private int _streamType = 0;
    private boolean _hasCall = false;
    private boolean _loop = false;
    private int _durationMS = -1;
    int _loopCount = 0;
    boolean _ringMode = false;
    private Timer _watchTimer = null;
    private TimerTask _watchTimertask = null;
    private int _prevVolume = -1;

    public TraeMediaPlayer(Context context, OnCompletionListener cb) {
        this._context = context;
        this.mCallback = cb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playRing(int datasource, int rsid, Uri res, String strFilePath, boolean loop, int loopCount, boolean ringMode, boolean hasCall, int callStreamType) {
        QLog.e(TAG, "TraeMediaPlay | playRing datasource:" + datasource + " rsid:" + rsid + " uri:" + res + " filepath:" + strFilePath + " loop:" + (loop ? "Y" : "N") + " :loopCount" + loopCount + " ringMode:" + (ringMode ? "Y" : "N") + " hasCall:" + hasCall + " cst:" + callStreamType);
        if (!loop && loopCount <= 0) {
            QLog.e(TAG, "TraeMediaPlay | playRing err datasource:" + datasource + " loop:" + (loop ? "Y" : "N") + " :loopCount" + loopCount);
            return false;
        }
        try {
            try {
                if (this.mMediaPlay != null) {
                    if (this.mMediaPlay.isPlaying()) {
                        return false;
                    }
                    try {
                        this.mMediaPlay.release();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.mMediaPlay = null;
                    }
                }
                if (this._watchTimer != null) {
                    this._watchTimer.cancel();
                    this._watchTimer = null;
                    this._watchTimertask = null;
                }
                AudioManager am = (AudioManager)this._context.getSystemService("audio");
                this.mMediaPlay = new MediaPlayer();
                if (null == this.mMediaPlay) {
                    this.mMediaPlay.release();
                    this.mMediaPlay = null;
                    return false;
                }
                this.mMediaPlay.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
                this.mMediaPlay.setOnErrorListener((MediaPlayer.OnErrorListener)this);
                switch (datasource) {
                    case 0: {
                        QLog.e(TAG, "TraeMediaPlay | rsid:" + rsid);
                        AssetFileDescriptor afd = this._context.getResources().openRawResourceFd(rsid);
                        if (afd == null) {
                            QLog.e(TAG, "TraeMediaPlay | afd == null rsid:" + rsid);
                            this.mMediaPlay.release();
                            this.mMediaPlay = null;
                            return false;
                        }
                        try {
                            this.mMediaPlay.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
                            break;
                        }
                        catch (Exception exception) {
                            break;
                        }
                        finally {
                            afd.close();
                        }
                    }
                    case 1: {
                        QLog.e(TAG, "TraeMediaPlay | uri:" + res);
                        this.mMediaPlay.setDataSource(this._context, res);
                        break;
                    }
                    case 2: {
                        QLog.e(TAG, "TraeMediaPlay | FilePath:" + strFilePath);
                        this.mMediaPlay.setDataSource(strFilePath);
                        break;
                    }
                    default: {
                        QLog.e(TAG, "TraeMediaPlay | err datasource:" + datasource);
                        this.mMediaPlay.release();
                        this.mMediaPlay = null;
                    }
                }
                if (this.mMediaPlay == null) {
                    return false;
                }
                this._ringMode = ringMode;
                int _mode = 0;
                if (this._ringMode) {
                    this._streamType = 2;
                    _mode = 1;
                } else {
                    this._streamType = 0;
                    if (ClientInfo.VERSION_SDK_INT >= 11) {
                        _mode = 3;
                    }
                }
                this._hasCall = hasCall;
                if (this._hasCall) {
                    this._streamType = callStreamType;
                }
                this.mMediaPlay.setAudioStreamType(this._streamType);
                this.mMediaPlay.prepare();
                this.mMediaPlay.setLooping(loop);
                this.mMediaPlay.start();
                this._loop = loop;
                if (this._loop) {
                    this._loopCount = 1;
                    this._durationMS = -1;
                } else {
                    this._loopCount = loopCount;
                    this._durationMS = this._loopCount * this.mMediaPlay.getDuration();
                }
                --this._loopCount;
                if (!this._hasCall) {
                    am.setMode(_mode);
                }
                if (this._durationMS > 0) {
                    this._watchTimer = new Timer();
                    this._watchTimertask = new TimerTask(){

                        @Override
                        public void run() {
                            if (TraeMediaPlayer.this.mMediaPlay != null) {
                                QLog.e(TraeMediaPlayer.TAG, "TraeMediaPlay | play timeout");
                                if (null != TraeMediaPlayer.this.mCallback) {
                                    TraeMediaPlayer.this.mCallback.onCompletion();
                                }
                            }
                        }
                    };
                    this._watchTimer.schedule(this._watchTimertask, this._durationMS + 1000);
                }
                QLog.e(TAG, "TraeMediaPlay | DurationMS:" + this.mMediaPlay.getDuration() + " loop:" + loop);
                return true;
            }
            catch (IllegalStateException ex) {
                QLog.d(TAG, "TraeMediaPlay | IllegalStateException: " + ex.getLocalizedMessage() + " " + ex.getMessage());
            }
            catch (IOException ex) {
                QLog.d(TAG, "TraeMediaPlay | IOException: " + ex.getLocalizedMessage() + " " + ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                QLog.d(TAG, "TraeMediaPlay | IllegalArgumentException: " + ex.getLocalizedMessage() + " " + ex.getMessage());
            }
            catch (SecurityException ex) {
                QLog.d(TAG, "TraeMediaPlay | SecurityException: " + ex.getLocalizedMessage() + " " + ex.getMessage());
            }
        }
        catch (Exception e) {
            QLog.d(TAG, "TraeMediaPlay | Except: " + e.getLocalizedMessage() + " " + e.getMessage());
        }
        try {
            this.mMediaPlay.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mMediaPlay = null;
        return false;
    }

    public void stopRing() {
        QLog.d(TAG, "TraeMediaPlay stopRing ");
        if (null == this.mMediaPlay) {
            return;
        }
        if (this.mMediaPlay.isPlaying()) {
            this.mMediaPlay.stop();
        }
        this.mMediaPlay.reset();
        try {
            if (this._watchTimer != null) {
                this._watchTimer.cancel();
                this._watchTimer = null;
                this._watchTimertask = null;
            }
            this.mMediaPlay.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mMediaPlay = null;
        this._durationMS = -1;
    }

    public int getStreamType() {
        return this._streamType;
    }

    public int getDuration() {
        return this._durationMS;
    }

    public boolean hasCall() {
        return this._hasCall;
    }

    public void onCompletion(MediaPlayer arg0) {
        AudioDeviceInterface.LogTraceEntry(" cb:" + this.mCallback + " loopCount:" + this._loopCount + " _loop:" + this._loop);
        if (this._loop) {
            QLog.d(TAG, "loop play,continue...");
            return;
        }
        try {
            if (this._loopCount <= 0) {
                this.volumeUndo();
                if (this.mMediaPlay.isPlaying()) {
                    this.mMediaPlay.stop();
                }
                this.mMediaPlay.reset();
                this.mMediaPlay.release();
                this.mMediaPlay = null;
                if (null != this.mCallback) {
                    this.mCallback.onCompletion();
                }
            } else {
                this.mMediaPlay.start();
                --this._loopCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AudioDeviceInterface.LogTraceExit();
    }

    public boolean onError(MediaPlayer arg0, int arg1, int arg2) {
        AudioDeviceInterface.LogTraceEntry(" cb:" + this.mCallback + " arg1:" + arg1 + " arg2:" + arg2);
        try {
            this.mMediaPlay.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mMediaPlay = null;
        if (null != this.mCallback) {
            this.mCallback.onCompletion();
        }
        AudioDeviceInterface.LogTraceExit();
        return false;
    }

    private void volumeDo() {
        if (this.mMediaPlay == null || !this._ringMode || this._streamType == 2) {
            return;
        }
        try {
            AudioManager am = (AudioManager)this._context.getSystemService("audio");
            int currV = am.getStreamVolume(this._streamType);
            int maxV = am.getStreamMaxVolume(this._streamType);
            int currRV = am.getStreamVolume(2);
            int maxRV = am.getStreamMaxVolume(2);
            int setV = (int)((double)currRV * 1.0 / (double)maxRV * (double)maxV);
            QLog.e(TAG, "TraeMediaPlay volumeDo currV:" + currV + " maxV:" + maxV + " currRV:" + currRV + " maxRV:" + maxRV + " setV:" + setV);
            setV = setV + 1 >= maxV ? maxV : ++setV;
            am.setStreamVolume(this._streamType, setV, 0);
            this._prevVolume = currV;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void volumeUndo() {
        if (this.mMediaPlay == null || !this._ringMode || this._streamType == 2 || this._prevVolume == -1) {
            return;
        }
        try {
            QLog.e(TAG, "TraeMediaPlay volumeUndo _prevVolume:" + this._prevVolume);
            AudioManager am = (AudioManager)this._context.getSystemService("audio");
            am.setStreamVolume(this._streamType, this._prevVolume, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface OnCompletionListener {
        public void onCompletion();
    }
}

