/*
 * Decompiled with CFR 0.152.
 */
package com.gme.kapalaiadapter;

import android.app.Dialog;
import android.content.Context;
import android.os.Message;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.gme.av.utils.QLog;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class ReflecterHelper {
    public static Class<?> mCurrentClass;

    public static final boolean setClass(String name) {
        Class<?> tmpClass = null;
        try {
            tmpClass = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        mCurrentClass = tmpClass;
        return mCurrentClass != null;
    }

    public static final int getStaticIntValue(String name, int defvalue) {
        int result = defvalue;
        Field field = ReflecterHelper.getField(name);
        if (field != null) {
            try {
                result = field.getInt(null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static final int getIntValue(Object owner, String name, int defvalue) {
        int result = defvalue;
        ReflecterHelper.setClass(owner.getClass().getName());
        Field field = ReflecterHelper.getField(name);
        if (field != null) {
            try {
                result = field.getInt(owner);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static final Field getField(String name) {
        Field field = null;
        try {
            field = mCurrentClass.getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return field;
    }

    public static Object getStaticProperty(String className, String fieldName) {
        ReflecterHelper.setClass(className);
        Field field = ReflecterHelper.getField(fieldName);
        Object result = null;
        if (field != null) {
            try {
                result = field.get(null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void setStaticProperty(String className, String fieldName, Object value) {
        ReflecterHelper.setClass(className);
        Field field = ReflecterHelper.getField(fieldName);
        if (field != null) {
            try {
                field.setAccessible(true);
                field.set(null, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Object newInstance(String className, Object[] args) throws Exception {
        Class<?> newoneClass = Class.forName(className);
        Constructor<?> cons = newoneClass.getConstructor(ReflecterHelper.getArgsClasses(args));
        return cons.newInstance(args);
    }

    public static Object newInstance(String className) throws Exception {
        return ReflecterHelper.newInstance(className, null);
    }

    public static Object invokeMethod(Object owner, String methodName, Object[] args) throws Exception {
        return ReflecterHelper.invokeMethod(owner, methodName, ReflecterHelper.getArgsClasses(args), args);
    }

    public static Object invokeMethod(Object owner, String methodName) throws Exception {
        return ReflecterHelper.invokeMethod(owner, methodName, null);
    }

    public static Object invokeMethod(Object owner, String methodName, Class<?>[] argsClass, Object[] args) throws Exception {
        Class<?> ownerClass = owner.getClass();
        Method method = ownerClass.getMethod(methodName, argsClass);
        method.setAccessible(true);
        return method.invoke(owner, args);
    }

    public static Object getProperty(Object owner, String fieldName) throws Exception {
        Class<?> ownerClass = owner.getClass();
        Field field = ownerClass.getField(fieldName);
        Object property = field.get(owner);
        return property;
    }

    public static void setProperty(Object owner, String fieldName, Object value) throws Exception {
        Class<?> ownerClass = owner.getClass();
        Field field = ownerClass.getField(fieldName);
        field.setAccessible(true);
        field.set(owner, value);
    }

    public static Object newInstance(String className, Object[] args, Class<?>[] argsClass) throws Exception {
        Class<?> newoneClass = Class.forName(className);
        Constructor<?> cons = newoneClass.getConstructor(argsClass);
        return cons.newInstance(args);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args, Class<?>[] argsClass) throws Exception {
        Class<?> cls = Class.forName(className);
        Method staticMethod = null;
        Object ret = null;
        staticMethod = cls.getDeclaredMethod(methodName, argsClass);
        ret = staticMethod.invoke(cls, args);
        return ret;
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args) throws Exception {
        return ReflecterHelper.invokeStaticMethod(className, methodName, args, ReflecterHelper.getArgsClasses(args));
    }

    public static Object invokeStaticMethod(String className, String methodName) throws Exception {
        return ReflecterHelper.invokeStaticMethod(className, methodName, null);
    }

    private static Class<?>[] getArgsClasses(Object[] args) {
        Class[] argsClass = null;
        if (args != null) {
            argsClass = new Class[args.length];
            int j = args.length;
            for (int i = 0; i < j; ++i) {
                argsClass[i] = args[i] != null ? args[i].getClass() : String.class;
                if (argsClass[i] == Integer.class) {
                    argsClass[i] = Integer.TYPE;
                    continue;
                }
                if (argsClass[i] != Boolean.class) continue;
                argsClass[i] = Boolean.TYPE;
            }
        }
        return argsClass;
    }

    public static void fixInputMethodManagerLeak(Context destContext) {
        if (destContext == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)destContext.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        String[] arr = new String[]{"mCurRootView", "mServedView", "mNextServedView"};
        Field f = null;
        Object obj_get = null;
        for (int i = 0; i < arr.length; ++i) {
            String param = arr[i];
            try {
                f = imm.getClass().getDeclaredField(param);
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((obj_get = f.get(imm)) == null || !(obj_get instanceof View)) continue;
                View v_get = (View)obj_get;
                if (v_get.getContext() == destContext) {
                    f.set(imm, null);
                    continue;
                }
                QLog.d(ReflecterHelper.class.getSimpleName(), "fixInputMethodManagerLeak break, context is not suitable, get_context=" + v_get.getContext() + " dest_context=" + destContext);
                break;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void fixMesssageLeak(Dialog dlg) {
        String[] arr;
        if (dlg == null) {
            return;
        }
        for (String param : arr = new String[]{"mDismissMessage", "mCancelMessage", "mShowMessage"}) {
            try {
                Object obj_get;
                Field f = Dialog.class.getDeclaredField(param);
                if (f == null) continue;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if (!((obj_get = f.get(dlg)) instanceof Message)) continue;
                Message msg = (Message)obj_get;
                if (msg.obj == null) continue;
                msg.obj = null;
                msg.what = 0;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

