/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.wrapper;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import com.gme.TMG.ITMGContext;
import com.gme.av.net.NetInfo;
import com.gme.av.ptt.PCMPlayer;
import com.gme.av.ptt.PttListener;
import com.gme.av.ptt.Recorder;
import com.gme.av.ptt.TokenFetcher;
import com.gme.av.ptt.TraeJni;
import com.gme.av.sdk.GMELibLoader;
import com.gme.av.sdk.HttpParam;
import com.gme.av.signature.GenerateTestUserSig;
import com.gme.av.utils.ClientInfo;
import com.gme.av.utils.CosFileTransfer;
import com.gme.av.utils.FileTransferUtils;
import com.gme.av.utils.QLog;
import com.gme.av.utils.S3FileTransfer;
import com.gme.av.wrapper.GMEAudioInterrupt;
import com.gme.av.wrapper.GMEJavaInstance;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class OpensdkGameWrapper
implements Recorder.OnQQRecorderListener {
    private static final String TAG = "OpensdkGameWrapper";
    private static Context mContext = null;
    private Recorder recorder = null;
    private PCMPlayer pcmPlayer = null;
    private long objPoint = 0L;
    private static OpensdkGameWrapper mSelf = null;

    public OpensdkGameWrapper(Context context) {
        mContext = context;
        GMEJavaInstance.InitJavaEnv(context);
        this.recorder = new Recorder(context);
        this.recorder.setQQRecorderListener(this);
        this.pcmPlayer = new PCMPlayer();
        SharedPreferences settings = context.getSharedPreferences("BuglySdkInfos", 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString("9c06d3bb60", GMELibLoader.getGMEVersion());
        editor.commit();
    }

    public Context getmContextCon() {
        return mContext;
    }

    public int CheckMicPermission() {
        int retCode = ITMGContext.ITMG_RECORD_PERMISSION.ITMG_PERMISSION_GRANTED.ordinal();
        try {
            String recordAudioStr = "android.permission.RECORD_AUDIO";
            if (ClientInfo.VERSION_SDK_INT >= 23 && mContext instanceof Activity) {
                Activity mActivity = (Activity)mContext;
                if (mActivity.checkSelfPermission(recordAudioStr) != 0) {
                    retCode = ITMGContext.ITMG_RECORD_PERMISSION.ITMG_PERMISSION_Denied.ordinal();
                    SharedPreferences tempPreference = mContext.getSharedPreferences("GMEApplyForAudioRecord", 0);
                    int preferencesInt = tempPreference.getInt("GMEApplyForAudioRecord", 0);
                    if (mActivity.shouldShowRequestPermissionRationale(recordAudioStr) || preferencesInt == 0) {
                        retCode = ITMGContext.ITMG_RECORD_PERMISSION.ITMG_PERMISSION_NotDetermined.ordinal();
                    }
                }
            } else {
                retCode = ITMGContext.ITMG_RECORD_PERMISSION.ITMG_PERMISSION_NotDetermined.ordinal();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            QLog.e(TAG, String.format("CheckMicPermission retCode is: 3", new Object[0]));
            retCode = ITMGContext.ITMG_RECORD_PERMISSION.ITMG_PERMISSION_ERROR.ordinal();
        }
        QLog.e(TAG, String.format("CheckMicPermission retCode is: %d", retCode));
        return retCode;
    }

    public int CheckMic() {
        int permission2 = this.CheckMicPermission();
        if (permission2 != ITMGContext.ITMG_RECORD_PERMISSION.ITMG_PERMISSION_GRANTED.ordinal()) {
            return ITMGContext.ITMG_CHECK_MIC_STATUS.ITMG_CHECK_MIC_STATUS_NO_GRANTED.ordinal();
        }
        return ITMGContext.ITMG_CHECK_MIC_STATUS.ITMG_CHECK_MIC_STATUS_AVAILABLE.ordinal();
    }

    public int initOpensdk() {
        QLog.i(TAG, "initOpensdk start.");
        int ret = OpensdkGameWrapper.loadSdkLibrary();
        if (ret == 0 || ret == 7015) {
            this.nativeInitOpensdk(mContext, QLog.getNativeLibraryDir());
            TraeJni.getInstance().initTRAE();
        }
        QLog.i(TAG, "initOpensdk end. ret:" + ret);
        return ret;
    }

    public static void startListening(boolean start) {
        QLog.i(TAG, "startListening start=" + start);
        GMEAudioInterrupt.getInstance(mContext);
        if (start) {
            GMEAudioInterrupt.initInterruptHandler();
        } else {
            GMEAudioInterrupt.uninitInterruptHandler();
        }
    }

    public static int loadSdkLibrary() {
        return GMELibLoader.loadSdkLibrary(mContext);
    }

    public native void nativeInitOpensdk(Context var1, String var2);

    public native void nativePlayRecordedFileCallback(int var1, String var2, long var3);

    public int playRecordedFile(String downloadFilePath, int audioCategory, final long objPoint) {
        QLog.i(TAG, String.format("playRecordedFile|audioCategory=%d|filePath= %s", audioCategory, downloadFilePath));
        PttListener.PlayFileListener internalPlayListener = new PttListener.PlayFileListener(){

            @Override
            public void onCompleted(int code, String filePath) {
                if (filePath == null) {
                    filePath = "";
                }
                QLog.i(OpensdkGameWrapper.TAG, String.format("playRecordedFile|onCompleted| code=%d, filePath=%s", code, filePath));
                OpensdkGameWrapper.this.nativePlayRecordedFileCallback(code, filePath, objPoint);
            }
        };
        try {
            this.pcmPlayer.initPCMPlayer(audioCategory);
            this.pcmPlayer.play(downloadFilePath, internalPlayListener);
        }
        catch (Exception e) {
            QLog.i(TAG, "play recording failed! e = " + e);
            internalPlayListener.onCompleted(20481, null);
        }
        return 0;
    }

    public int stopPlayFile() {
        QLog.i(TAG, "stopPlayFile.");
        this.pcmPlayer.stop();
        return 0;
    }

    public int getPlayingLevel() {
        return this.pcmPlayer.playLevel;
    }

    public int setPlayingGain(int gain) {
        this.pcmPlayer.playGain = gain;
        return this.pcmPlayer.playGain;
    }

    public boolean PathFileExit(String filePath) {
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean deleteFile(String fileName) {
        try {
            File file = new File(fileName);
            if (file.exists() && file.isFile()) {
                if (file.delete()) {
                    System.out.println("delete file failed" + fileName + "    success");
                    return true;
                }
                QLog.e(TAG, "delete file failed" + fileName);
                return false;
            }
            QLog.e(TAG, "delete file failed\uff1a" + fileName + "does not exit\uff01");
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static native void nativeHandleResponse(String var0, int var1, String var2, String var3, long var4);

    public void PostTextToURL(final String strURL, String postData, final String strRequestUserData, final long objPoint) {
        QLog.e(TAG, "uploadRecordedFile|strURL= " + strURL + "PostData:" + postData + "strRequestUserData:" + strRequestUserData);
        TokenFetcher.getInstance().httpRequest(strURL, postData, new TokenFetcher.HttpRequestListener(){

            @Override
            public void onCompleted(int ret, String resp, Object param) {
                OpensdkGameWrapper.nativeHandleResponse(strRequestUserData, ret, strURL, resp, objPoint);
            }
        }, strRequestUserData);
    }

    public void UploadFileToCos(final String strURL, String strFilePath, String strToken, final String strRequestUserData, final long objPoint) {
        QLog.e(TAG, "uploadRecordedFile|strURL= " + strURL + "strFilePath:" + strFilePath + "strToken:" + strToken);
        CosFileTransfer.uploadFile(strFilePath, strURL, strToken, 0x1400000, null, new FileTransferUtils.UploadFileListener(){

            @Override
            public void onCompleted(int code, String resp, Object param) {
                OpensdkGameWrapper.nativeHandleResponse(strRequestUserData, code, strURL, resp, objPoint);
            }
        });
    }

    public void DownloadFileFromCos(final String strURL, final String strFilePath, String strToken, final String strRequestUserData, final long objPoint) {
        QLog.i(TAG, "DownloadFileFromCos|strURL= " + strURL + "strFilePath:" + strFilePath + "strToken:" + strToken + "strRequestUserData:" + strRequestUserData);
        CosFileTransfer.downloadFile(strURL, strFilePath, strToken, null, new FileTransferUtils.DownloadFileListener(){

            @Override
            public void onCompleted(int code, Object param) {
                OpensdkGameWrapper.nativeHandleResponse(strRequestUserData, code, strURL, strFilePath, objPoint);
            }
        });
    }

    public void UploadFileToS3(final String strURL, String strFilePath, HttpParam params, final String strRequestUserData, final long objPoint) {
        QLog.i(TAG, "UploadFileToS3|strURL= " + strURL + "strFilePath:" + strFilePath + "strToken:" + params.signature + "strRequestUserData:" + strRequestUserData);
        S3FileTransfer.uploadFile(strFilePath, strURL, params, null, new FileTransferUtils.UploadFileListener(){

            @Override
            public void onCompleted(int code, String resp, Object param) {
                OpensdkGameWrapper.nativeHandleResponse(strRequestUserData, code, strURL, resp, objPoint);
            }
        });
    }

    public void DownloadFileFromS3(final String strURL, final String strFilePath, HttpParam params, final String strRequestUserData, final long objPoint) {
        QLog.i(TAG, "DownloadFileFromS3|strURL= " + strURL + "strFilePath:" + strFilePath + "strToken:" + params.signature + "strRequestUserData:" + strRequestUserData);
        S3FileTransfer.downloadFile(strURL, strFilePath, params, null, new FileTransferUtils.DownloadFileListener(){

            @Override
            public void onCompleted(int code, Object param) {
                OpensdkGameWrapper.nativeHandleResponse(strRequestUserData, code, strURL, strFilePath, objPoint);
            }
        });
    }

    public void PostStreamAudioData(final String strURL, byte[] dataBuffer, boolean end, final String strRequestUserData, final long objPoint) {
        int weatherEnd = end ? 1 : 0;
        QLog.e(TAG, "PostStreamAudioData|strURL= " + strURL + "end:" + weatherEnd + "strRequestUserData:" + strRequestUserData);
        TokenFetcher.getInstance().httpRequestWithBody(strURL, dataBuffer, weatherEnd, new TokenFetcher.HttpRequestListener(){

            @Override
            public void onCompleted(int ret, String resp, Object param) {
                OpensdkGameWrapper.nativeHandleResponse(strRequestUserData, ret, strURL, resp, objPoint);
            }
        }, strRequestUserData);
    }

    public int setRecordingGain(int gain) {
        this.recorder.recordGain = gain;
        return this.recorder.recordGain;
    }

    public int getRecordingLevel() {
        return this.recorder.recordLevel;
    }

    public void SetStreamingRecTimeOut(int timeOut) {
        TokenFetcher.getInstance().SetStreamingRecTimeOut(timeOut);
    }

    public void stopRecording() {
        this.recorder.stop();
    }

    public int startRecord(long point) {
        this.objPoint = point;
        if (this.recorder.initRecording()) {
            this.recorder.start();
            return 0;
        }
        return 4099;
    }

    public static String GenerateUUID() {
        return UUID.randomUUID().toString();
    }

    public static void DoNetDiagnose(String url, String publicIp) {
        ArrayList<String> resultArray = new ArrayList<String>();
        String reultString = "SSONetDiagnose start: ";
        reultString = reultString + url;
        resultArray.add(reultString);
        resultArray.add(publicIp);
        OpensdkGameWrapper.OutPutDNSServers(resultArray);
        OpensdkGameWrapper.DoDNSResolution(url, resultArray);
        if (resultArray != null && resultArray.size() > 0) {
            for (int i = 0; i < resultArray.size(); ++i) {
                String outPutString = resultArray.get(i);
                QLog.e("GMENetDiagnoseHelper |", outPutString);
            }
        }
    }

    public static byte[] turnPCM2SILE(byte[] input) {
        return TraeJni.getInstance().turnSilk(input, input.length);
    }

    public static void OutPutDNSServers(ArrayList<String> outPutArray) {
        List<String> array = NetInfo.getDNSServers();
        if (array != null && array.size() > 0) {
            for (int i = 0; i < array.size(); ++i) {
                String ipString = array.get(i);
                if (ipString.contains(".")) {
                    outPutArray.add("#" + (i + 1) + ". IPv4 DNS ip:" + ipString);
                    continue;
                }
                if (ipString.contains(":")) {
                    outPutArray.add("#" + (i + 1) + ". IPv6 DNS ip:" + ipString);
                    continue;
                }
                outPutArray.add("#" + (i + 1) + ".  DNS ip:" + ipString);
            }
        }
    }

    public static String base64EncodeUrl(String userId, String key) {
        GenerateTestUserSig.setSecretkey(key);
        return GenerateTestUserSig.genTestUserSig(userId);
    }

    public static void DoInterfaceTrace(String ipV4) {
        ArrayList<String> resultArray = new ArrayList<String>();
        String reultString = "InterfaceTrace start: ";
        resultArray.add(reultString);
        NetInfo.tracerout(ipV4, resultArray);
        if (resultArray != null && resultArray.size() > 0) {
            for (int i = 0; i < resultArray.size(); ++i) {
                String outPutString = resultArray.get(i);
                QLog.e("GMENetDiagnoseHelper targetIP:  ", ipV4 + "  |" + outPutString);
            }
        }
    }

    public static void DoDNSResolution(String url, ArrayList<String> outPutArray) {
        try {
            long startTime = System.currentTimeMillis();
            InetAddress[] addresses = InetAddress.getAllByName(url);
            long endTime = System.currentTimeMillis();
            outPutArray.add("DNS resolution cost :  " + (endTime - startTime) + "  ms");
            for (int i = 0; i < addresses.length; ++i) {
                String ipString;
                if (i == 0) {
                    outPutArray.add("DNS resolution url name : " + (addresses[i].getHostName() == null ? " " : addresses[i].getHostName()));
                }
                if ((ipString = addresses[i].getHostAddress()) != null) {
                    outPutArray.add("DNS resolution ip-" + (i + 1) + ": " + ipString);
                    NetInfo.tracerout(ipString, outPutArray);
                    String resultStr = OpensdkGameWrapper.nativetcping(ipString);
                    outPutArray.add(resultStr);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            outPutArray.add("DNS resolution failed" + e.toString());
        }
    }

    public static native String nativetcping(String var0);

    public static native void OnCaptureData(byte[] var0, int var1, long var2);

    public static native void OnCaptureDataOK(int var0, long var1);

    @Override
    public void onReceiveRecordData(byte[] data) {
        OpensdkGameWrapper.OnCaptureData(data, data.length, this.objPoint);
    }

    @Override
    public void onRecorderFailed(String path, int reason) {
        QLog.i(TAG, "on recorder failed! reason = " + reason);
        int recordErrorCode = 0;
        if (reason == 3) {
            recordErrorCode = 4102;
        } else if (reason == 2) {
            recordErrorCode = 4101;
        } else if (reason == 4) {
            recordErrorCode = 4098;
        } else if (reason == 1) {
            recordErrorCode = 4099;
        } else if (reason == 5) {
            recordErrorCode = 4103;
        }
        OpensdkGameWrapper.OnCaptureDataOK(recordErrorCode, this.objPoint);
    }

    @Override
    public void onRecorderPrepare(String path) {
        QLog.i(TAG, "on recorder prepare : path = " + path);
    }

    @Override
    public void onRecorderStart() {
        QLog.i(TAG, "on recorder start!");
    }

    @Override
    public void onBeginReceiveData() {
    }

    @Override
    public void onRecorderEnd() {
        QLog.i(TAG, "on recorder end!");
        int recordErrorCode = 0;
        OpensdkGameWrapper.OnCaptureDataOK(recordErrorCode, this.objPoint);
    }

    @Override
    public void onRecorderError(String path, String reason) {
        QLog.i(TAG, "on recorder error : path = " + path + " , reason = " + reason);
        int recordErrorCode = 4101;
        OpensdkGameWrapper.OnCaptureDataOK(recordErrorCode, this.objPoint);
    }

    @Override
    public void onRecorderAbnormal(int type) {
        QLog.i(TAG, "on recorder abnormal!");
        int recordErrorCode = 4100;
        OpensdkGameWrapper.OnCaptureDataOK(recordErrorCode, this.objPoint);
    }
}

