/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.utils;

import com.gme.av.ptt.SHA1Utils;
import com.gme.av.sdk.HttpParam;
import com.gme.av.sdk.UserConfigManager;
import com.gme.av.utils.QLog;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;

public class HttpHelper {
    private static final String TAG = "HttpHelper";
    private static final int HTTP_ERROR_CODE_UNKNOWN = 600;
    private static final int HTTP_ERROR_CODE_URL = 601;
    private static final int HTTP_ERROR_CODE_CONNECT = 602;
    private static final int HTTP_ERROR_CODE_TIMEOUT = 603;
    private static final int HTTP_ERROR_CODE_DNS = 604;
    private static final int HTTP_ERROR_CODE_SSL = 605;
    private static final int HTTP_ERROR_CODE_STATUSCODE_INVALID = 606;

    public static String getHost(String link) {
        String host = "";
        try {
            URL url = new URL(link);
            host = url.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return host;
    }

    public static boolean httpGetRequest(String url, String localFile, Object param, HttpRequestListener listener) {
        return HttpHelper.httpGetRequest(url, localFile, param, 5000, listener);
    }

    public static void doExceptionLog(String url) {
        InetAddress address = null;
        try {
            if (url != null) {
                address = InetAddress.getByName(HttpHelper.getHost(url));
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (address != null) {
            QLog.e(TAG, "doExceptionLog address.getHostAddress()=" + address.getHostAddress() + ", url=" + String.valueOf(url));
        } else {
            QLog.e(TAG, "doExceptionLog address null, url=" + String.valueOf(url));
        }
    }

    public static boolean httpGetRequest(final String url, final String localFile, final Object usrData, final int timeout, final HttpRequestListener listener) {
        QLog.i(TAG, "httpGetRequest|url = " + url + "|| http request timeout =" + timeout);
        Thread requestTask = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block54: {
                    HttpURLConnection conn = null;
                    InputStream in = null;
                    int errCode = 200;
                    String errInfo = "success.";
                    byte[] resp = null;
                    FileOutputStream fos = null;
                    try {
                        if (localFile != null && !localFile.isEmpty()) {
                            resp = localFile.getBytes();
                            fos = new FileOutputStream(new File(localFile));
                        }
                        conn = (HttpURLConnection)new URL(url).openConnection();
                        conn.setRequestMethod("GET");
                        conn.setConnectTimeout(timeout);
                        conn.setReadTimeout(timeout);
                        String customUserAgent = UserConfigManager.getValue("HttpUserAgent", "");
                        if (customUserAgent.length() > 0) {
                            conn.setRequestProperty("User-Agent", customUserAgent);
                        }
                        try {
                            conn.connect();
                        }
                        catch (MalformedURLException e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 601;
                            HttpHelper.doExceptionLog(url);
                        }
                        catch (UnknownHostException e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http request connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 604;
                            HttpHelper.doExceptionLog(url);
                        }
                        catch (SSLHandshakeException e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http request connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 605;
                            HttpHelper.doExceptionLog(url);
                        }
                        catch (SSLPeerUnverifiedException e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http request connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 605;
                            HttpHelper.doExceptionLog(url);
                        }
                        catch (SocketTimeoutException e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http request connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 603;
                            HttpHelper.doExceptionLog(url);
                        }
                        catch (Exception e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http request connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 602;
                            HttpHelper.doExceptionLog(url);
                        }
                        if (errCode != 200) {
                            return;
                        }
                        errCode = conn.getResponseCode();
                        if (errCode == 200) {
                            int n;
                            in = new BufferedInputStream(conn.getInputStream());
                            byte[] buf = new byte[1024];
                            int totalSize = conn.getContentLength();
                            int count = 0;
                            int temp = 0;
                            if (fos != null) {
                                while (true) {
                                    int n2;
                                    if ((n2 = in.read(buf)) < 0) {
                                        break block54;
                                    }
                                    fos.write(buf, 0, n2);
                                    count += n2;
                                    if ((temp += n2) < 204800) continue;
                                    temp = 0;
                                    if (!listener.onProcess(url, totalSize, count)) continue;
                                    fos.flush();
                                }
                            }
                            ByteArrayOutputStream bout = new ByteArrayOutputStream(10240);
                            while ((n = in.read(buf)) >= 0) {
                                bout.write(buf, 0, n);
                            }
                            resp = bout.toByteArray();
                            break block54;
                        }
                        if (errCode == -1) {
                            errCode = 606;
                        }
                        QLog.i(HttpHelper.TAG, "httpGetRequest|http request failed. http response code =" + errCode);
                        errInfo = "http request failed.";
                    }
                    catch (SocketTimeoutException e) {
                        QLog.e(HttpHelper.TAG, "httpGetRequest|http request failed.", e);
                        errInfo = e.getMessage();
                        errCode = 603;
                        HttpHelper.doExceptionLog(url);
                    }
                    catch (FileNotFoundException e) {
                        QLog.e(HttpHelper.TAG, "httpGetRequest|http request failed.", e);
                        errInfo = e.getMessage();
                        errCode = 7010;
                    }
                    catch (Exception e) {
                        QLog.e(HttpHelper.TAG, "httpGetRequest|http request failed.", e);
                        errInfo = e.getMessage();
                        errCode = 600;
                        HttpHelper.doExceptionLog(url);
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (conn != null) {
                            conn.disconnect();
                        }
                        if (listener != null) {
                            listener.onCompleted(url, errCode, errInfo, resp, usrData);
                        }
                    }
                }
            }
        });
        requestTask.start();
        return true;
    }

    public static boolean httpPostRequest(String url, byte[] req, Map<String, String> mapPropertys, Object param, HttpRequestListener listener) {
        return HttpHelper.httpPostRequest(url, req, mapPropertys, param, 5000, listener);
    }

    public static boolean httpPostRequest(final String url, final byte[] req, final Map<String, String> mapPropertys, final Object param, final int timeout, final HttpRequestListener listener) {
        QLog.i(TAG, "httpPostRequest|url = " + url + "|| http request timeout =" + timeout);
        Thread requestTask = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block38: {
                    byte[] resp;
                    String errInfo;
                    int errCode;
                    InputStream in;
                    HttpURLConnection conn;
                    block37: {
                        conn = null;
                        in = null;
                        errCode = 200;
                        errInfo = "success.";
                        resp = null;
                        conn = (HttpURLConnection)new URL(url).openConnection();
                        conn.setRequestMethod("POST");
                        conn.setConnectTimeout(timeout);
                        conn.setReadTimeout(timeout);
                        conn.setDoInput(true);
                        conn.setDoOutput(true);
                        conn.setRequestProperty("Connection", "close");
                        conn.setRequestProperty("Content-Length", String.valueOf(req.length));
                        conn.setRequestProperty("Content-Type", "application/json");
                        if (mapPropertys != null && !mapPropertys.isEmpty()) {
                            for (Map.Entry entry : mapPropertys.entrySet()) {
                                conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                        try {
                            conn.connect();
                        }
                        catch (MalformedURLException e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 601;
                            HttpHelper.doExceptionLog(url);
                        }
                        catch (UnknownHostException e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http request connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 604;
                            HttpHelper.doExceptionLog(url);
                        }
                        catch (SSLHandshakeException e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http request connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 605;
                            HttpHelper.doExceptionLog(url);
                        }
                        catch (SSLPeerUnverifiedException e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http request connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 605;
                            HttpHelper.doExceptionLog(url);
                        }
                        catch (SocketTimeoutException e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http request connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 603;
                            HttpHelper.doExceptionLog(url);
                        }
                        catch (Exception e) {
                            QLog.e(HttpHelper.TAG, "httpGetRequest|http request connect failed.", e);
                            errInfo = e.getMessage();
                            errCode = 602;
                            HttpHelper.doExceptionLog(url);
                        }
                        if (errCode != 200) {
                            return;
                        }
                        conn.getOutputStream().write(req);
                        errCode = conn.getResponseCode();
                        if (errCode == 200) {
                            int n;
                            in = new BufferedInputStream(conn.getInputStream());
                            ByteArrayOutputStream bout = new ByteArrayOutputStream(10240);
                            byte[] buf = new byte[1024];
                            while ((n = in.read(buf)) >= 0) {
                                bout.write(buf, 0, n);
                            }
                            resp = bout.toByteArray();
                        } else {
                            if (errCode == -1) {
                                errCode = 606;
                            }
                            QLog.i(HttpHelper.TAG, "httpPostRequest|http request failed. http response code =" + errCode);
                        }
                        if (in == null) break block37;
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                    if (listener != null) {
                        listener.onCompleted(url, errCode, errInfo, resp, param);
                    }
                    break block38;
                    catch (SocketTimeoutException e) {
                        QLog.e(HttpHelper.TAG, "httpGetRequest|http request failed.", e);
                        errInfo = e.getMessage();
                        errCode = 603;
                        HttpHelper.doExceptionLog(url);
                        break block38;
                    }
                    catch (Exception e) {
                        QLog.e(HttpHelper.TAG, "httpGetRequest|http request failed.", e);
                        errInfo = e.getMessage();
                        errCode = 600;
                        HttpHelper.doExceptionLog(url);
                        break block38;
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (conn != null) {
                            conn.disconnect();
                        }
                        if (listener != null) {
                            listener.onCompleted(url, errCode, errInfo, resp, param);
                        }
                    }
                }
            }
        });
        requestTask.start();
        return true;
    }

    public static boolean uploadFileToS3Request(final String strUrl, final String strFilePath, final HttpParam params, final HttpRequestListener listener) {
        Thread fetchTask = new Thread(new Runnable(){

            @Override
            public void run() {
                FileInputStream fis = null;
                HttpURLConnection conn = null;
                OutputStream out = null;
                InputStream in = null;
                int errCode = 200;
                String errInfo = "success.";
                byte[] resp = null;
                File srcFile = HttpHelper.openFile(strFilePath);
                if (srcFile == null) {
                    errCode = -1;
                } else {
                    String sha1 = SHA1Utils.getFileSHA1(strFilePath);
                    try {
                        fis = new FileInputStream(srcFile);
                        int size = fis.available();
                        if (size <= 0) {
                            QLog.i(HttpHelper.TAG, "uploadFileToCosRequest| file size is invalid. path=" + strFilePath + ", size=" + size);
                            errCode = -1;
                        } else {
                            URL url = new URL(strUrl);
                            conn = (HttpURLConnection)url.openConnection();
                            conn.setConnectTimeout(5000);
                            conn.setReadTimeout(30000);
                            conn.setDoOutput(true);
                            conn.setDoInput(true);
                            conn.setUseCaches(false);
                            conn.setRequestMethod("PUT");
                            conn.setRequestProperty("Connection", "Keep-Alive");
                            conn.setRequestProperty("Content-Length", srcFile.length() + "");
                            conn.setRequestProperty("Authorization", params.signature);
                            conn.setRequestProperty("x-amz-date", params.date);
                            conn.setRequestProperty("x-amz-content-sha256", "UNSIGNED-PAYLOAD");
                            out = new DataOutputStream(conn.getOutputStream());
                            int bytes = 0;
                            byte[] bufferOut = new byte[1024];
                            while ((bytes = fis.read(bufferOut)) != -1) {
                                out.write(bufferOut, 0, bytes);
                            }
                            out.flush();
                            errCode = conn.getResponseCode();
                            if (errCode == 200) {
                                int n;
                                in = new BufferedInputStream(conn.getInputStream());
                                ByteArrayOutputStream bout = new ByteArrayOutputStream(10240);
                                byte[] buf = new byte[1024];
                                while ((n = in.read(buf)) >= 0) {
                                    bout.write(buf, 0, n);
                                }
                                resp = bout.toByteArray();
                                if (resp.length == 0) {
                                    resp = "OK".getBytes();
                                }
                            } else {
                                QLog.i(HttpHelper.TAG, "uploadFileToCosRequest|http request failed. http response code =" + errCode);
                            }
                        }
                    }
                    catch (UnknownHostException e) {
                        QLog.i(HttpHelper.TAG, "uploadFileToCosRequest|upload file failed. neteork is invalid.");
                        errCode = -1;
                        e.printStackTrace();
                        errInfo = e.getMessage();
                    }
                    catch (IOException e) {
                        QLog.i(HttpHelper.TAG, "uploadFileToCosRequest|upload file failed. io exception. path=" + strUrl);
                        errCode = -1;
                        e.printStackTrace();
                        errInfo = e.getMessage();
                    }
                    catch (Exception e) {
                        QLog.i(HttpHelper.TAG, "uploadFileToCosRequest|upload file failed. exception. path=" + strUrl);
                        errCode = -1;
                        e.printStackTrace();
                        errInfo = e.getMessage();
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errInfo = e.getMessage();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errInfo = e.getMessage();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (conn != null) {
                    conn.disconnect();
                }
                if (listener != null) {
                    listener.onCompleted(strUrl, errCode, errInfo, resp, null);
                }
            }
        });
        fetchTask.start();
        return true;
    }

    public static boolean uploadFileToCosRequest(final String strUrl, final String strFilePath, final String strToken, final HttpRequestListener listener) {
        Thread fetchTask = new Thread(new Runnable(){

            @Override
            public void run() {
                FileInputStream fis = null;
                HttpURLConnection conn = null;
                OutputStream out = null;
                InputStream in = null;
                int errCode = 200;
                String errInfo = "success.";
                byte[] resp = null;
                File srcFile = HttpHelper.openFile(strFilePath);
                if (srcFile == null) {
                    errCode = -1;
                } else {
                    String sha1 = SHA1Utils.getFileSHA1(strFilePath);
                    try {
                        fis = new FileInputStream(srcFile);
                        int size = fis.available();
                        if (size <= 0) {
                            QLog.i(HttpHelper.TAG, "uploadFileToCosRequest| file size is invalid. path=" + strFilePath + ", size=" + size);
                            errCode = -1;
                        } else {
                            URL url = new URL(strUrl);
                            String BOUNDARY = "----------------------------aa502a40917c";
                            conn = (HttpURLConnection)url.openConnection();
                            conn.setConnectTimeout(5000);
                            conn.setReadTimeout(30000);
                            conn.setDoOutput(true);
                            conn.setDoInput(true);
                            conn.setUseCaches(false);
                            conn.setRequestMethod("POST");
                            conn.setRequestProperty("Connection", "Keep-Alive");
                            conn.setRequestProperty("Authorization", strToken);
                            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=----------------------------aa502a40917c");
                            out = new DataOutputStream(conn.getOutputStream());
                            HashMap<String, String> paramMap = new HashMap<String, String>(3);
                            paramMap.put("op", "upload");
                            paramMap.put("sha", sha1);
                            paramMap.put("biz_attr", "");
                            String paramString = HttpHelper.getParamString(paramMap, "----------------------------aa502a40917c");
                            paramString = paramString + "------------------------------aa502a40917c\r\n";
                            paramString = paramString + "Content-Disposition: form-data; name=\"filecontent\"; filename=\"" + strFilePath + "\"\r\n";
                            paramString = paramString + "Content-Type: application/octet-stream\r\n\r\n";
                            out.write(paramString.getBytes());
                            int bytes = 0;
                            byte[] bufferOut = new byte[1024];
                            while ((bytes = fis.read(bufferOut)) != -1) {
                                out.write(bufferOut, 0, bytes);
                            }
                            String endString = "\r\n------------------------------aa502a40917c--\r\n";
                            out.write(endString.getBytes());
                            out.flush();
                            errCode = conn.getResponseCode();
                            if (errCode == 200) {
                                int n;
                                in = new BufferedInputStream(conn.getInputStream());
                                ByteArrayOutputStream bout = new ByteArrayOutputStream(10240);
                                byte[] buf = new byte[1024];
                                while ((n = in.read(buf)) >= 0) {
                                    bout.write(buf, 0, n);
                                }
                                resp = bout.toByteArray();
                            } else {
                                QLog.i(HttpHelper.TAG, "uploadFileToCosRequest|http request failed. http response code =" + errCode);
                            }
                        }
                    }
                    catch (UnknownHostException e) {
                        QLog.i(HttpHelper.TAG, "uploadFileToCosRequest|upload file failed. neteork is invalid.");
                        errCode = -1;
                        e.printStackTrace();
                        errInfo = e.getMessage();
                    }
                    catch (IOException e) {
                        QLog.i(HttpHelper.TAG, "uploadFileToCosRequest|upload file failed. io exception. path=" + strUrl);
                        errCode = -1;
                        e.printStackTrace();
                        errInfo = e.getMessage();
                    }
                    catch (Exception e) {
                        QLog.i(HttpHelper.TAG, "uploadFileToCosRequest|upload file failed. exception. path=" + strUrl);
                        errCode = -1;
                        e.printStackTrace();
                        errInfo = e.getMessage();
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errInfo = e.getMessage();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errInfo = e.getMessage();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (conn != null) {
                    conn.disconnect();
                }
                if (listener != null) {
                    listener.onCompleted(strUrl, errCode, errInfo, resp, null);
                }
            }
        });
        fetchTask.start();
        return true;
    }

    private static File openFile(String path) {
        if (path == null || path.equals("")) {
            QLog.i(TAG, "checkFile| filePath == null.");
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            QLog.i(TAG, "checkFile| filePath is not exist. path=" + path);
            return null;
        }
        return file;
    }

    private static String getParamString(Map<String, String> paramMap, String boundary) {
        String strBuf = "";
        if (paramMap != null) {
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                strBuf = strBuf + "--" + boundary + "\r\n";
                strBuf = strBuf + "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n";
                strBuf = strBuf + entry.getValue() + "\r\n";
            }
        }
        return strBuf;
    }

    public static interface HttpRequestListener {
        public void onCompleted(String var1, int var2, String var3, byte[] var4, Object var5);

        public boolean onProcess(String var1, int var2, int var3);
    }
}

