/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.utils;

import android.content.Context;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AVDeviceHelper {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static String byteArrayToHexString(byte[] data) {
        char[] out = new char[data.length << 1];
        int j = 0;
        for (int i = 0; i < data.length; ++i) {
            out[j++] = DIGITS_LOWER[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS_LOWER[0xF & data[i]];
        }
        return new String(out);
    }

    public static String string2Md5(String value) {
        if (value == null) {
            return "";
        }
        String MD5 = "";
        try {
            MessageDigest mD = MessageDigest.getInstance("MD5");
            MD5 = AVDeviceHelper.byteArrayToHexString(mD.digest(value.getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return MD5;
    }

    public static String getDeviceIdentifier(Context context) {
        return AVDeviceHelper.doRead(context) + ";" + AVDeviceHelper.getOrigMacAddr(context) + ";" + AVDeviceHelper.getOrigAndroidID(context);
    }

    public static String doRead(Context context) {
        String imei = "";
        return AVDeviceHelper.string2Md5(imei);
    }

    public static String getOrigAndroidID(Context context) {
        String aid = "";
        return AVDeviceHelper.string2Md5(aid);
    }

    public static String getOrigMacAddr(Context context) {
        return "Unknown";
    }

    public static String getSimulateIDFA(Context context) {
        return AVDeviceHelper.doRead(context) + ";" + AVDeviceHelper.getOrigMacAddr(context) + ";" + AVDeviceHelper.getOrigAndroidID(context);
    }
}

