/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.ptt;

import java.io.FileInputStream;
import java.security.MessageDigest;

public class SHA1Utils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getFileSHA1(String filePath) {
        return SHA1Utils.messageDigestInter(filePath, "SHA-1");
    }

    public static String getFileMD5(String filePath) {
        return SHA1Utils.messageDigestInter(filePath, "MD5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String messageDigestInter(String filePath, String algorithm) {
        FileInputStream in = null;
        try {
            int len;
            in = new FileInputStream(filePath);
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            byte[] buffer = new byte[65536];
            while ((len = in.read(buffer)) > 0) {
                messageDigest.update(buffer, 0, len);
            }
            String string = SHA1Utils.toHexString(messageDigest.digest());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEX_DIGITS[(b[i] & 0xF0) >>> 4]);
            sb.append(HEX_DIGITS[b[i] & 0xF]);
        }
        return sb.toString();
    }
}

