/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.ptt;

import android.os.Environment;
import com.gme.av.utils.QLog;
import java.io.File;
import java.util.ArrayList;

public class FileManager {
    private static FileManager s_instance = null;
    private String fileNamePrx = "silk_";
    private String fullDirPath = null;
    private String silkFolderName = "tsilkfile";
    private String TAG = "FileManager";
    private ArrayList<String> fileNameList = new ArrayList();
    private int MAX_LENGTH = 5;

    public static FileManager getInstance() {
        if (s_instance == null) {
            s_instance = new FileManager();
            s_instance.createSilkTempDir();
            s_instance.deleteAllFile();
        }
        return s_instance;
    }

    private boolean createSilkTempDir() {
        String basicPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        String path = basicPath + "/" + this.silkFolderName;
        try {
            File file = new File(path);
            if (file.exists()) {
                this.fullDirPath = file.getAbsolutePath();
            } else {
                file.mkdir();
                this.fullDirPath = file.getAbsolutePath();
            }
            return true;
        }
        catch (Exception e) {
            QLog.i(this.TAG, "create temp file error : e = " + e);
            return false;
        }
    }

    public String genSilkFileName() {
        if (this.fullDirPath == null && !this.createSilkTempDir()) {
            QLog.i(this.TAG, "can not create silk temp dir!");
            return null;
        }
        String fileName = this.fullDirPath + "/" + this.fileNamePrx + System.currentTimeMillis() + ".silk";
        this.fileNameList.add(fileName);
        return fileName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteFile() {
        if (this.fileNameList.size() > this.MAX_LENGTH) {
            for (int i = 0; i < this.fileNameList.size(); ++i) {
                String filename = this.fileNameList.get(i);
                try {
                    File file = new File(filename);
                    if (!file.exists()) continue;
                    file.delete();
                    continue;
                }
                catch (Exception e) {
                    QLog.i(this.TAG, "delete file failed! file name = " + filename + "exception = " + e);
                }
            }
            return;
        } else {
            if (this.fileNameList.size() <= 0) return;
            String name = this.fileNameList.get(0);
            this.fileNameList.remove(0);
            try {
                File file = new File(name);
                if (!file.exists()) return;
                file.delete();
                return;
            }
            catch (Exception e) {
                QLog.i(this.TAG, "delete file failed! file name = " + name + "exception = " + e);
            }
        }
    }

    public boolean deleteAllFile() {
        if (this.fullDirPath == null) {
            QLog.i(this.TAG, "Target dir is null!");
            return true;
        }
        try {
            File file = new File(this.fullDirPath);
            File[] childrenFiles = file.listFiles();
            if (childrenFiles == null || childrenFiles.length == 0) {
                return true;
            }
            QLog.i(this.TAG, "begin delete " + childrenFiles.length + " files");
            for (int i = 0; i < childrenFiles.length; ++i) {
                File f = childrenFiles[i];
                f.delete();
            }
            QLog.i(this.TAG, "end delete files");
        }
        catch (Exception e) {
            QLog.i(this.TAG, "delete all file failed!");
            return false;
        }
        return true;
    }
}

