/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.net;

import com.gme.av.utils.QLog;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class NetInfo {
    private static final String tagString = "NetInfo";
    private static final int MAX_TRACE_COUNT = 30;
    private static final String PING_FROM = "from";
    private static final String PING_PAREN_THESE_OPEN = "(";
    private static final String PING_PAREN_THESE_CLOSE = ")";

    private NetInfo() {
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static List<String> getDNSServers() {
        ArrayList<String> retVal = new ArrayList<String>();
        try {
            Process p = Runtime.getRuntime().exec("/system/bin/getprop");
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            LineNumberReader lnr = new LineNumberReader(isr);
            while (true) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    QLog.e("GMENetDiagnoseHelper|DoSSONetDiagno", e.toString());
                    continue;
                }
                break;
            }
            String propStr = null;
            int num = 0;
            while ((propStr = lnr.readLine()) != null) {
                int index;
                if (!propStr.startsWith("[net.dns1]") && !propStr.startsWith("[net.dns2]") || (index = propStr.indexOf(58)) <= 0) continue;
                int begin = propStr.indexOf(91, index);
                int end = propStr.indexOf(93, index);
                if (end <= begin) continue;
                String ip = propStr.substring(begin + 1, end);
                if (!NetInfo.isNullOrEmpty(ip)) {
                    retVal.add(ip);
                }
                if (++num < 2) continue;
                break;
            }
            lnr.close();
            isr.close();
        }
        catch (IOException e) {
            QLog.e(tagString, e.toString());
            return null;
        }
        return retVal;
    }

    public static void tracerout(String ip, ArrayList<String> outPutArray) {
        for (int i = 1; i <= 30; ++i) {
            long[] rtt = new long[]{-1L, -1L, -1L};
            String ipString = null;
            for (int Count = 0; Count < 3; ++Count) {
                String tempCommond = String.format("/system/bin/ping -i 0.2 -c 1 -s 0 -t %d -W 3 %s", i, ip);
                long startTime = System.currentTimeMillis();
                String result = NetInfo.doDetect(tempCommond);
                long endTime = System.currentTimeMillis();
                if (result == null) continue;
                ipString = result;
                rtt[Count] = endTime - startTime;
            }
            long total = rtt[0] + rtt[1] + rtt[2];
            if (total == -3L || NetInfo.isNullOrEmpty(ipString)) {
                outPutArray.add(String.format("trace   ttl:#%2d            **********", i));
                continue;
            }
            ipString = ipString.replace(" ", "");
            String outPutString = String.format("trace   ttl:#%2d  %20s cost:   ", i, ipString);
            for (int count = 0; count < 3; ++count) {
                outPutString = rtt[count] == -1L ? outPutString + "   *    " : (rtt[count] <= 1L ? outPutString + "  <1  ms " : outPutString + "  " + rtt[count] + "ms  ");
            }
            outPutArray.add(outPutString);
            if (ipString.equals(ip)) break;
        }
    }

    private static String doDetect(String cmd) {
        String propStr = null;
        String IPFrom = null;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            LineNumberReader lnr = new LineNumberReader(isr);
            while (true) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    QLog.e(tagString, e.toString());
                    continue;
                }
                break;
            }
            while ((propStr = lnr.readLine()) != null) {
                String lowpropStr = propStr.toLowerCase();
                if (!lowpropStr.contains(PING_FROM)) continue;
                IPFrom = NetInfo.parseIp(lowpropStr);
            }
            lnr.close();
            isr.close();
        }
        catch (IOException e) {
            QLog.e("GMENetDiagnoseHelper|GenTraceResult:", e.toString());
            return null;
        }
        return IPFrom;
    }

    private static String parseIp(String text) {
        text = text.toLowerCase();
        String ip = null;
        try {
            if (text.contains(PING_FROM)) {
                int index = text.indexOf(PING_FROM);
                ip = text.substring(index + 5);
                if (ip.contains(PING_PAREN_THESE_OPEN)) {
                    int indexOpen = ip.indexOf(PING_PAREN_THESE_OPEN);
                    int indexClose = ip.indexOf(PING_PAREN_THESE_CLOSE);
                    ip = ip.substring(indexOpen + 1, indexClose);
                } else {
                    index = ip.contains(":") ? ip.indexOf(":") : ip.indexOf(" ");
                    ip = ip.substring(0, index);
                }
            }
        }
        catch (Exception e) {
            ip = "parseIp error";
        }
        return ip;
    }
}

