/*
 * Decompiled with CFR 0.152.
 */
package com.gme.TMG;

import android.content.Context;
import android.content.Intent;
import com.gme.TMG.ITMGAudioCtrl;
import com.gme.TMG.ITMGAudioEffectCtrl;
import com.gme.TMG.ITMGContext;
import com.gme.TMG.ITMGFaceRenderer;
import com.gme.TMG.ITMGFaceTracker;
import com.gme.TMG.ITMGPTT;
import com.gme.TMG.ITMGPoseTracker;
import com.gme.TMG.ITMGRoom;
import com.gme.TMG.ITMGRoomManager;
import com.gme.TMG.TMGAudioCtrl;
import com.gme.TMG.TMGAudioEffectCtrl;
import com.gme.TMG.TMGCallbackHelper;
import com.gme.TMG.TMGPTT;
import com.gme.TMG.TMGRoom;
import com.gme.TMG.TMGRoomManager;
import com.gme.TMG.advance.TMGAudioRecordCtrl;
import com.gme.av.utils.QLog;
import com.gme.av.wrapper.OpensdkGameWrapper;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class TMGContext
extends ITMGContext {
    private static final String TAG = "TMGContext";
    private OpensdkGameWrapper gameWrapper = null;
    Context mContext = null;
    public ITMGContext.ITMGDelegate mTmgDelegate = null;
    TMGRoom mRoom = new TMGRoom(this);
    TMGRoomManager mRoomManager = new TMGRoomManager(this);
    TMGAudioCtrl mAudioCtrl = new TMGAudioCtrl(this);
    TMGPTT mPTT = new TMGPTT(this);
    TMGAudioEffectCtrl mEffectCtrl = new TMGAudioEffectCtrl(this);
    List<String> mLstUinSpeaking = new ArrayList<String>();
    TMGRoom.EventListener mRoomEventListener = new TMGRoom.EventListener(){

        @Override
        public void onEnterRoomComplete(int nRet, String strErrMsg) {
            if (TMGContext.this.mTmgDelegate != null) {
                Intent it = TMGCallbackHelper.GetCallBackIntent(nRet, strErrMsg);
                TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_ENTER_ROOM, it);
            }
        }

        @Override
        public void onExitRoomComplete() {
            TMGContext.this.mLstUinSpeaking.clear();
            if (TMGContext.this.mTmgDelegate != null) {
                Intent it = TMGCallbackHelper.GetCallBackIntent(0, "");
                TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_EXIT_ROOM, it);
            }
        }

        @Override
        public void onRoomDisconnect(int nRet, String strErrMsg) {
            if (TMGContext.this.mTmgDelegate != null) {
                Intent it = TMGCallbackHelper.GetCallBackIntent(nRet, strErrMsg);
                TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_ROOM_DISCONNECT, it);
            }
        }

        @Override
        public void onEndpointsUpdateInfo(int eventId, String[] identifierList) {
            if (TMGContext.this.mTmgDelegate != null) {
                int Type = 0;
                switch (eventId) {
                    case 1: {
                        Type = 1;
                        break;
                    }
                    case 2: {
                        Type = 2;
                        break;
                    }
                    case 5: {
                        Type = 5;
                        break;
                    }
                    case 6: {
                        Type = 6;
                    }
                }
                for (int i = 0; i < identifierList.length; ++i) {
                    String strUin = identifierList[i];
                    if (Type == 5) {
                        if (TMGContext.this.mLstUinSpeaking.contains(strUin)) continue;
                        TMGContext.this.mLstUinSpeaking.add(strUin);
                        continue;
                    }
                    if (!TMGContext.this.mLstUinSpeaking.contains(strUin)) continue;
                    TMGContext.this.mLstUinSpeaking.remove(strUin);
                }
                if (Type != 0) {
                    Intent it = TMGCallbackHelper.GetUpdateInfoIntent(Type, identifierList);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVNET_TYPE_USER_UPDATE, it);
                }
            }
        }

        @Override
        public void onRoomEvent(int type, int subtype, Object eventObj) {
            if (type == 400) {
                int nNewState = (Integer)eventObj;
                QLog.e(TMGContext.TAG, "AVRoomMultiDelegateJni TMGContext.onRoomEvent type = " + type + ", subtype = " + subtype + ", nNewState=" + nNewState);
                if (TMGContext.this.mTmgDelegate != null) {
                    Intent it = TMGCallbackHelper.GetRoomTypeChangedEventIntent(0, subtype, nNewState, "");
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_CHANGE_ROOM_TYPE, it);
                }
            } else if (type == 401) {
                String StringDetail = (String)eventObj;
                QLog.e(TMGContext.TAG, "AVRoomMultiDelegateJni TMGContext.onRoomEvent type = " + type + ", ret=" + StringDetail);
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    int nRoomShareCode = jsonResult.getInt("result");
                    QLog.d(TMGContext.TAG, "AVRoomMultiDelegateJni TMGContext.onRoomEvent , nRoomShareCode =" + String.valueOf(nRoomShareCode));
                    Intent it = TMGCallbackHelper.GetRoomShareEventIntent(nRoomShareCode);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_ROOM_SHARING_START, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 402) {
                String StringDetail = (String)eventObj;
                QLog.e(TMGContext.TAG, "AVRoomMultiDelegateJni TMGContext.onRoomEvent type = " + type + ", ret=" + StringDetail);
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    int nRoomShareCode = jsonResult.getInt("result");
                    QLog.d(TMGContext.TAG, "AVRoomMultiDelegateJni TMGContext.onRoomEvent , nRoomShareCode =" + String.valueOf(nRoomShareCode));
                    Intent it = TMGCallbackHelper.GetRoomShareEventIntent(nRoomShareCode);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_ROOM_SHARING_STOP, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 450) {
                String StringDetail = (String)eventObj;
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    int nAllUser = jsonResult.getInt("AllUser");
                    int nAccUser = jsonResult.getInt("AccUser");
                    int nProxyUser = jsonResult.getInt("ProxyUser");
                    QLog.d(TMGContext.TAG, "AVRoomMultiDelegateJni TMGContext.onRoomEvent , AllUser=" + String.valueOf(nAllUser) + ", AccUser=" + String.valueOf(nAccUser) + ", ProxyUser=" + String.valueOf(nProxyUser));
                    Intent it = TMGCallbackHelper.GetNumeberOfUsersEventIntent(nAllUser, nAccUser, nProxyUser);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_NUMBER_OF_USERS_UPDATE, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 451) {
                String StringDetail = (String)eventObj;
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    int nAudioStreams = jsonResult.getInt("AudioStreams");
                    QLog.d(TMGContext.TAG, "AVRoomMultiDelegateJni TMGContext.onRoomEvent , AllUser=" + String.valueOf(nAudioStreams));
                    Intent it = TMGCallbackHelper.GetAudioStreamsEventIntent(nAudioStreams);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_NUMBER_OF_AUDIOSTREAMS_UPDATE, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 500) {
                String StringDetail = (String)eventObj;
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    int nWeight = jsonResult.getInt("Weight");
                    double fLoss = jsonResult.getDouble("Loss");
                    int nDelay = jsonResult.getInt("Delay");
                    QLog.d(TMGContext.TAG, "AVRoomMultiDelegateJni TMGContext.onRoomEvent , nWeight=" + String.valueOf(nWeight) + ", Loss=" + String.valueOf(fLoss) + ", Delay=" + String.valueOf(nDelay));
                    Intent it = TMGCallbackHelper.GetBadQualityEventIntent(nWeight, fLoss, nDelay);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_CHANGE_ROOM_QUALITY, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 1000) {
                Intent it = TMGCallbackHelper.GetCallBackIntent(subtype, "");
                TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_RECONNECT_START, it);
            } else if (type == 1001) {
                Intent it = TMGCallbackHelper.GetCallBackIntent(subtype, "");
                TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_RECONNECT_SUCCESS, it);
            } else if (type == 1002) {
                String StringDetail = (String)eventObj;
                try {
                    String newStr = StringDetail.replace(" ", "_");
                    JSONObject jsonResult = new JSONObject(newStr);
                    int result = jsonResult.getInt("result");
                    String errorInfo = jsonResult.getString("error_info");
                    Intent it = new Intent();
                    it.putExtra("result", result);
                    it.putExtra("error_info", errorInfo);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_SWITCH_ROOM, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 6000) {
                String StringDetail = (String)eventObj;
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    Intent it = new Intent();
                    String SenderID = jsonResult.getString("SenderID");
                    String ReceiverID = jsonResult.getString("ReceiverID");
                    String UUID = jsonResult.getString("UUID");
                    boolean OperateValue = jsonResult.getBoolean("OperateValue");
                    int Result = jsonResult.getInt("Result");
                    it.putExtra("SenderID", SenderID);
                    it.putExtra("ReceiverID", ReceiverID);
                    it.putExtra("UUID", UUID);
                    it.putExtra("OperateValue", OperateValue);
                    it.putExtra("Result", Result);
                    it.putExtra("OperateType", subtype);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVNET_TYPE_ROOM_MANAGEMENT_OPERATOR, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 403) {
                String StringDetail = (String)eventObj;
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    String errInfo = jsonResult.getString("error_info");
                    int result = jsonResult.getInt("result");
                    Intent it = new Intent();
                    it.putExtra("result", result);
                    it.putExtra("error_info", errInfo);
                    it.putExtra("sub_event", subtype);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_SERVER_AUDIO_ROUTE_EVENT, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 404) {
                String StringDetail = (String)eventObj;
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    String content = jsonResult.getString("content");
                    String senderid = jsonResult.getString("senderid");
                    Intent it = new Intent();
                    it.putExtra("content", content);
                    it.putExtra("senderid", senderid);
                    it.putExtra("sub_event", subtype);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_CUSTOMDATA_UPDATE, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 407) {
                String StringDetail = (String)eventObj;
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    int result = jsonResult.getInt("result");
                    Intent it = new Intent();
                    it.putExtra("sub_event", subtype);
                    it.putExtra("result", result);
                    if (subtype == 1) {
                        it.putExtra("slice_type", jsonResult.getInt("slice_type"));
                        it.putExtra("index", jsonResult.getInt("index"));
                        it.putExtra("voice_text_str", jsonResult.getString("voice_text_str"));
                    } else {
                        it.putExtra("error_info", jsonResult.getString("error_info"));
                    }
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_REALTIME_ASR, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 408) {
                String StringDetail = (String)eventObj;
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    int result = jsonResult.getInt("result");
                    int age_detected_result = jsonResult.getInt("age_detected_result");
                    Intent it = new Intent();
                    it.putExtra("age_detected_result", age_detected_result);
                    it.putExtra("result", result);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_AGE_DETECTED, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 406) {
                String StringDetail = (String)eventObj;
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    String error_info = jsonResult.getString("error_info");
                    int result = jsonResult.getInt("ErrorCode");
                    String Accompanier_Openid = jsonResult.getString("Accompanier_Openid");
                    Intent it = new Intent();
                    it.putExtra("error_info", error_info);
                    it.putExtra("result", result);
                    it.putExtra("Accompanier_Openid", Accompanier_Openid);
                    it.putExtra("sub_type", subtype);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_CHORUS_EVENT, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 452) {
                String StringDetail = (String)eventObj;
                JSONObject jsonResult = null;
                try {
                    jsonResult = new JSONObject(StringDetail);
                    String error_info = jsonResult.getString("error_info");
                    int result = jsonResult.getInt("ErrorCode");
                    int teamid = jsonResult.getInt("teamid");
                    Intent it = new Intent();
                    it.putExtra("error_info", error_info);
                    it.putExtra("result", result);
                    it.putExtra("teamid", teamid);
                    it.putExtra("sub_type", subtype);
                    TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_CHANGETEAMID, it);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void onDisableAudioIssue() {
            if (TMGContext.this.mTmgDelegate != null) {
                Intent it = new Intent();
                it.putExtra("reason", 65536);
                it.putExtra("error_info", "");
                TMGContext.this.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_AUDIO_DATA_EMPTY, it);
            }
        }
    };
    private boolean sdk_match = true;

    TMGContext(Context context) {
        this.mContext = context;
        TMGAudioRecordCtrl.GetInstance().setTMGContext(this);
        this.gameWrapper = new OpensdkGameWrapper(this.mContext);
        if (this.gameWrapper.initOpensdk() == 7015) {
            this.sdk_match = false;
        }
    }

    @Override
    public int Poll() {
        return this.nativePoll();
    }

    @Override
    public ITMGContext.ITMG_RECORD_PERMISSION CheckMicPermission() {
        if (this.gameWrapper != null) {
            return ITMGContext.ITMG_RECORD_PERMISSION.values()[this.gameWrapper.CheckMicPermission()];
        }
        QLog.e(TAG, "gameWrapper is not install");
        return ITMGContext.ITMG_RECORD_PERMISSION.ITMG_PERMISSION_ERROR;
    }

    @Override
    public ITMGContext.ITMG_CHECK_MIC_STATUS CheckMic() {
        int index = this.nativeCheckMic();
        QLog.d(TAG, "CheckMic = " + index);
        if (index >= 0 && index < ITMGContext.ITMG_CHECK_MIC_STATUS.values().length) {
            return ITMGContext.ITMG_CHECK_MIC_STATUS.values()[index];
        }
        return ITMGContext.ITMG_CHECK_MIC_STATUS.ITMG_CHECK_MIC_STATUS_ERROR_FUNC;
    }

    @Override
    public int Pause() {
        return this.nativePause();
    }

    @Override
    public int Resume() {
        return this.nativeResume();
    }

    @Override
    public int SetLogLevel(int levelWrite, int levelPrint) {
        return this.nativeSetLogLevel(levelWrite, levelPrint);
    }

    @Override
    public int SetLogPath(String logDir) {
        return this.nativeSetLogPath(logDir);
    }

    public native int nativeSetAudioRole(int var1);

    public native int nativeSetRangeAudioMode(int var1);

    public native int nativeSetRangeAudioTeamID(int var1);

    @Override
    public int Uninit() {
        this.mLstUinSpeaking.clear();
        this.nativeStop();
        this.nativeUnInitFaceAndPose();
        this.nativePoll();
        return 0;
    }

    @Override
    public int SetTMGDelegate(ITMGContext.ITMGDelegate delegate) {
        QLog.i("API", String.format("SetTMGDelegate.delegate=%s", delegate));
        this.mTmgDelegate = delegate;
        return 0;
    }

    @Override
    public void SetRegion(String region) {
        this.nativeSetRegion(region);
    }

    @Override
    public void SetHost(String chatHost, String pttHost) {
        this.nativeSetHost(chatHost, pttHost);
    }

    @Override
    public int Init(String sdkAppID, String openID) {
        this.mPTT.SetAppInfo(sdkAppID, openID);
        this.nativeInitFaceAndPose();
        int ret = this.nativeStart(sdkAppID, openID);
        return this.sdk_match ? ret : 7015;
    }

    @Override
    public String GetSDKVersion() {
        return this.nativeGetSDKVersion();
    }

    @Override
    public int SetRecvMixStreamCount(int nCount) {
        return this.nativeSetParam("RecvMixStreamCount", String.valueOf(nCount));
    }

    @Override
    public int SetAdvanceParams(String strKey, String strValue) {
        return this.nativeSetParam(strKey, strValue);
    }

    @Override
    public String GetAdvanceParams(String strKey) {
        return this.nativeGetParam(strKey);
    }

    @Override
    public void SetAppVersion(String sAppVersion) {
        this.nativeSetAppVersion(sAppVersion);
    }

    @Override
    public boolean IsRoomEntered() {
        return this.nativeisRoomEntered();
    }

    @Override
    public int EnterRoom(String roomID, int roomType, byte[] authBuffer) {
        return this.nativeEnterRoom(roomID, roomType, authBuffer, this.mRoomEventListener);
    }

    @Override
    public int SetAudioRole(ITMGContext.ITMG_AUDIO_MEMBER_ROLE role) {
        int nrole = role.ordinal();
        return this.nativeSetAudioRole(nrole);
    }

    @Override
    public int SetRangeAudioMode(ITMGContext.ITMG_RANGE_AUDIO_MODE gameAudioMode) {
        boolean nRet = false;
        int nType = gameAudioMode.getValue();
        return this.nativeSetRangeAudioMode(nType);
    }

    @Override
    public int SetRangeAudioTeamID(int teamID) {
        return this.nativeSetRangeAudioTeamID(teamID);
    }

    @Override
    public int ExitRoom() {
        this.mAudioCtrl.StopTrackingVolume();
        this.mLstUinSpeaking.clear();
        return this.exitRoom();
    }

    @Override
    public int StartRealTimeASR() {
        return this.nativeStartRealTimeASR("cmn-Hans-CN");
    }

    @Override
    public int StartRealTimeASR(String language) {
        return this.nativeStartRealTimeASR(language);
    }

    @Override
    public int StopRealTimeASR() {
        return this.nativeStopRealTimeASR();
    }

    @Override
    public int EnableAgeDectection(boolean bEnable) {
        return this.nativeEnableAgeDectection(bEnable);
    }

    @Override
    public int InitAgeDectection(String strBinaryPath, String strParamPath) {
        return this.nativeInitAgeDectection(strBinaryPath, strParamPath);
    }

    @Override
    public ITMGRoom GetRoom() {
        return this.mRoom;
    }

    @Override
    public ITMGRoomManager GetRoomManager() {
        return this.mRoomManager;
    }

    @Override
    public ITMGAudioCtrl GetAudioCtrl() {
        return this.mAudioCtrl;
    }

    @Override
    public ITMGAudioEffectCtrl GetAudioEffectCtrl() {
        return this.mEffectCtrl;
    }

    @Override
    public ITMGPTT GetPTT() {
        return this.mPTT;
    }

    @Override
    public int InitFaceTracker(String licPath, String modelPath) {
        return this.nativeInitFaceTracker(licPath, modelPath);
    }

    public int exitRoom() {
        return this.nativeExitRoom();
    }

    @Override
    public ITMGFaceTracker CreateFaceTracker(String modelDirPath, String configFileName) {
        return ITMGFaceTracker.CreateTracker(modelDirPath, configFileName);
    }

    @Override
    public ITMGFaceRenderer CreateFaceRenderer(String modelDirPath, String configFileName) {
        return ITMGFaceRenderer.CreateRenderer(modelDirPath, configFileName);
    }

    @Override
    public ITMGPoseTracker CreatePoseTracker(String bodyModelPath, String bodyModelBinPath, String poseModelPath, String poseModelBinPath, String smootherModelPath, String smootherModelBinPath) {
        return ITMGPoseTracker.CreateTracker(bodyModelPath, bodyModelBinPath, poseModelPath, poseModelBinPath, smootherModelPath, smootherModelBinPath);
    }

    private native void nativeInitFaceAndPose();

    private native void nativeUnInitFaceAndPose();

    private native int nativeInitFaceTracker(String var1, String var2);

    private native int nativeStartRealTimeASR(String var1);

    private native int nativeStopRealTimeASR();

    private native int nativeInitAgeDectection(String var1, String var2);

    private native int nativeEnableAgeDectection(boolean var1);

    private native String nativeGetSDKVersion();

    private native int nativePoll();

    private native int nativeSetLogLevel(int var1, int var2);

    private native int nativeSetLogPath(String var1);

    private native int nativeSetAppVersion(String var1);

    private native void nativeSetRegion(String var1);

    private native void nativeSetHost(String var1, String var2);

    private native int nativeStart(String var1, String var2);

    private native int nativeStop();

    private native int nativeEnterRoom(String var1, int var2, byte[] var3, TMGRoom.EventListener var4);

    private native int nativeExitRoom();

    private native boolean nativeisRoomEntered();

    private native int nativeSetParam(String var1, String var2);

    private native String nativeGetParam(String var1);

    private native int nativePause();

    private native int nativeResume();

    private native int nativeCheckMic();
}

