//
//  ITMGEngine.h
//  QAVSDK
//

#import <Foundation/Foundation.h>
#import "AdvanceHeaders/tmg_type_adv.h"

@interface ITMGAudioRecordCtrl : NSObject
+(ITMGAudioRecordCtrl*) GetInstance;
-(int) StartRecord:(int)type dstFile:(NSString*)dstFile accMixFile:(NSString*)accMixFile accPlayFile:(NSString*)accPlayFile;
-(int) StopRecord;
-(int) PauseRecord;
-(int) ResumeRecord;
-(int) SetAccompanyFile:(NSString*)accPlayFile;
-(int) GetAccompanyTotalTimeByMs;
-(int) GetRecordTimeByMs;
-(int) SetRecordTimeByMs:(int)timePlay timeRecord:(int)timeRecord;
-(int) SetRecordKaraokeType:(int)type;
-(int) GetRecordFileDurationByMs;

-(int) StartPreview;
-(int) StopPreview;
-(int) PausePreview;
-(int) ResumePreview;
-(int) SetPreviewTimeByMs:(int)time;
-(int) GetPreviewTimeByMs;
-(int) SetMixWeights:(float)mic acc:(float)acc;
-(int) AdjustAudioTimeByMs:(int)time;
-(int) MixRecordFile:(BOOL)needMicData;
-(int) CancelMixRecordFile;
@end

@protocol IAudioDataCallback <NSObject>
-(void) OnAudioDataCallback:(AUDIO_DATA_TYPE)audioDataType timestamp:(uint64_t)timestamp sampleRate:(int)sampleRate
               channelCount:(int)channelCount bitsType:(int)bitsType length:(int)length pcmData:(unsigned char *)pcmData;

@end

@interface ITMGAudioDataObserver : NSObject

+(ITMGAudioDataObserver *) GetInstance;

- (int) RegisteAudioDataCallback:(AUDIO_DATA_TYPE)audioDataType callback:(id<IAudioDataCallback>)callback;

- (int) UnRegisterAudioDataCallback:(AUDIO_DATA_TYPE)audioDataType;

- (int) SetAudioDataFormat:(AUDIO_DATA_TYPE) audioType sampleRate:(int)sampleRate channelCount:(int)channelCount;


@end
