/*
 * Decompiled with CFR 0.152.
 */
package com.gme.sharpgme.jni;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Parcelable;
import android.os.Process;
import com.gme.av.utils.ClientInfo;
import com.gme.av.utils.QLog;
import com.gme.sharpgme.jni.TraeAudioManager;

public class TraeAudioSession
extends BroadcastReceiver {
    private static final String TAG = "TRAEJava";
    private boolean mIsHostside = false;
    private long mSessionId = Long.MIN_VALUE;
    private ITraeAudioCallback mCallback;
    private Context mContext;
    private String _connectedDev = "DEVICE_NONE";
    private boolean _canSwtich2Earphone = true;
    static int s_nSessionIdAllocator = 0;
    final String TRAE_ACTION_PHONE_STATE = "android.intent.action.PHONE_STATE";

    public static long requestSessionId() {
        return ((long)Process.myPid() << 32) + (long)(++s_nSessionIdAllocator);
    }

    public static void ExConnectDevice(Context ctx, String strDevice) {
        if (null == ctx || null == strDevice || strDevice.length() <= 0) {
            return;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", Long.MIN_VALUE);
        intent.putExtra("PARAM_OPERATION", "OPERATION_CONNECTDEVICE");
        intent.putExtra("CONNECTDEVICE_DEVICENAME", strDevice);
        intent.setPackage(ctx.getPackageName());
        ctx.sendBroadcast(intent);
    }

    public TraeAudioSession(Context ctx, ITraeAudioCallback cb) {
        this.mIsHostside = Process.myPid() == TraeAudioManager._gHostProcessId;
        this.mSessionId = TraeAudioSession.requestSessionId();
        this.mCallback = cb;
        this.mContext = ctx;
        if (null == ctx) {
            QLog.w(TAG, "AudioSession | Invalid parameters: ctx = " + (null == ctx ? "null" : "{object}") + "; cb = " + (null == cb ? "null" : "{object}"));
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_RES");
        filter.addAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_NOTIFY");
        try {
            if (ctx != null) {
                if (ClientInfo.VERSION_SDK_INT >= 31) {
                    ctx.registerReceiver((BroadcastReceiver)this, filter, 2);
                } else {
                    ctx.registerReceiver((BroadcastReceiver)this, filter);
                }
            }
        }
        catch (Exception e) {
            QLog.e(TAG, "registerReceiver Exception: " + e.getMessage());
        }
        this.registerAudioSession(this, true);
        QLog.w(TAG, "TraeAudioSession create, mSessionId: " + this.mSessionId);
    }

    public void release() {
        QLog.w(TAG, "TraeAudioSession release, mSessionId: " + this.mSessionId);
        if (null != this.mContext) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.registerAudioSession(this, false);
        this.mContext = null;
        this.mCallback = null;
    }

    public void setCallback(ITraeAudioCallback cb) {
        this.mCallback = cb;
    }

    private int registerAudioSession(TraeAudioSession _traeAs, boolean bRegister) {
        if (null == this.mContext) {
            return -1;
        }
        return TraeAudioManager.registerAudioSession(_traeAs, bRegister, this.mSessionId, this.mContext);
    }

    public int startService(String deviceConfig) {
        if (null == deviceConfig || deviceConfig.length() <= 0) {
            deviceConfig = "internal_disable_dev_switch";
        }
        if (this.mIsHostside) {
            return TraeAudioManager.startService("OPERATION_STARTSERVICE", this.mSessionId, this.mIsHostside, deviceConfig);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_STARTSERVICE");
        intent.putExtra("EXTRA_DATA_DEVICECONFIG", deviceConfig);
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int stopService() {
        if (this.mIsHostside) {
            return TraeAudioManager.stopService("OPERATION_STOPSERVICE", this.mSessionId, this.mIsHostside);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_STOPSERVICE");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int getDeviceList() {
        if (this.mIsHostside) {
            return TraeAudioManager.getDeviceList("OPERATION_GETDEVICELIST", this.mSessionId, this.mIsHostside);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_GETDEVICELIST");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int getStreamType() {
        if (this.mIsHostside) {
            return TraeAudioManager.getStreamType("OPERATION_GETSTREAMTYPE", this.mSessionId, this.mIsHostside);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_GETSTREAMTYPE");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int connectDevice(String strDevice) {
        if (this.mIsHostside) {
            return TraeAudioManager.connectDevice("OPERATION_CONNECTDEVICE", this.mSessionId, this.mIsHostside, strDevice);
        }
        if (null == this.mContext || null == strDevice || strDevice.length() <= 0) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_CONNECTDEVICE");
        intent.putExtra("CONNECTDEVICE_DEVICENAME", strDevice);
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int forceConnectDevice(String strDevice) {
        if (this.mIsHostside) {
            return TraeAudioManager.forceConnectDevice("OPERATION_FORCE_CONNECTDEVICE", this.mSessionId, this.mIsHostside, strDevice);
        }
        if (null == this.mContext || null == strDevice || strDevice.length() <= 0) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_FORCE_CONNECTDEVICE");
        intent.putExtra("CONNECTDEVICE_DEVICENAME", strDevice);
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int connectHighestPriorityDevice() {
        if (this.mIsHostside) {
            return TraeAudioManager.connectHighestPriorityDevice("OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE", this.mSessionId, this.mIsHostside);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int EarAction(int earAction) {
        if (this.mIsHostside) {
            return TraeAudioManager.earAction("OPERATION_EARACTION", this.mSessionId, this.mIsHostside, earAction);
        }
        if (null == this.mContext || earAction != 0 && earAction != 1) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_EARACTION");
        intent.putExtra("EXTRA_EARACTION", earAction);
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int isDeviceChangabled() {
        if (this.mIsHostside) {
            return TraeAudioManager.isDeviceChangabled("OPERATION_ISDEVICECHANGABLED", this.mSessionId, this.mIsHostside);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_ISDEVICECHANGABLED");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int getConnectedDevice() {
        if (this.mIsHostside) {
            return TraeAudioManager.getConnectedDevice("OPERATION_GETCONNECTEDDEVICE", this.mSessionId, this.mIsHostside);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_GETCONNECTEDDEVICE");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int getConnectingDevice() {
        if (this.mIsHostside) {
            return TraeAudioManager.getConnectingDevice("OPERATION_GETCONNECTINGDEVICE", this.mSessionId, this.mIsHostside);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_GETCONNECTINGDEVICE");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int voiceCallPreprocess(int modePolicy, int streamType) {
        if (this.mIsHostside) {
            return TraeAudioManager.voicecallPreprocess("OPERATION_VOICECALL_PREPROCESS", this.mSessionId, this.mIsHostside, modePolicy, streamType);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_MODEPOLICY", modePolicy);
        intent.putExtra("PARAM_STREAMTYPE", streamType);
        intent.putExtra("PARAM_OPERATION", "OPERATION_VOICECALL_PREPROCESS");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int voiceCallPostprocess() {
        if (this.mIsHostside) {
            return TraeAudioManager.voicecallPostprocess("OPERATION_VOICECALL_POSTROCESS", this.mSessionId, this.mIsHostside);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_VOICECALL_POSTROCESS");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int voiceCallAudioParamChanged(int modePolicy, int streamType) {
        if (this.mIsHostside) {
            return TraeAudioManager.voiceCallAudioParamChanged("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST", this.mSessionId, this.mIsHostside, modePolicy, streamType);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_MODEPOLICY", modePolicy);
        intent.putExtra("PARAM_STREAMTYPE", streamType);
        intent.putExtra("PARAM_OPERATION", "OPERATION_VOICECALL_AUDIOPARAM_CHANGED");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int startRing(int dataSource, int rsId, Uri res, String strFilePath, boolean bLoop) {
        if (this.mIsHostside) {
            return TraeAudioManager.startRing("OPERATION_STARTRING", this.mSessionId, this.mIsHostside, dataSource, rsId, res, strFilePath, bLoop, 1, "normal-ring", false);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_RING_DATASOURCE", dataSource);
        intent.putExtra("PARAM_RING_RSID", rsId);
        intent.putExtra("PARAM_RING_URI", (Parcelable)res);
        intent.putExtra("PARAM_RING_FILEPATH", strFilePath);
        intent.putExtra("PARAM_RING_LOOP", bLoop);
        intent.putExtra("PARAM_RING_MODE", false);
        intent.putExtra("PARAM_RING_USERDATA_STRING", "normal-ring");
        intent.putExtra("PARAM_OPERATION", "OPERATION_STARTRING");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int startRing(int dataSource, int rsId, Uri res, String strFilePath, boolean bLoop, int loopCount, String userData) {
        if (this.mIsHostside) {
            return TraeAudioManager.startRing("OPERATION_STARTRING", this.mSessionId, this.mIsHostside, dataSource, rsId, res, strFilePath, bLoop, loopCount, userData, false);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_RING_DATASOURCE", dataSource);
        intent.putExtra("PARAM_RING_RSID", rsId);
        intent.putExtra("PARAM_RING_URI", (Parcelable)res);
        intent.putExtra("PARAM_RING_FILEPATH", strFilePath);
        intent.putExtra("PARAM_RING_LOOP", bLoop);
        intent.putExtra("PARAM_RING_LOOPCOUNT", loopCount);
        intent.putExtra("PARAM_RING_MODE", false);
        intent.putExtra("PARAM_RING_USERDATA_STRING", userData);
        intent.putExtra("PARAM_OPERATION", "OPERATION_STARTRING");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int startRing(int dataSource, int rsId, Uri res, String strFilePath, boolean bLoop, int loopCount, String userData, boolean ringMode) {
        if (this.mIsHostside) {
            return TraeAudioManager.startRing("OPERATION_STARTRING", this.mSessionId, this.mIsHostside, dataSource, rsId, res, strFilePath, bLoop, loopCount, userData, ringMode);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_RING_DATASOURCE", dataSource);
        intent.putExtra("PARAM_RING_RSID", rsId);
        intent.putExtra("PARAM_RING_URI", (Parcelable)res);
        intent.putExtra("PARAM_RING_FILEPATH", strFilePath);
        intent.putExtra("PARAM_RING_LOOP", bLoop);
        intent.putExtra("PARAM_RING_LOOPCOUNT", loopCount);
        intent.putExtra("PARAM_RING_MODE", ringMode);
        intent.putExtra("PARAM_RING_USERDATA_STRING", userData);
        intent.putExtra("PARAM_OPERATION", "OPERATION_STARTRING");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int stopRing() {
        if (this.mIsHostside) {
            return TraeAudioManager.stopRing("OPERATION_STOPRING", this.mSessionId, this.mIsHostside);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_STOPRING");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int requestReleaseAudioFocus() {
        if (this.mIsHostside) {
            return TraeAudioManager.requestReleaseAudioFocus("OPERATION_REQUEST_RELEASE_AUDIO_FOCUS", this.mSessionId, this.mIsHostside);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_REQUEST_RELEASE_AUDIO_FOCUS");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public int recoverAudioFocus() {
        if (this.mIsHostside) {
            return TraeAudioManager.recoverAudioFocus("OPERATION_RECOVER_AUDIO_FOCUS", this.mSessionId, this.mIsHostside);
        }
        if (null == this.mContext) {
            return -1;
        }
        Intent intent = new Intent();
        intent.setAction("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", this.mSessionId);
        intent.putExtra("PARAM_OPERATION", "OPERATION_RECOVER_AUDIO_FOCUS");
        intent.setPackage(this.mContext.getPackageName());
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    public void onReceiveCallback(Intent intent) {
        int errCode = 0;
        try {
            if (null == intent) {
                QLog.w(TAG, "[ERROR] intent = null!!");
                return;
            }
            long nSessionId = intent.getLongExtra("PARAM_SESSIONID", Long.MIN_VALUE);
            String strOperation = intent.getStringExtra("PARAM_OPERATION");
            errCode = intent.getIntExtra("PARAM_RES_ERRCODE", 0);
            if ("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_RES".equals(intent.getAction())) {
                if (this.mSessionId != nSessionId) {
                    return;
                }
                if ("OPERATION_VOICECALL_PREPROCESS".equals(strOperation)) {
                    QLog.w(TAG, "AudioSession|[onReceiveCallback onVoicecallPreprocess] err:" + errCode);
                    if (null != this.mCallback) {
                        this.mCallback.onVoicecallPreprocessRes(errCode);
                    }
                }
            }
        }
        catch (Exception e) {
            QLog.e(TAG, "AudioSession| nSessinId = " + this.mSessionId + " onReceive::intent:" + intent.toString() + " intent.getAction():" + intent.getAction() + " Exception:" + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceive(Context context, Intent intent) {
        int errCode = 0;
        try {
            if (null == intent) {
                QLog.w(TAG, "[ERROR] intent = null!!");
                return;
            }
            long nSessionId = intent.getLongExtra("PARAM_SESSIONID", Long.MIN_VALUE);
            String strOperation = intent.getStringExtra("PARAM_OPERATION");
            errCode = intent.getIntExtra("PARAM_RES_ERRCODE", 0);
            if ("com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_NOTIFY".equals(intent.getAction())) {
                if ("NOTIFY_SERVICE_STATE".equals(strOperation)) {
                    boolean on = intent.getBooleanExtra("NOTIFY_SERVICE_STATE_DATE", false);
                    QLog.w(TAG, "AudioSession|[onServiceStateUpdate]" + (on ? "on" : "off"));
                    if (null == this.mCallback) return;
                    this.mCallback.onServiceStateUpdate(on);
                    return;
                } else if ("NOTIFY_DEVICELISTUPDATE".equals(strOperation)) {
                    String[] strDeviceList = intent.getStringArrayExtra("EXTRA_DATA_AVAILABLEDEVICE_LIST");
                    String con = intent.getStringExtra("EXTRA_DATA_CONNECTEDDEVICE");
                    String prevCon = intent.getStringExtra("EXTRA_DATA_PREV_CONNECTEDDEVICE");
                    String btName = intent.getStringExtra("EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME");
                    String str = "\n";
                    boolean _cs2earphone = true;
                    for (int i = 0; i < strDeviceList.length; ++i) {
                        str = str + "AudioSession|    " + i + " " + strDeviceList[i] + "\n";
                        if (!strDeviceList[i].equals("DEVICE_WIREDHEADSET") && !strDeviceList[i].equals("DEVICE_BLUETOOTHHEADSET")) continue;
                        _cs2earphone = false;
                    }
                    str = str + "\n";
                    QLog.w(TAG, "AudioSession|[onDeviceListUpdate]  connected:" + con + " prevConnected:" + prevCon + " bt:" + btName + " Num:" + strDeviceList.length + str);
                    this._canSwtich2Earphone = _cs2earphone;
                    this._connectedDev = con;
                    if (null == this.mCallback) return;
                    this.mCallback.onDeviceListUpdate(strDeviceList, con, prevCon, btName);
                    return;
                } else if ("NOTIFY_DEVICECHANGABLE_UPDATE".equals(strOperation)) {
                    boolean bIsChangabled = intent.getBooleanExtra("NOTIFY_DEVICECHANGABLE_UPDATE_DATE", true);
                    QLog.w(TAG, "AudioSession|[onDeviceChangabledUpdate]" + bIsChangabled);
                    if (null == this.mCallback) return;
                    this.mCallback.onDeviceChangabledUpdate(bIsChangabled);
                    return;
                } else if ("NOTIFY_STREAMTYPE_UPDATE".equals(strOperation)) {
                    int st = intent.getIntExtra("EXTRA_DATA_STREAMTYPE", -1);
                    QLog.w(TAG, "AudioSession|[onStreamTypeUpdate] err:" + errCode + " st:" + st);
                    if (null == this.mCallback) return;
                    this.mCallback.onStreamTypeUpdate(st);
                    return;
                } else if ("NOTIFY_ROUTESWITCHSTART".equals(strOperation)) {
                    String from = intent.getStringExtra("EXTRA_DATA_ROUTESWITCHSTART_FROM");
                    String to = intent.getStringExtra("EXTRA_DATA_ROUTESWITCHSTART_TO");
                    if (null == this.mCallback || from == null || to == null) return;
                    this.mCallback.onAudioRouteSwitchStart(from, to);
                    return;
                } else {
                    if (!"NOTIFY_ROUTESWITCHEND".equals(strOperation)) return;
                    String d = intent.getStringExtra("EXTRA_DATA_ROUTESWITCHEND_DEV");
                    long t = intent.getLongExtra("EXTRA_DATA_ROUTESWITCHEND_TIME", -1L);
                    if (null == this.mCallback || d == null || t == -1L) return;
                    this.mCallback.onAudioRouteSwitchEnd(d, t);
                }
                return;
            } else {
                if (!"com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_RES".equals(intent.getAction())) return;
                if (this.mSessionId != nSessionId) {
                    return;
                }
                if ("OPERATION_GETDEVICELIST".equals(strOperation)) {
                    String[] strDeviceList = intent.getStringArrayExtra("EXTRA_DATA_AVAILABLEDEVICE_LIST");
                    String con = intent.getStringExtra("EXTRA_DATA_CONNECTEDDEVICE");
                    String prevCon = intent.getStringExtra("EXTRA_DATA_PREV_CONNECTEDDEVICE");
                    String btName = intent.getStringExtra("EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME");
                    String str = "\n";
                    boolean _cs2earphone = true;
                    for (int i = 0; i < strDeviceList.length; ++i) {
                        str = str + "AudioSession|    " + i + " " + strDeviceList[i] + "\n";
                        if (!strDeviceList[i].equals("DEVICE_WIREDHEADSET") && !strDeviceList[i].equals("DEVICE_BLUETOOTHHEADSET")) continue;
                        _cs2earphone = false;
                    }
                    str = str + "\n";
                    this._canSwtich2Earphone = _cs2earphone;
                    this._connectedDev = con;
                    QLog.w(TAG, "AudioSession|[onGetDeviceListRes] err:" + errCode + " connected:" + con + " prevConnected:" + prevCon + " bt:" + btName + " Num:" + strDeviceList.length + str);
                    if (null == this.mCallback) return;
                    this.mCallback.onGetDeviceListRes(errCode, strDeviceList, con, prevCon, btName);
                    return;
                } else if ("OPERATION_CONNECTDEVICE".equals(strOperation)) {
                    String strDeviceName = intent.getStringExtra("CONNECTDEVICE_RESULT_DEVICENAME");
                    QLog.w(TAG, "AudioSession|[onConnectDeviceRes] err:" + errCode + " dev:" + strDeviceName);
                    if (null == this.mCallback) return;
                    this.mCallback.onConnectDeviceRes(errCode, strDeviceName, errCode == 0);
                    return;
                } else {
                    if ("OPERATION_EARACTION".equals(strOperation)) {
                        int _earAction = intent.getIntExtra("EXTRA_EARACTION", -1);
                        QLog.w(TAG, "AudioSession|[onConnectDeviceRes] err:" + errCode + " earAction:" + _earAction);
                        if (null == this.mCallback) return;
                    }
                    if ("OPERATION_ISDEVICECHANGABLED".equals(strOperation)) {
                        boolean bIsChangabled = intent.getBooleanExtra("ISDEVICECHANGABLED_REULT_ISCHANGABLED", false);
                        QLog.w(TAG, "AudioSession|[onIsDeviceChangabledRes] err:" + errCode + " Changabled:" + (bIsChangabled ? "Y" : "N"));
                        if (null == this.mCallback) return;
                        this.mCallback.onIsDeviceChangabledRes(errCode, bIsChangabled);
                        return;
                    } else if ("OPERATION_GETCONNECTEDDEVICE".equals(strOperation)) {
                        String strDeviceName = intent.getStringExtra("GETCONNECTEDDEVICE_REULT_LIST");
                        QLog.w(TAG, "AudioSession|[onGetConnectedDeviceRes] err:" + errCode + " dev:" + strDeviceName);
                        if (null == this.mCallback) return;
                        this.mCallback.onGetConnectedDeviceRes(errCode, strDeviceName);
                        return;
                    } else if ("OPERATION_GETCONNECTINGDEVICE".equals(strOperation)) {
                        String strDeviceName = intent.getStringExtra("GETCONNECTINGDEVICE_REULT_LIST");
                        QLog.w(TAG, "AudioSession|[onGetConnectingDeviceRes] err:" + errCode + " dev:" + strDeviceName);
                        if (null == this.mCallback) return;
                        this.mCallback.onGetConnectingDeviceRes(errCode, strDeviceName);
                        return;
                    } else if ("OPERATION_GETSTREAMTYPE".equals(strOperation)) {
                        int st = intent.getIntExtra("EXTRA_DATA_STREAMTYPE", -1);
                        QLog.w(TAG, "AudioSession|[onGetStreamTypeRes] err:" + errCode + " st:" + st);
                        if (null == this.mCallback) return;
                        this.mCallback.onGetStreamTypeRes(errCode, st);
                        return;
                    } else if ("NOTIFY_RING_COMPLETION".equals(strOperation)) {
                        String userData = intent.getStringExtra("PARAM_RING_USERDATA_STRING");
                        QLog.w(TAG, "AudioSession|[onRingCompletion] err:" + errCode + " userData:" + userData);
                        if (null == this.mCallback) return;
                        this.mCallback.onRingCompletion(errCode, userData);
                        return;
                    } else {
                        if (!"OPERATION_VOICECALL_PREPROCESS".equals(strOperation)) return;
                        QLog.w(TAG, "AudioSession|[onVoicecallPreprocess] err:" + errCode);
                        if (null == this.mCallback) return;
                        this.mCallback.onVoicecallPreprocessRes(errCode);
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            QLog.e(TAG, "AudioSession| nSessinId = " + this.mSessionId + " onReceive::intent:" + intent.toString() + " intent.getAction():" + intent.getAction() + " Exception:" + e.getMessage());
        }
    }

    public static interface ITraeAudioCallback {
        public void onServiceStateUpdate(boolean var1);

        public void onDeviceListUpdate(String[] var1, String var2, String var3, String var4);

        public void onDeviceChangabledUpdate(boolean var1);

        public void onStreamTypeUpdate(int var1);

        public void onGetDeviceListRes(int var1, String[] var2, String var3, String var4, String var5);

        public void onConnectDeviceRes(int var1, String var2, boolean var3);

        public void onIsDeviceChangabledRes(int var1, boolean var2);

        public void onGetConnectedDeviceRes(int var1, String var2);

        public void onGetConnectingDeviceRes(int var1, String var2);

        public void onGetStreamTypeRes(int var1, int var2);

        public void onRingCompletion(int var1, String var2);

        public void onVoicecallPreprocessRes(int var1);

        public void onAudioRouteSwitchStart(String var1, String var2);

        public void onAudioRouteSwitchEnd(String var1, long var2);
    }
}

