/*
 * Decompiled with CFR 0.152.
 */
package com.gme.sharpgme.jni;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.gme.av.utils.ClientInfo;
import com.gme.av.utils.QLog;
import com.gme.sharpgme.jni.AudioDeviceInterface;
import com.gme.sharpgme.jni.TraeAudioSession;
import com.gme.sharpgme.jni.TraeAudioSessionHost;
import com.gme.sharpgme.jni.TraeMediaPlayer;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@SuppressLint(value={"NewApi"})
public class TraeAudioManager
extends BroadcastReceiver {
    private static final String TAG = "TraeAudioManager";
    public static final String ACTION_TRAEAUDIOMANAGER_REQUEST = "com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_REQUEST";
    public static final String ACTION_TRAEAUDIOMANAGER_RES = "com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_RES";
    public static final String ACTION_TRAEAUDIOMANAGER_NOTIFY = "com.gme.sharpgme.ACTION_TRAEAUDIOMANAGER_NOTIFY";
    public static final String PARAM_OPERATION = "PARAM_OPERATION";
    public static final String PARAM_SESSIONID = "PARAM_SESSIONID";
    public static final String PARAM_ISHOSTSIDE = "PARAM_ISHOSTSIDE";
    public static final String PARAM_RES_ERRCODE = "PARAM_RES_ERRCODE";
    public static final int RES_ERRCODE_NONE = 0;
    public static final int RES_ERRCODE_SERVICE_OFF = 1;
    public static final int RES_ERRCODE_VOICECALL_EXIST = 2;
    public static final int RES_ERRCODE_VOICECALL_NOT_EXIST = 3;
    public static final int RES_ERRCODE_STOPRING_INTERRUPT = 4;
    public static final int RES_ERRCODE_RING_NOT_EXIST = 5;
    public static final int RES_ERRCODE_VOICECALLPOST_INTERRUPT = 6;
    public static final int RES_ERRCODE_DEVICE_UNKOWN = 7;
    public static final int RES_ERRCODE_DEVICE_NOT_VISIABLE = 8;
    public static final int RES_ERRCODE_DEVICE_UNCHANGEABLE = 9;
    public static final int RES_ERRCODE_DEVICE_BTCONNCECTED_TIMEOUT = 10;
    public static final String PARAM_STATUS = "PARAM_STATUS";
    public static final String PARAM_DEVICE = "PARAM_DEVICE";
    public static final String PARAM_ERROR = "PARAM_ERROR";
    public static final String PARAM_MODEPOLICY = "PARAM_MODEPOLICY";
    public static final String PARAM_STREAMTYPE = "PARAM_STREAMTYPE";
    public static final String PARAM_RING_DATASOURCE = "PARAM_RING_DATASOURCE";
    public static final String PARAM_RING_RSID = "PARAM_RING_RSID";
    public static final String PARAM_RING_URI = "PARAM_RING_URI";
    public static final String PARAM_RING_FILEPATH = "PARAM_RING_FILEPATH";
    public static final String PARAM_RING_LOOP = "PARAM_RING_LOOP";
    public static final String PARAM_RING_LOOPCOUNT = "PARAM_RING_LOOPCOUNT";
    public static final String PARAM_RING_MODE = "PARAM_RING_MODE";
    public static final String PARAM_RING_USERDATA_STRING = "PARAM_RING_USERDATA_STRING";
    public static final String OPERATION_STARTSERVICE = "OPERATION_STARTSERVICE";
    public static final String EXTRA_DATA_DEVICECONFIG = "EXTRA_DATA_DEVICECONFIG";
    public static final String OPERATION_STOPSERVICE = "OPERATION_STOPSERVICE";
    public static final String OPERATION_REGISTERAUDIOSESSION = "OPERATION_REGISTERAUDIOSESSION";
    public static final String REGISTERAUDIOSESSION_ISREGISTER = "REGISTERAUDIOSESSION_ISREGISTER";
    public static final String OPERATION_GETDEVICELIST = "OPERATION_GETDEVICELIST";
    public static final String OPERATION_GETSTREAMTYPE = "OPERATION_GETSTREAMTYPE";
    public static final String OPERATION_CONNECTDEVICE = "OPERATION_CONNECTDEVICE";
    public static final String OPERATION_FORCE_CONNECTDEVICE = "OPERATION_FORCE_CONNECTDEVICE";
    public static final String CONNECTDEVICE_DEVICENAME = "CONNECTDEVICE_DEVICENAME";
    public static final String CONNECTDEVICE_RESULT_DEVICENAME = "CONNECTDEVICE_RESULT_DEVICENAME";
    public static final String OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE = "OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE";
    public static final String OPERATION_ISDEVICECHANGABLED = "OPERATION_ISDEVICECHANGABLED";
    public static final String ISDEVICECHANGABLED_RESULT_ISCHANGABLED = "ISDEVICECHANGABLED_REULT_ISCHANGABLED";
    public static final String OPERATION_GETCONNECTEDDEVICE = "OPERATION_GETCONNECTEDDEVICE";
    public static final String GETCONNECTEDDEVICE_RESULT_LIST = "GETCONNECTEDDEVICE_REULT_LIST";
    public static final String OPERATION_GETCONNECTINGDEVICE = "OPERATION_GETCONNECTINGDEVICE";
    public static final String GETCONNECTINGDEVICE_RESULT_LIST = "GETCONNECTINGDEVICE_REULT_LIST";
    public static final String EXTRA_DATA_STREAMTYPE = "EXTRA_DATA_STREAMTYPE";
    public static final String OPERATION_VOICECALL_PREPROCESS = "OPERATION_VOICECALL_PREPROCESS";
    public static final String OPERATION_VOICECALL_POSTPROCESS = "OPERATION_VOICECALL_POSTROCESS";
    public static final String OPERATION_STARTRING = "OPERATION_STARTRING";
    public static final String OPERATION_STOPRING = "OPERATION_STOPRING";
    public static final String OPERATION_REQUEST_RELEASE_AUDIO_FOCUS = "OPERATION_REQUEST_RELEASE_AUDIO_FOCUS";
    public static final String OPERATION_RECOVER_AUDIO_FOCUS = "OPERATION_RECOVER_AUDIO_FOCUS";
    public static final String OPERATION_VOICECALL_AUDIOPARAM_CHANGED = "OPERATION_VOICECALL_AUDIOPARAM_CHANGED";
    public static final String NOTIFY_SERVICE_STATE = "NOTIFY_SERVICE_STATE";
    public static final String NOTIFY_SERVICE_STATE_DATE = "NOTIFY_SERVICE_STATE_DATE";
    public static final String NOTIFY_DEVICELIST_UPDATE = "NOTIFY_DEVICELISTUPDATE";
    public static final String EXTRA_DATA_AVAILABLEDEVICE_LIST = "EXTRA_DATA_AVAILABLEDEVICE_LIST";
    public static final String EXTRA_DATA_PREV_CONNECTEDDEVICE = "EXTRA_DATA_PREV_CONNECTEDDEVICE";
    public static final String EXTRA_DATA_CONNECTEDDEVICE = "EXTRA_DATA_CONNECTEDDEVICE";
    public static final String EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME = "EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME";
    public static final String NOTIFY_DEVICECHANGABLE_UPDATE = "NOTIFY_DEVICECHANGABLE_UPDATE";
    public static final String NOTIFY_DEVICECHANGABLE_UPDATE_DATE = "NOTIFY_DEVICECHANGABLE_UPDATE_DATE";
    public static final String NOTIFY_RING_COMPLETION = "NOTIFY_RING_COMPLETION";
    public static final String NOTIFY_STREAMTYPE_UPDATE = "NOTIFY_STREAMTYPE_UPDATE";
    public static final String NOTIFY_ROUTESWITCHSTART = "NOTIFY_ROUTESWITCHSTART";
    public static final String EXTRA_DATA_ROUTESWITCHSTART_FROM = "EXTRA_DATA_ROUTESWITCHSTART_FROM";
    public static final String EXTRA_DATA_ROUTESWITCHSTART_TO = "EXTRA_DATA_ROUTESWITCHSTART_TO";
    public static final String NOTIFY_ROUTESWITCHEND = "NOTIFY_ROUTESWITCHEND";
    public static final String EXTRA_DATA_ROUTESWITCHEND_DEV = "EXTRA_DATA_ROUTESWITCHEND_DEV";
    public static final String EXTRA_DATA_ROUTESWITCHEND_TIME = "EXTRA_DATA_ROUTESWITCHEND_TIME";
    public static final int EARACTION_AWAY = 0;
    public static final int EARACTION_CLOSE = 1;
    public static final String OPERATION_EARACTION = "OPERATION_EARACTION";
    public static final String EXTRA_EARACTION = "EXTRA_EARACTION";
    public static final String DEVICE_NONE = "DEVICE_NONE";
    public static final String DEVICE_EARPHONE = "DEVICE_EARPHONE";
    public static final String DEVICE_SPEAKERPHONE = "DEVICE_SPEAKERPHONE";
    public static final String DEVICE_WIREDHEADSET = "DEVICE_WIREDHEADSET";
    public static final String DEVICE_BLUETOOTHHEADSET = "DEVICE_BLUETOOTHHEADSET";
    public static final int DEVICE_STATUS_ERROR = -1;
    public static final int DEVICE_STATUS_DISCONNECTED = 0;
    public static final int DEVICE_STATUS_CONNECTING = 1;
    public static final int DEVICE_STATUS_CONNECTED = 2;
    public static final int DEVICE_STATUS_DISCONNECTING = 3;
    public static final int DEVICE_STATUS_UNCHANGEABLE = 4;
    public static final int AUDIO_MANAGER_ACTIVE_NONE = 0;
    public static final int AUDIO_MANAGER_ACTIVE_VOICECALL = 1;
    public static final int AUDIO_MANAGER_ACTIVE_RING = 2;
    public static final int MODE_VOICE_CHAT = 0;
    public static final int MODE_MUSIC_PLAY_RECORD = 1;
    public static final int MODE_MUSIC_PLAYBACK = 2;
    public static final int MODE_MUSIC_PLAY_RECORD_HIGH_QUALITY = 3;
    public static final int MODE_VOICE_PLAYBACK = 4;
    public static final int MODE_MUSIC_PLAY_RECORD_LOW_QUALITY = 5;
    public static final int MODE_GAME_PLAYBACK = 7;
    AudioManager _am = null;
    Context _context = null;
    boolean _speakerOn = true;
    int _activeMode = 0;
    int _prevMode = 0;
    int _streamType = 0;
    int _modePolicy = -1;
    public static int bluetoothState = 4;
    public static boolean needStopBluetoothSco = false;
    public static boolean IsMusicScene = false;
    public static int nSceneMode = -1;
    public static int nSpecialModeBypass3A = 0;
    public static int nSpeakerStreamType = 0;
    public static boolean IsEarPhoneSupported = false;
    public static boolean IsUpdateSceneFlag = false;
    boolean IsBluetoothA2dpExisted = true;
    public static final String VOICECALL_CONFIG = "DEVICE_SPEAKERPHONE;DEVICE_EARPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;";
    public static final String VIDEO_CONFIG = "DEVICE_EARPHONE;DEVICE_SPEAKERPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;";
    public static final String MUSIC_CONFIG = "DEVICE_SPEAKERPHONE;DEVICE_WIREDHEADSET;DEVICE_BLUETOOTHHEADSET;";
    public static String CurConnectedDevice = "DEVICE_NONE";
    TraeAudioSessionHost _audioSessionHost = null;
    DeviceConfigManager _deviceConfigManager = null;
    BluetoohHeadsetCheckInterface _bluetoothCheck = null;
    String sessionConnectedDev = "DEVICE_NONE";
    static ReentrantLock _glock = new ReentrantLock();
    static TraeAudioManager _ginstance = null;
    static int _gHostProcessId = -1;
    TraeAudioManagerLooper mTraeAudioManagerLooper = null;
    ReentrantLock _lock = new ReentrantLock();
    static final String AUDIO_PARAMETER_STREAM_ROUTING = "routing";
    static final int AUDIO_DEVICE_OUT_EARPIECE = 1;
    static final int AUDIO_DEVICE_OUT_SPEAKER = 2;
    static final int AUDIO_DEVICE_OUT_WIRED_HEADSET = 4;
    static final int AUDIO_DEVICE_OUT_WIRED_HEADPHONE = 8;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO = 16;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO_HEADSET = 32;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO_CARKIT = 64;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP = 128;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    switchThread _switchThread = null;
    public static final int FORCE_NONE = 0;
    public static final int FORCE_SPEAKER = 1;
    public static final int FORCE_HEADPHONES = 2;
    public static final int FORCE_BT_SCO = 3;
    public static final int FORCE_BT_A2DP = 4;
    public static final int FORCE_WIRED_ACCESSORY = 5;
    public static final int FORCE_BT_CAR_DOCK = 6;
    public static final int FORCE_BT_DESK_DOCK = 7;
    public static final int FORCE_ANALOG_DOCK = 8;
    public static final int FORCE_DIGITAL_DOCK = 9;
    public static final int FORCE_NO_BT_A2DP = 10;
    private static final int NUM_FORCE_CONFIG = 11;
    public static final int FORCE_DEFAULT = 0;
    public static final int FOR_COMMUNICATION = 0;
    public static final int FOR_MEDIA = 1;
    public static final int FOR_RECORD = 2;
    public static final int FOR_DOCK = 3;
    private static final int NUM_FORCE_USE = 4;
    static final String[] forceName = new String[]{"FORCE_NONE", "FORCE_SPEAKER", "FORCE_HEADPHONES", "FORCE_BT_SCO", "FORCE_BT_A2DP", "FORCE_WIRED_ACCESSORY", "FORCE_BT_CAR_DOCK", "FORCE_BT_DESK_DOCK", "FORCE_ANALOG_DOCK", "FORCE_NO_BT_A2DP", "FORCE_DIGITAL_DOCK"};

    public static String getConnectedDevice() {
        return CurConnectedDevice;
    }

    public static boolean checkDevName(String strDeviceName) {
        if (strDeviceName == null) {
            return false;
        }
        return DEVICE_SPEAKERPHONE.equals(strDeviceName) || DEVICE_EARPHONE.equals(strDeviceName) || DEVICE_WIREDHEADSET.equals(strDeviceName) || DEVICE_BLUETOOTHHEADSET.equals(strDeviceName);
    }

    public static boolean isHandfree(String strDeviceName) {
        if (!TraeAudioManager.checkDevName(strDeviceName)) {
            return false;
        }
        return DEVICE_SPEAKERPHONE.equals(strDeviceName);
    }

    void printDevices() {
        AudioDeviceInterface.LogTraceEntry("");
        int n = this._deviceConfigManager.getDeviceNumber();
        QLog.w(TAG, "   ConnectedDevice:" + this._deviceConfigManager.getConnectedDevice());
        QLog.w(TAG, "   ConnectingDevice:" + this._deviceConfigManager.getConnectingDevice());
        QLog.w(TAG, "   prevConnectedDevice:" + this._deviceConfigManager.getPrevConnectedDevice());
        QLog.w(TAG, "   AHPDevice:" + this._deviceConfigManager.getAvailabledHighestPriorityDevice());
        QLog.w(TAG, "   deviceNamber:" + n);
        for (int i = 0; i < n; ++i) {
            String devName = this._deviceConfigManager.getDeviceName(i);
            QLog.w(TAG, "      " + i + " devName:" + devName + " Visible:" + this._deviceConfigManager.getVisible(devName) + " Priority:" + this._deviceConfigManager.getPriority(devName));
        }
        String[] alist = this._deviceConfigManager.getAvailableDeviceList().toArray(new String[0]);
        QLog.w(TAG, "   AvailableNamber:" + alist.length);
        for (int i = 0; i < alist.length; ++i) {
            String devName = alist[i];
            QLog.w(TAG, "      " + i + " devName:" + devName + " Visible:" + this._deviceConfigManager.getVisible(devName) + " Priority:" + this._deviceConfigManager.getPriority(devName));
        }
        AudioDeviceInterface.LogTraceExit();
    }

    static boolean isCloseSystemAPM(int modePolicy) {
        if (modePolicy != -1) {
            return false;
        }
        if (ClientInfo.MANUFACTURER.equals("Xiaomi")) {
            if (ClientInfo.MODEL.equals("MI 2")) {
                return true;
            }
            if (ClientInfo.MODEL.equals("MI 2A")) {
                return true;
            }
            if (ClientInfo.MODEL.equals("MI 2S")) {
                return true;
            }
            if (ClientInfo.MODEL.equals("MI 2SC")) {
                return true;
            }
        } else if (ClientInfo.MANUFACTURER.equals("samsung") && ClientInfo.MODEL.equals("SCH-I959")) {
            return true;
        }
        return false;
    }

    static int getAudioSource(int audioSourcePolicy) {
        int source = 0;
        if (IsMusicScene) {
            return source;
        }
        int apiLevel = ClientInfo.VERSION_SDK_INT;
        if (audioSourcePolicy >= 0) {
            source = audioSourcePolicy;
            QLog.w(TAG, "[Config] getAudioSource _audioSourcePolicy:" + audioSourcePolicy + " source:" + source);
            return audioSourcePolicy;
        }
        if (apiLevel >= 11) {
            source = 7;
        }
        QLog.w(TAG, "[Config] getAudioSource _audioSourcePolicy:" + audioSourcePolicy + " source:" + source);
        return source;
    }

    static int getAudioStreamType(int audioStreamTypePolicy) {
        int streamType = 3;
        if (IsMusicScene) {
            return streamType;
        }
        int apiLevel = ClientInfo.VERSION_SDK_INT;
        if (audioStreamTypePolicy >= 0) {
            streamType = audioStreamTypePolicy;
        } else if (apiLevel >= 9) {
            streamType = 0;
        }
        QLog.w(TAG, "[Config] getAudioStreamType audioStreamTypePolicy:" + audioStreamTypePolicy + " streamType:" + streamType);
        return streamType;
    }

    static int getCallAudioMode(int modePolicy) {
        int mode = 0;
        if (IsMusicScene) {
            return mode;
        }
        int apiLevel = ClientInfo.VERSION_SDK_INT;
        if (modePolicy >= 0) {
            mode = modePolicy;
            QLog.w(TAG, "[Config] getCallAudioMode modePolicy:" + modePolicy + " mode:" + mode);
            return mode;
        }
        if (apiLevel >= 11) {
            mode = 3;
        }
        QLog.w(TAG, "[Config] getCallAudioMode _modePolicy:" + modePolicy + " mode:" + mode + "facturer:" + ClientInfo.MANUFACTURER + " model:" + ClientInfo.MODEL);
        return mode;
    }

    void updateDeviceStatus() {
        int n = this._deviceConfigManager.getDeviceNumber();
        for (int i = 0; i < n; ++i) {
            boolean setSuccess = false;
            String devName = this._deviceConfigManager.getDeviceName(i);
            if (devName != null) {
                if (devName.equals(DEVICE_BLUETOOTHHEADSET)) {
                    setSuccess = this._bluetoothCheck == null ? this._deviceConfigManager.setVisible(devName, false) : this._deviceConfigManager.setVisible(devName, this._bluetoothCheck.isConnected());
                } else if (devName.equals(DEVICE_WIREDHEADSET)) {
                    setSuccess = this._deviceConfigManager.setVisible(devName, this.isWiredHeadsetVisible(this._am));
                } else if (devName.equals(DEVICE_SPEAKERPHONE)) {
                    this._deviceConfigManager.setVisible(devName, true);
                }
            }
            if (!setSuccess) continue;
            QLog.w(TAG, "pollUpdateDevice dev:" + devName + " Visible:" + this._deviceConfigManager.getVisible(devName));
        }
        this.checkAutoDeviceListUpdate();
    }

    void _updateEarphoneVisable() {
        if (this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET)) {
            QLog.w(TAG, " detected headset plugin,so disable earphone");
            this._deviceConfigManager.setVisible(DEVICE_EARPHONE, false);
        } else {
            QLog.w(TAG, " detected headset plugout,so enable earphone");
            this._deviceConfigManager.setVisible(DEVICE_EARPHONE, true);
        }
    }

    void checkAutoDeviceListUpdate() {
        if (this._deviceConfigManager.getVisiableUpdateFlag()) {
            QLog.w(TAG, "checkAutoDeviceListUpdate got update!");
            this._updateEarphoneVisable();
            this._deviceConfigManager.resetVisiableUpdateFlag();
            HashMap<String, Object> params = new HashMap<String, Object>();
            this.internalSendMessage(32785, params);
        }
    }

    void checkDevicePlug(String devName, boolean isPlugin) {
        if (this._deviceConfigManager.getVisiableUpdateFlag()) {
            QLog.w(TAG, "checkDevicePlug got update dev:" + devName + (isPlugin ? " piugin" : " plugout") + " connectedDev:" + this._deviceConfigManager.getConnectedDevice());
            this._updateEarphoneVisable();
            this._deviceConfigManager.resetVisiableUpdateFlag();
            if (isPlugin) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(PARAM_DEVICE, devName);
                this.internalSendMessage(32786, params);
            } else {
                String connectedDev = this._deviceConfigManager.getConnectedDevice();
                if (connectedDev.equals(devName) || connectedDev.equals(DEVICE_NONE)) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put(PARAM_DEVICE, devName);
                    this.internalSendMessage(32787, params);
                } else {
                    QLog.w(TAG, " ---No switch,plugout:" + devName + " connectedDev:" + connectedDev);
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    this.internalSendMessage(32785, params);
                }
            }
        }
    }

    public static int OpenSpeaker(boolean speakerOn) {
        int iRet = -1;
        _glock.lock();
        if (null != _ginstance) {
            iRet = 0;
            if (speakerOn != TraeAudioManager._ginstance._speakerOn) {
                TraeAudioManager._ginstance._speakerOn = speakerOn;
                iRet = _ginstance.InternalSetSpeaker(TraeAudioManager._ginstance._context, speakerOn);
            }
        } else {
            QLog.w(TAG, "TraeAudioManager|static SetSpeakerForTest|null == _ginstance");
        }
        _glock.unlock();
        return iRet;
    }

    public static int SetSpeakerForTest(Context context, boolean speakerOn) {
        int iRet = -1;
        _glock.lock();
        if (null != _ginstance) {
            iRet = _ginstance.InternalSetSpeaker(context, speakerOn);
        } else {
            QLog.w(TAG, "TraeAudioManager|static SetSpeakerForTest|null == _ginstance");
        }
        _glock.unlock();
        return iRet;
    }

    int InternalSetSpeaker(Context context, boolean speakerOn) {
        QLog.i(TAG, "InternalSetSpeaker entry. speakerOn:" + speakerOn);
        if (context == null) {
            QLog.e(TAG, "Could not InternalSetSpeaker - no context");
            return -1;
        }
        AudioManager am = (AudioManager)context.getSystemService("audio");
        if (am == null) {
            QLog.e(TAG, "Could not InternalSetSpeaker - no audio manager");
            return -1;
        }
        boolean old = am.isSpeakerphoneOn();
        if (old != speakerOn) {
            am.setSpeakerphoneOn(speakerOn);
        }
        int res = am.isSpeakerphoneOn() == speakerOn ? 0 : -1;
        QLog.i(TAG, String.format("InternalSetSpeaker exit:Speaker:%s->%s, mode=%s", old, am.isSpeakerphoneOn(), am.getMode()));
        return res;
    }

    void InternalSetMode(int audioMode) {
        QLog.w(TAG, "SetMode entry:" + audioMode);
        if (this._am == null) {
            QLog.w(TAG, "setMode:" + audioMode + " fail am=null");
            return;
        }
        try {
            this._am.setMode(audioMode);
        }
        catch (Exception e) {
            QLog.e(TAG, "setMode:" + audioMode + " exception");
        }
        QLog.w(TAG, "setMode:" + audioMode + (this._am.getMode() != audioMode ? "fail" : "success"));
    }

    public static int registerAudioSession(TraeAudioSession _traeAs, boolean bRegister, long nSessionId, Context ctx) {
        int iRet = -1;
        _glock.lock();
        if (null != _ginstance && null != TraeAudioManager._ginstance._audioSessionHost) {
            if (bRegister) {
                TraeAudioManager._ginstance._audioSessionHost.add(_traeAs, nSessionId, ctx);
            } else {
                TraeAudioManager._ginstance._audioSessionHost.remove(nSessionId);
            }
            iRet = 0;
        }
        _glock.unlock();
        return iRet;
    }

    public static int sendMessage(int nMsg, HashMap<String, Object> params) {
        int iRet = -1;
        _glock.lock();
        if (null != _ginstance) {
            iRet = _ginstance.internalSendMessage(nMsg, params);
        }
        _glock.unlock();
        return iRet;
    }

    public static int init(Context ctx) {
        _glock.lock();
        if (_ginstance == null) {
            Log.w((String)TAG, (String)("TraeAudioManager first init _ginstance:" + (Object)((Object)_ginstance)));
        }
        if (null == _ginstance) {
            _ginstance = new TraeAudioManager(ctx);
        }
        _glock.unlock();
        return 0;
    }

    public static void uninit() {
        _glock.lock();
        Log.w((String)TAG, (String)("TraeAudioManager uninit _ginstance:" + (Object)((Object)_ginstance)));
        if (null != _ginstance) {
            _ginstance.release();
            _ginstance = null;
        }
        _glock.unlock();
    }

    TraeAudioManager(Context ctx) {
        AudioDeviceInterface.LogTraceEntry(" context:" + ctx);
        if (ctx == null) {
            return;
        }
        this._context = ctx;
        this.mTraeAudioManagerLooper = new TraeAudioManagerLooper(this);
        if (this.mTraeAudioManagerLooper != null) {
            // empty if block
        }
        AudioDeviceInterface.LogTraceExit();
    }

    public void release() {
        AudioDeviceInterface.LogTraceEntry("");
        if (null != this.mTraeAudioManagerLooper) {
            this.mTraeAudioManagerLooper.quit();
            this.mTraeAudioManagerLooper = null;
        }
        AudioDeviceInterface.LogTraceExit();
    }

    public void onReceive(Context context, Intent intent) {
        if (intent == null || context == null) {
            QLog.d(TAG, "onReceive intent or context is null!");
            return;
        }
        boolean prevWiredHeadset = false;
        boolean prevBluetoothHeadset = false;
        try {
            String strAction = intent.getAction();
            String strOption = intent.getStringExtra(PARAM_OPERATION);
            QLog.w(TAG, "TraeAudioManager|onReceive::Action:" + intent.getAction());
            if (this._deviceConfigManager == null) {
                QLog.d(TAG, "_deviceConfigManager null!");
                return;
            }
            prevWiredHeadset = this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET);
            prevBluetoothHeadset = this._deviceConfigManager.getVisible(DEVICE_BLUETOOTHHEADSET);
            if ("android.intent.action.HEADSET_PLUG".equals(intent.getAction())) {
                this.onHeadsetPlug(context, intent);
                if (!prevWiredHeadset && this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET)) {
                    this.checkDevicePlug(DEVICE_WIREDHEADSET, true);
                }
                if (prevWiredHeadset && !this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET)) {
                    this.checkDevicePlug(DEVICE_WIREDHEADSET, false);
                }
            } else if (!"android.media.AUDIO_BECOMING_NOISY".equals(intent.getAction())) {
                if (ACTION_TRAEAUDIOMANAGER_REQUEST.equals(strAction)) {
                    QLog.w(TAG, "   OPERATION:" + strOption);
                    if (OPERATION_STARTSERVICE.equals(strOption)) {
                        TraeAudioManager.startService(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, intent.getStringExtra(EXTRA_DATA_DEVICECONFIG));
                    } else if (OPERATION_STOPSERVICE.equals(strOption)) {
                        TraeAudioManager.stopService(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_GETDEVICELIST.equals(strOption)) {
                        TraeAudioManager.getDeviceList(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_GETSTREAMTYPE.equals(strOption)) {
                        TraeAudioManager.getStreamType(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_CONNECTDEVICE.equals(strOption)) {
                        TraeAudioManager.connectDevice(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, intent.getStringExtra(CONNECTDEVICE_DEVICENAME));
                    } else if (OPERATION_FORCE_CONNECTDEVICE.equals(strOption)) {
                        TraeAudioManager.forceConnectDevice(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, intent.getStringExtra(CONNECTDEVICE_DEVICENAME));
                    } else if (OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE.equals(strOption)) {
                        TraeAudioManager.connectHighestPriorityDevice(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_EARACTION.equals(strOption)) {
                        TraeAudioManager.earAction(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, intent.getIntExtra(EXTRA_EARACTION, -1));
                    } else if (OPERATION_ISDEVICECHANGABLED.equals(strOption)) {
                        TraeAudioManager.isDeviceChangabled(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_GETCONNECTEDDEVICE.equals(strOption)) {
                        TraeAudioManager.getConnectedDevice(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_GETCONNECTINGDEVICE.equals(strOption)) {
                        TraeAudioManager.getConnectingDevice(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_VOICECALL_PREPROCESS.equals(strOption)) {
                        int modePolicy = intent.getIntExtra(PARAM_MODEPOLICY, -1);
                        int streamType = intent.getIntExtra(PARAM_STREAMTYPE, -1);
                        TraeAudioManager.voicecallPreprocess(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, modePolicy, streamType);
                    } else if (OPERATION_VOICECALL_POSTPROCESS.equals(strOption)) {
                        TraeAudioManager.voicecallPostprocess(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_VOICECALL_AUDIOPARAM_CHANGED.equals(strOption)) {
                        int modePolicy = intent.getIntExtra(PARAM_MODEPOLICY, -1);
                        int streamType = intent.getIntExtra(PARAM_STREAMTYPE, -1);
                        TraeAudioManager.voiceCallAudioParamChanged(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, modePolicy, streamType);
                    } else if (OPERATION_STARTRING.equals(strOption)) {
                        Uri res = null;
                        String strFilePath = null;
                        String userData = null;
                        int dataSource = intent.getIntExtra(PARAM_RING_DATASOURCE, -1);
                        int rsId = intent.getIntExtra(PARAM_RING_RSID, -1);
                        res = (Uri)intent.getParcelableExtra(PARAM_RING_URI);
                        strFilePath = intent.getStringExtra(PARAM_RING_FILEPATH);
                        boolean bLoop = intent.getBooleanExtra(PARAM_RING_LOOP, false);
                        userData = intent.getStringExtra(PARAM_RING_USERDATA_STRING);
                        int loopCount = intent.getIntExtra(PARAM_RING_LOOPCOUNT, 1);
                        boolean ringMode = intent.getBooleanExtra(PARAM_RING_MODE, false);
                        TraeAudioManager.startRing(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, dataSource, rsId, res, strFilePath, bLoop, loopCount, userData, ringMode);
                    } else if (OPERATION_STOPRING.equals(strOption)) {
                        TraeAudioManager.stopRing(strOption, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    }
                } else if (this._deviceConfigManager != null) {
                    if (this._bluetoothCheck != null) {
                        this._bluetoothCheck.onReceive(context, intent, this._deviceConfigManager);
                    }
                    if (!prevBluetoothHeadset && this._deviceConfigManager.getVisible(DEVICE_BLUETOOTHHEADSET)) {
                        this.checkDevicePlug(DEVICE_BLUETOOTHHEADSET, true);
                    }
                    if (prevBluetoothHeadset && !this._deviceConfigManager.getVisible(DEVICE_BLUETOOTHHEADSET)) {
                        this.checkDevicePlug(DEVICE_BLUETOOTHHEADSET, false);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void onHeadsetPlug(Context context, Intent intent) {
        boolean wired = this.isWiredHeadsetVisible(this._am);
        QLog.w(TAG, "onHeadsetPlug: wired= " + wired);
        this._deviceConfigManager.setVisible(DEVICE_WIREDHEADSET, wired);
    }

    int internalSendMessage(int nMsg, HashMap<String, Object> params) {
        int iRet = -1;
        if (null != this.mTraeAudioManagerLooper) {
            iRet = this.mTraeAudioManagerLooper.sendMessage(nMsg, params);
        }
        return iRet;
    }

    static int getDeviceList(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32774, params);
    }

    static int getStreamType(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32784, params);
    }

    static int startService(String strOption, long nSessionId, boolean bHostside, String deviceConfig) {
        if (deviceConfig.length() <= 0) {
            return -1;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        params.put(EXTRA_DATA_DEVICECONFIG, deviceConfig);
        return TraeAudioManager.sendMessage(32772, params);
    }

    static int stopService(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32773, params);
    }

    static int connectDevice(String strOption, long nSessionId, boolean bHostside, String strDevice) {
        if (strDevice == null) {
            return -1;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        params.put(CONNECTDEVICE_DEVICENAME, strDevice);
        params.put(PARAM_DEVICE, strDevice);
        return TraeAudioManager.sendMessage(32775, params);
    }

    static int forceConnectDevice(String strOption, long nSessionId, boolean bHostside, String strDevice) {
        if (strDevice == null) {
            return -1;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        params.put(CONNECTDEVICE_DEVICENAME, strDevice);
        params.put(PARAM_DEVICE, strDevice);
        return TraeAudioManager.sendMessage(32792, params);
    }

    static int connectHighestPriorityDevice(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32789, params);
    }

    static int earAction(String strOption, long nSessionId, boolean bHostside, int earAction) {
        if (earAction != 0 && earAction != 1) {
            return -1;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        params.put(EXTRA_EARACTION, earAction);
        return TraeAudioManager.sendMessage(32776, params);
    }

    static int isDeviceChangabled(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32777, params);
    }

    static int getConnectedDevice(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32778, params);
    }

    static int getConnectingDevice(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32779, params);
    }

    static int voicecallPreprocess(String strOption, long nSessionId, boolean bHostside, int modePolicy, int streamType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        params.put(PARAM_MODEPOLICY, modePolicy);
        params.put(PARAM_STREAMTYPE, streamType);
        return TraeAudioManager.sendMessage(32780, params);
    }

    static int voicecallPostprocess(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32781, params);
    }

    static int voiceCallAudioParamChanged(String strOption, long nSessionId, boolean bHostside, int modePolicy, int streamType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        params.put(PARAM_MODEPOLICY, modePolicy);
        params.put(PARAM_STREAMTYPE, streamType);
        return TraeAudioManager.sendMessage(32788, params);
    }

    static int startRing(String strOption, long nSessionId, boolean bHostside, int dataSource, int rsId, Uri res, String strFilePath, boolean bLoop, int loopCount, String userData, boolean ringMode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        params.put(PARAM_RING_DATASOURCE, dataSource);
        params.put(PARAM_RING_RSID, rsId);
        params.put(PARAM_RING_URI, res);
        params.put(PARAM_RING_FILEPATH, strFilePath);
        params.put(PARAM_RING_LOOP, bLoop);
        params.put(PARAM_RING_LOOPCOUNT, loopCount);
        params.put(PARAM_RING_MODE, ringMode);
        params.put(PARAM_RING_USERDATA_STRING, userData);
        return TraeAudioManager.sendMessage(32782, params);
    }

    static int stopRing(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32783, params);
    }

    static int requestReleaseAudioFocus(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32790, params);
    }

    static int recoverAudioFocus(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARAM_SESSIONID, nSessionId);
        params.put(PARAM_OPERATION, strOption);
        params.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32791, params);
    }

    int InternalSessionConnectDevice(HashMap<String, Object> params, boolean IsForceConnectDevice) {
        AudioDeviceInterface.LogTraceEntry("");
        if (null == params || this._context == null) {
            return -1;
        }
        if (IsMusicScene) {
            QLog.w(TAG, "MusicScene: InternalSessionConnectDevice failed");
            return -1;
        }
        String devName = "unkown";
        devName = (String)params.get(PARAM_DEVICE);
        Log.w((String)TAG, (String)("ConnectDevice: " + devName));
        if (!IsEarPhoneSupported && devName.equals(DEVICE_EARPHONE)) {
            QLog.e(TAG, "InternalSessionConnectDevice IsEarPhoneSupported = false, Connect device:" + devName + " failed");
            return -1;
        }
        int err = 0;
        boolean bChangabled = this.InternalIsDeviceChangeable();
        if (!TraeAudioManager.checkDevName(devName)) {
            err = 7;
        } else if (!this._deviceConfigManager.getVisible(devName)) {
            err = 8;
        } else if (!bChangabled) {
            err = 9;
        }
        QLog.w(TAG, "sessonID:" + (Long)params.get(PARAM_SESSIONID) + " devName:" + devName + " bChangabled:" + (bChangabled ? "Y" : "N") + " err:" + err);
        if (err != 0) {
            Intent intent = new Intent();
            intent.putExtra(CONNECTDEVICE_RESULT_DEVICENAME, (String)params.get(PARAM_DEVICE));
            this.sendResBroadcast(intent, params, err);
            return -1;
        }
        if (!IsForceConnectDevice && devName.equals(this._deviceConfigManager.getConnectedDevice())) {
            QLog.e(TAG, " --has connected!");
            Intent intent = new Intent();
            intent.putExtra(CONNECTDEVICE_RESULT_DEVICENAME, (String)params.get(PARAM_DEVICE));
            this.sendResBroadcast(intent, params, err);
            return 0;
        }
        QLog.w(TAG, " --connecting...");
        this.InternalConnectDevice(devName, params, IsForceConnectDevice);
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    int InternalSessionEarAction(HashMap<String, Object> params) {
        return 0;
    }

    int InternalConnectDevice(String devName, HashMap<String, Object> needResParams, boolean IsForceConnectDevice) {
        AudioDeviceInterface.LogTraceEntry(" devName:" + devName);
        if (devName == null) {
            return -1;
        }
        if (IsMusicScene && devName.equals(DEVICE_EARPHONE)) {
            QLog.e(TAG, "MusicScene, Connect device:" + devName + " failed");
            return -1;
        }
        if (!IsEarPhoneSupported && devName.equals(DEVICE_EARPHONE)) {
            QLog.e(TAG, "IsEarPhoneSupported = false, Connect device:" + devName + " failed");
            return -1;
        }
        if (!IsForceConnectDevice && !this._deviceConfigManager.getConnectedDevice().equals(DEVICE_NONE) && devName.equals(this._deviceConfigManager.getConnectedDevice())) {
            return 0;
        }
        if (!TraeAudioManager.checkDevName(devName) || !this._deviceConfigManager.getVisible(devName)) {
            QLog.e(TAG, " checkDevName fail");
            return -1;
        }
        if (!this.InternalIsDeviceChangeable()) {
            QLog.e(TAG, " InternalIsDeviceChangeable fail");
            return -1;
        }
        this._deviceConfigManager.setConnecting(devName);
        if (this._switchThread != null) {
            QLog.w(TAG, "_switchThread:" + this._switchThread.getDeviceName());
            this._switchThread.quit();
            this._switchThread = null;
        }
        if (devName.equals(DEVICE_EARPHONE)) {
            this._switchThread = new earphoneSwitchThread();
        } else if (devName.equals(DEVICE_SPEAKERPHONE)) {
            this._switchThread = new speakerSwitchThread();
        } else if (devName.equals(DEVICE_WIREDHEADSET)) {
            this._switchThread = new headsetSwitchThread();
        } else if (devName.equals(DEVICE_BLUETOOTHHEADSET)) {
            this._switchThread = new bluetoothHeadsetSwitchThread();
        }
        if (this._switchThread != null) {
            this._switchThread.setDeviceConnectParam(needResParams);
            this._switchThread.start();
        }
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    int InternalSessionIsDeviceChangabled(HashMap<String, Object> params) {
        Intent intent = new Intent();
        intent.putExtra(ISDEVICECHANGABLED_RESULT_ISCHANGABLED, this.InternalIsDeviceChangeable());
        this.sendResBroadcast(intent, params, 0);
        return 0;
    }

    boolean InternalIsDeviceChangeable() {
        String str = null;
        str = this._deviceConfigManager.getConnectingDevice();
        return str == null || str.equals(DEVICE_NONE) || str.equals("");
    }

    int InternalSessionGetConnectedDevice(HashMap<String, Object> params) {
        Intent intent = new Intent();
        intent.putExtra(GETCONNECTEDDEVICE_RESULT_LIST, this._deviceConfigManager.getConnectedDevice());
        this.sendResBroadcast(intent, params, 0);
        return 0;
    }

    int InternalSessionGetConnectingDevice(HashMap<String, Object> params) {
        Intent intent = new Intent();
        intent.putExtra(GETCONNECTINGDEVICE_RESULT_LIST, this._deviceConfigManager.getConnectingDevice());
        this.sendResBroadcast(intent, params, 0);
        return 0;
    }

    int sendResBroadcast(Intent intent, HashMap<String, Object> params, int err) {
        if (this._context == null) {
            return -1;
        }
        Long sid = (Long)params.get(PARAM_SESSIONID);
        QLog.w(TAG, " sessonID:" + sid + " " + (String)params.get(PARAM_OPERATION));
        if (sid == null || sid == Long.MIN_VALUE) {
            this.InternalNotifyDeviceListUpdate();
            QLog.e(TAG, "sendResBroadcast sid null,don't send res");
            return -1;
        }
        final Intent TAMintent = intent;
        final Long TAMSessionId = (Long)params.get(PARAM_SESSIONID);
        final String TAMOperation = (String)params.get(PARAM_OPERATION);
        final int TAMerr = err;
        if (OPERATION_VOICECALL_PREPROCESS.equals(TAMOperation)) {
            TAMintent.setAction(ACTION_TRAEAUDIOMANAGER_RES);
            TAMintent.putExtra(PARAM_SESSIONID, (Serializable)TAMSessionId);
            TAMintent.putExtra(PARAM_OPERATION, TAMOperation);
            TAMintent.putExtra(PARAM_RES_ERRCODE, TAMerr);
            if (this._audioSessionHost != null) {
                this._audioSessionHost.sendToAudioSessionMessage(TAMintent);
            }
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    TAMintent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_RES);
                    TAMintent.putExtra(TraeAudioManager.PARAM_SESSIONID, (Serializable)TAMSessionId);
                    TAMintent.putExtra(TraeAudioManager.PARAM_OPERATION, TAMOperation);
                    TAMintent.putExtra(TraeAudioManager.PARAM_RES_ERRCODE, TAMerr);
                    if (TraeAudioManager.this._context != null) {
                        TAMintent.setPackage(TraeAudioManager.this._context.getPackageName());
                    }
                    TraeAudioManager.this._context.sendBroadcast(TAMintent);
                }
            });
        }
        return 0;
    }

    int InternalNotifyDeviceListUpdate() {
        AudioDeviceInterface.LogTraceEntry("");
        if (null == this._context) {
            return -1;
        }
        HashMap<String, Object> params = this._deviceConfigManager.getSnapParams();
        final ArrayList list = (ArrayList)params.get(EXTRA_DATA_AVAILABLEDEVICE_LIST);
        final String con = (String)params.get(EXTRA_DATA_CONNECTEDDEVICE);
        final String prevCon = (String)params.get(EXTRA_DATA_PREV_CONNECTEDDEVICE);
        final String _bluetoothName = this._deviceConfigManager.getBluetoothName();
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_DEVICELIST_UPDATE);
                intent.putExtra(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, list.toArray(new String[0]));
                intent.putExtra(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, con);
                intent.putExtra(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, prevCon);
                intent.putExtra(TraeAudioManager.EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME, _bluetoothName);
                if (TraeAudioManager.this._context != null) {
                    intent.setPackage(TraeAudioManager.this._context.getPackageName());
                }
                TraeAudioManager.this._context.sendBroadcast(intent);
            }
        });
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    int InternalNotifyDeviceChangableUpdate() {
        if (null == this._context) {
            return -1;
        }
        final boolean TAMisDeviceChangeable = this.InternalIsDeviceChangeable();
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_DEVICECHANGABLE_UPDATE);
                intent.putExtra(TraeAudioManager.NOTIFY_DEVICECHANGABLE_UPDATE_DATE, TAMisDeviceChangeable);
                if (TraeAudioManager.this._context != null) {
                    intent.setPackage(TraeAudioManager.this._context.getPackageName());
                }
                TraeAudioManager.this._context.sendBroadcast(intent);
            }
        });
        return 0;
    }

    public boolean isWiredHeadsetVisible(AudioManager am) {
        if (am == null) {
            return false;
        }
        boolean visible = am.isWiredHeadsetOn();
        if (!visible && ClientInfo.VERSION_SDK_INT >= 23) {
            AudioDeviceInfo[] devs;
            for (AudioDeviceInfo dev : devs = am.getDevices(2)) {
                if (dev.getType() != 11 && dev.getType() != 22 && dev.getType() != 9) continue;
                visible = true;
                break;
            }
        }
        return visible;
    }

    public BluetoohHeadsetCheckInterface CreateBluetoothCheck(Context context, DeviceConfigManager devCfg) {
        BluetoohHeadsetCheckInterface intf = new BluetoohHeadsetCheck();
        if (!intf.init(context, devCfg)) {
            intf = new BluetoohHeadsetCheckFake();
        }
        QLog.w(TAG, "CreateBluetoothCheck:" + intf.interfaceDesc());
        return intf;
    }

    static String getForceConfigName(int config) {
        if (config >= 0 && config < forceName.length) {
            return forceName[config];
        }
        return "unknow";
    }

    public static Object invokeMethod(Object owner, String methodName, Object[] args, Class[] argsClass) {
        Object res = null;
        try {
            Class<?> ownerClass = owner.getClass();
            Method method = ownerClass.getMethod(methodName, argsClass);
            res = method.invoke(owner, args);
        }
        catch (Exception e) {
            QLog.w(TAG, "invokeMethod Exception:" + e.getMessage());
        }
        return res;
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args, Class[] argsClass) {
        Object res = null;
        try {
            Class<?> ownerClass = Class.forName(className);
            Method method = ownerClass.getMethod(methodName, argsClass);
            res = method.invoke(null, args);
        }
        catch (ClassNotFoundException e) {
            QLog.w(TAG, "ClassNotFound:" + className);
        }
        catch (NoSuchMethodException e) {
            QLog.w(TAG, "NoSuchMethod:" + methodName);
        }
        catch (IllegalArgumentException e) {
            QLog.w(TAG, "IllegalArgument:" + methodName);
        }
        catch (IllegalAccessException e) {
            QLog.w(TAG, "IllegalAccess:" + methodName);
        }
        catch (InvocationTargetException e) {
            QLog.w(TAG, "InvocationTarget:" + methodName);
        }
        catch (Exception e) {
            QLog.w(TAG, "invokeStaticMethod Exception:" + e.getMessage());
        }
        return res;
    }

    static void setParameters(String keyValuePairs) {
        Object[] args = new Object[]{keyValuePairs};
        Class[] argsClass = new Class[args.length];
        argsClass[0] = String.class;
        QLog.w(TAG, "setParameters  :" + keyValuePairs);
        TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setParameters", args, argsClass);
    }

    static void setPhoneState(int state) {
        Object[] args = new Object[]{state};
        Class[] argsClass = new Class[args.length];
        argsClass[0] = Integer.TYPE;
        TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setPhoneState", args, argsClass);
    }

    static void setForceUse(int usage, int config) {
        Object[] args = new Object[]{usage, config};
        Class[] argsClass = new Class[args.length];
        argsClass[0] = Integer.TYPE;
        argsClass[1] = Integer.TYPE;
        Object res = TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setForceUse", args, argsClass);
        QLog.w(TAG, "setForceUse  usage:" + usage + " config:" + config + " ->" + TraeAudioManager.getForceConfigName(config) + " res:" + res);
    }

    static int getForceUse(int usage) {
        Integer config = 0;
        Object[] args = new Object[]{usage};
        Class[] argsClass = new Class[args.length];
        argsClass[0] = Integer.TYPE;
        Object value = TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "getForceUse", args, argsClass);
        if (value != null) {
            config = (Integer)value;
        }
        QLog.w(TAG, "getForceUse  usage:" + usage + " config:" + config + " ->" + TraeAudioManager.getForceConfigName(config));
        return config;
    }

    static void forceVolumeControlStream(AudioManager am, int streamType) {
        if (ClientInfo.MANUFACTURER.equals("Google")) {
            QLog.w(TAG, "forceVolumeControlStream, Google phone nothing to do");
            return;
        }
        Object[] args = new Object[]{streamType};
        Class[] argsClass = new Class[args.length];
        argsClass[0] = Integer.TYPE;
        Object res = TraeAudioManager.invokeMethod(am, "forceVolumeControlStream", args, argsClass);
        QLog.w(TAG, "forceVolumeControlStream  streamType:" + streamType + " res:" + res);
    }

    @TargetApi(value=11)
    class BluetoohHeadsetCheck
    extends BluetoohHeadsetCheckInterface
    implements BluetoothProfile.ServiceListener {
        Context _ctx;
        DeviceConfigManager _devCfg;
        BluetoothAdapter _adapter;
        BluetoothProfile _profile;
        private final ReentrantLock _profileLock;
        private boolean mBTVisible;
        private boolean mTimerRunning;
        private final long TIMER_INTERVAL = 2000L;
        private final Handler sHandler;
        private final Runnable mRunnable;

        BluetoohHeadsetCheck() {
            this._ctx = null;
            this._devCfg = null;
            this._adapter = null;
            this._profile = null;
            this._profileLock = new ReentrantLock();
            this.mBTVisible = false;
            this.mTimerRunning = false;
            this.TIMER_INTERVAL = 2000L;
            this.sHandler = new Handler(Looper.getMainLooper());
            this.mRunnable = new Runnable(){

                @Override
                public void run() {
                    if (BluetoohHeadsetCheck.this.mTimerRunning) {
                        boolean visible = false;
                        if (TraeAudioManager.this._am != null) {
                            visible = TraeAudioManager.this._am.isBluetoothA2dpOn();
                        }
                        if (visible != BluetoohHeadsetCheck.this.mBTVisible) {
                            BluetoohHeadsetCheck.this.mBTVisible = visible;
                            BluetoohHeadsetCheck.this.setBluetoothVisible(BluetoohHeadsetCheck.this.mBTVisible);
                        }
                        BluetoohHeadsetCheck.this.sHandler.postDelayed(BluetoohHeadsetCheck.this.mRunnable, 2000L);
                    }
                }
            };
        }

        @Override
        @TargetApi(value=11)
        public boolean init(Context ctx, DeviceConfigManager devCfg) {
            AudioDeviceInterface.LogTraceEntry("");
            if (ctx == null || devCfg == null) {
                QLog.e(TraeAudioManager.TAG, " err ctx==null||_devCfg==null");
                return false;
            }
            this._ctx = ctx;
            this._devCfg = devCfg;
            boolean ret = this.getProfile();
            AudioDeviceInterface.LogTraceExit();
            return ret;
        }

        @Override
        boolean getProfile() {
            boolean ret = false;
            this._profileLock.lock();
            if (this._profile != null) {
                ret = true;
            } else {
                this._adapter = BluetoothAdapter.getDefaultAdapter();
                if (this._adapter == null) {
                    QLog.e(TraeAudioManager.TAG, "getDefaultAdapter fail!");
                } else if (!this._adapter.isEnabled()) {
                    QLog.e(TraeAudioManager.TAG, " BluetoothAdapter is not enable!");
                    ret = true;
                } else if (this._profile == null && !this._adapter.getProfileProxy(this._ctx, (BluetoothProfile.ServiceListener)this, 1)) {
                    QLog.e(TraeAudioManager.TAG, "getProfileProxy HEADSET fail!");
                } else {
                    ret = true;
                }
            }
            this._profileLock.unlock();
            return ret;
        }

        @Override
        public void release() {
            this._profileLock.lock();
            AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile);
            try {
                if (this._adapter != null) {
                    if (this._profile != null) {
                        this._adapter.closeProfileProxy(1, this._profile);
                    }
                    this._profile = null;
                }
            }
            catch (Exception e) {
                QLog.w(TraeAudioManager.TAG, " closeProfileProxy:e:" + e.getMessage());
            }
            finally {
                this._profileLock.unlock();
            }
            this.stopBluetoothTimer();
            AudioDeviceInterface.LogTraceExit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isConnected() {
            boolean bc = false;
            boolean err = false;
            this._profileLock.lock();
            try {
                if (this._profile != null) {
                    List devs = this._profile.getConnectedDevices();
                    if (devs == null) {
                        boolean bl = false;
                        return bl;
                    }
                    bc = devs.size() > 0;
                } else {
                    err = true;
                }
            }
            catch (Exception e) {
                err = true;
            }
            finally {
                this._profileLock.unlock();
            }
            if (err && TraeAudioManager.this._am != null) {
                return TraeAudioManager.this._am.isBluetoothA2dpOn();
            }
            return bc;
        }

        @TargetApi(value=11)
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile == 1) {
                this._profileLock.lock();
                AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile + " profile:" + profile + " proxy:" + proxy);
                if (this._profile != null && this._profile != proxy) {
                    QLog.w(TraeAudioManager.TAG, "BluetoohHeadsetCheck: HEADSET Connected proxy:" + proxy + " _profile:" + this._profile);
                    this._adapter.closeProfileProxy(1, this._profile);
                    this._profile = null;
                }
                this._profile = proxy;
                this._profileLock.unlock();
                if (this._devCfg != null) {
                    if (this.isConnected()) {
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                        TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                    } else {
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                    }
                }
                AudioDeviceInterface.LogTraceExit();
            }
        }

        @TargetApi(value=11)
        public void onServiceDisconnected(int profile) {
            if (profile == 1) {
                QLog.w(TraeAudioManager.TAG, "TRAEBluetoohProxy: HEADSET Disconnected");
                if (this.isConnected()) {
                    TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
                this._profileLock.lock();
                AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile + " profile:" + profile);
                try {
                    if (this._profile != null) {
                        this._adapter.closeProfileProxy(1, this._profile);
                        this._profile = null;
                    }
                }
                finally {
                    this._profileLock.unlock();
                }
                AudioDeviceInterface.LogTraceExit();
            }
        }

        @Override
        void _addAction(IntentFilter filter) {
            QLog.w(TraeAudioManager.TAG, " " + this.interfaceDesc() + " _addAction");
            filter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
            filter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            filter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
            filter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
            if (ClientInfo.VERSION_SDK_INT > 31) {
                String permission2 = "android.permission.BLUETOOTH_CONNECT";
                if (TraeAudioManager.this._context != null && TraeAudioManager.this._context.checkSelfPermission(permission2) != 0) {
                    this.startBluetoothTimer();
                }
            }
        }

        @Override
        @SuppressLint(value={"DefaultLocale"})
        void _onReceive(Context context, Intent intent) {
            QLog.i(TraeAudioManager.TAG, this.interfaceDesc() + " _onReceive action=" + intent.getAction());
            if ("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED".equals(intent.getAction())) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                int pre_state = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -1);
                BluetoothDevice dev = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                QLog.i(TraeAudioManager.TAG, this.interfaceDesc() + String.format(" _onReceive|state=%s, pre_state=%s, dev=%s", this.getBTHeadsetAudioState(state), this.getBTHeadsetAudioState(pre_state), this.getBluetoothDeviceName(dev)));
                if (state == 12) {
                    if (bluetoothState == 6) {
                        QLog.w(TraeAudioManager.TAG, this.interfaceDesc() + " _onReceive|SCO is connected");
                        bluetoothState = 7;
                    }
                } else if (state == 10 && bluetoothState == 5) {
                    bluetoothState = 4;
                    QLog.i(TraeAudioManager.TAG, "BluetoothObserver onReceive|SCO is disconnected");
                }
            } else if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(intent.getAction())) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                int pre_state = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -1);
                BluetoothDevice dev = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                QLog.i(TraeAudioManager.TAG, this.interfaceDesc() + String.format(" _onReceive|state=%s, pre_state=%s, dev=%s", this.getBTHeadsetConnectionState(state), this.getBTHeadsetConnectionState(pre_state), this.getBluetoothDeviceName(dev)));
                switch (state) {
                    case 0: {
                        bluetoothState = 3;
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                        break;
                    }
                    case 2: {
                        if (bluetoothState == 3) {
                            bluetoothState = 4;
                        }
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                    }
                }
            } else if ("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED".equals(intent.getAction())) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.CONNECTION_STATE", -1);
                int pre_state = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE", -1);
                BluetoothDevice dev = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                QLog.i(TraeAudioManager.TAG, this.interfaceDesc() + String.format(" _onReceive|state=%s, pre_state=%s, dev=%s", this.getBTAdapterConnectionState(state), this.getBTAdapterConnectionState(pre_state), this.getBluetoothDeviceName(dev)));
                if (state == 2) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                    this._devCfg.setBluetoothName(this.getBluetoothDeviceName(dev));
                } else if (state == 0) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
            } else if ("android.media.ACTION_SCO_AUDIO_STATE_UPDATED".equals(intent.getAction())) {
                int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                int pre_state = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -1);
                QLog.i(TraeAudioManager.TAG, this.interfaceDesc() + String.format(" _onReceive|state=%s, pre_state=%s", this.getSCOAudioState(state), this.getSCOAudioState(pre_state)));
                if (state == 1) {
                    if (bluetoothState == 6) {
                        QLog.i(TraeAudioManager.TAG, "BluetoothObserver onReceive|SCO is connected");
                        bluetoothState = 7;
                    }
                } else if (state == 0 && bluetoothState == 5) {
                    bluetoothState = 4;
                    QLog.i(TraeAudioManager.TAG, "BluetoothObserver onReceive|SCO is disconnected");
                }
            }
        }

        @Override
        public String interfaceDesc() {
            return "BluetoohHeadsetCheck";
        }

        private void startBluetoothTimer() {
            if (!this.mTimerRunning) {
                this.mTimerRunning = true;
                this.sHandler.postDelayed(this.mRunnable, 2000L);
                QLog.i("BluetoothObserver", "startBluetoothTimer");
            }
        }

        private void stopBluetoothTimer() {
            if (this.mTimerRunning) {
                QLog.i("BluetoothObserver", "stopBluetoothTimer");
                this.mTimerRunning = false;
            }
        }

        private void setBluetoothVisible(boolean visible) {
            if (visible) {
                if (bluetoothState == 3) {
                    bluetoothState = 4;
                }
            } else {
                bluetoothState = 3;
            }
            if (TraeAudioManager.this._deviceConfigManager.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, visible)) {
                QLog.i("BluetoothObserver", "device " + (visible ? "connect" : "disconnect"));
                TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_WIREDHEADSET, visible);
            }
        }
    }

    class BluetoohHeadsetCheckFake
    extends BluetoohHeadsetCheckInterface {
        BluetoohHeadsetCheckFake() {
        }

        @Override
        public boolean init(Context ctx, DeviceConfigManager devCfg) {
            return true;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        void _addAction(IntentFilter filter) {
        }

        @Override
        void _onReceive(Context context, Intent intent) {
        }

        @Override
        public String interfaceDesc() {
            return "BluetoohHeadsetCheckFake";
        }
    }

    abstract class BluetoohHeadsetCheckInterface {
        BluetoohHeadsetCheckInterface() {
        }

        public abstract String interfaceDesc();

        public abstract boolean init(Context var1, DeviceConfigManager var2);

        public abstract void release();

        public abstract boolean isConnected();

        public void addAction(IntentFilter filter) {
            filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
            filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
            this._addAction(filter);
        }

        abstract void _addAction(IntentFilter var1);

        abstract void _onReceive(Context var1, Intent var2);

        public void onReceive(Context context, Intent intent, DeviceConfigManager devCfg) {
            QLog.w(TraeAudioManager.TAG, this.interfaceDesc() + " onReceive|" + intent.getAction());
            if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction())) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                int pre_state = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -1);
                QLog.i(TraeAudioManager.TAG, String.format("bluetooth onReceive|state=%d, pre_state=%d", state, pre_state));
                if (state == 10) {
                    QLog.w(TraeAudioManager.TAG, "    BT off");
                    devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                } else if (state == 12) {
                    this.getProfile();
                }
            } else if (!("android.bluetooth.device.action.ACL_CONNECTED".equals(intent.getAction()) && ClientInfo.VERSION_SDK_INT < 11 || "android.bluetooth.device.action.ACL_DISCONNECTED".equals(intent.getAction()) && ClientInfo.VERSION_SDK_INT < 11)) {
                this._onReceive(context, intent);
            }
        }

        String getBTActionStateChangedExtraString(int state) {
            String valuestr;
            switch (state) {
                case 10: {
                    valuestr = "OFF";
                    break;
                }
                case 11: {
                    valuestr = "TURNING_ON";
                    break;
                }
                case 12: {
                    valuestr = "ON";
                    break;
                }
                case 13: {
                    valuestr = "TURNING_OFF";
                    break;
                }
                default: {
                    valuestr = "unknow";
                }
            }
            return valuestr + ":" + state;
        }

        String getSCOAudioState(int state) {
            String valuestr;
            switch (state) {
                case 0: {
                    valuestr = "DISCONNECTED";
                    break;
                }
                case 1: {
                    valuestr = "CONNECTED";
                    break;
                }
                case 2: {
                    valuestr = "CONNECTING";
                    break;
                }
                case -1: {
                    valuestr = "ERROR";
                    break;
                }
                default: {
                    valuestr = "unknow";
                }
            }
            return valuestr + ":" + state;
        }

        String getBTAdapterConnectionState(int state) {
            String valuestr;
            switch (state) {
                case 0: {
                    valuestr = "DISCONNECTED";
                    break;
                }
                case 1: {
                    valuestr = "CONNECTING";
                    break;
                }
                case 2: {
                    valuestr = "CONNECTED";
                    break;
                }
                case 3: {
                    valuestr = "DISCONNECTING";
                    break;
                }
                default: {
                    valuestr = "unknow";
                }
            }
            return valuestr + ":" + state;
        }

        boolean getProfile() {
            return true;
        }

        String getBTHeadsetConnectionState(int state) {
            String valuestr;
            switch (state) {
                case 0: {
                    valuestr = "DISCONNECTED";
                    break;
                }
                case 1: {
                    valuestr = "CONNECTING";
                    break;
                }
                case 2: {
                    valuestr = "CONNECTED";
                    break;
                }
                case 3: {
                    valuestr = "DISCONNECTING";
                    break;
                }
                default: {
                    valuestr = "unknow";
                }
            }
            return valuestr + ":" + state;
        }

        String getBTHeadsetAudioState(int state) {
            String valuestr;
            switch (state) {
                case 12: {
                    valuestr = "CONNECTED";
                    break;
                }
                case 11: {
                    valuestr = "CONNECTING";
                    break;
                }
                case 10: {
                    valuestr = "DISCONNECTED";
                    break;
                }
                default: {
                    valuestr = "unknow:" + state;
                }
            }
            return valuestr + ":" + state;
        }

        String getBluetoothDeviceName(BluetoothDevice dev) {
            try {
                return dev != null ? dev.getName() : " ";
            }
            catch (Exception e) {
                QLog.e(TraeAudioManager.TAG, "BluetoothDevice getName fail.", e);
                return " ";
            }
        }
    }

    class bluetoothHeadsetSwitchThread
    extends switchThread {
        bluetoothHeadsetSwitchThread() {
        }

        @Override
        public void _run() {
            if (IsMusicScene || !IsUpdateSceneFlag || nSceneMode == 7) {
                QLog.w(TraeAudioManager.TAG, "bluetoothHeadsetSwitchThread: do nothing, IsMusicScene:" + IsMusicScene + " ,IsUpdateSceneFlag:" + IsUpdateSceneFlag);
                this.updateStatus();
                return;
            }
            try {
                QLog.w(TraeAudioManager.TAG, "bluetoothHeadsetSwitchThread sleep 1000");
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (bluetoothState == 7) {
                QLog.w(TraeAudioManager.TAG, "WIREDHEADSET plugout, bluetoothState == Bluetooth_State.SCO_CONNECTED force to HEADSET_AVAILABLE, reconnect");
                bluetoothState = 4;
            }
            int retryCount = 0;
            while (bluetoothState != 4 && retryCount++ < 10) {
                QLog.w(TraeAudioManager.TAG, "bluetoothHeadsetSwitchThread waiting Bluetooth_State HEADSET_AVAILABLE, " + bluetoothState);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            boolean skipBT = false;
            boolean isBluetoothNeedStop = false;
            if (bluetoothState != 4) {
                skipBT = true;
            }
            if (!skipBT && this._running) {
                bluetoothState = 6;
                this._startBluetoothSco();
                isBluetoothNeedStop = true;
                QLog.w(TraeAudioManager.TAG, "bluetoothHeadsetSwitchThread _startBluetoothSco");
            }
            int i = 0;
            while (this._running && i++ < 10 && !skipBT) {
                QLog.w(TraeAudioManager.TAG, "bluetoothHeadsetSwitchThread i:" + i + " sco:" + (TraeAudioManager.this._am.isBluetoothScoOn() ? "Y" : "N") + " :" + TraeAudioManager.this._deviceConfigManager.getBluetoothName());
                if (bluetoothState == 7) {
                    QLog.w(TraeAudioManager.TAG, "bluetoothHeadsetSwitchThread bluetoothState ==  Bluetooth_State.SCO_CONNECTED 1");
                    this.updateStatus();
                    break;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (bluetoothState == 7) {
                    QLog.w(TraeAudioManager.TAG, "bluetoothHeadsetSwitchThread bluetoothState ==  Bluetooth_State.SCO_CONNECTED 2");
                    this.updateStatus();
                    break;
                }
                if (!isBluetoothNeedStop || !this._running) continue;
                this._stopBluetoothSco();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this._startBluetoothSco();
                QLog.w(TraeAudioManager.TAG, "bluetoothHeadsetSwitchThread retry start sco");
            }
            if (bluetoothState != 7) {
                if (this._running && !skipBT) {
                    QLog.e(TraeAudioManager.TAG, "bluetoothHeadsetSwitchThread sco fail,remove btheadset");
                    TraeAudioManager.this._deviceConfigManager.setVisible(this.getDeviceName(), false);
                }
                this.processDeviceConnectRes(10);
                TraeAudioManager.this.checkAutoDeviceListUpdate();
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_BLUETOOTHHEADSET;
        }

        @Override
        @TargetApi(value=8)
        public void _quit() {
            if (bluetoothState == 6) {
                bluetoothState = 4;
            }
            if (TraeAudioManager.this._am == null) {
                return;
            }
            if (bluetoothState == 7) {
                bluetoothState = 5;
                needStopBluetoothSco = true;
            }
            this._stopBluetoothSco();
        }

        @TargetApi(value=8)
        void _startBluetoothSco() {
            try {
                TraeAudioManager.this._am.setBluetoothScoOn(true);
                if (ClientInfo.VERSION_SDK_INT > 8) {
                    TraeAudioManager.this._am.startBluetoothSco();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @TargetApi(value=8)
        void _stopBluetoothSco() {
            if (ClientInfo.VERSION_SDK_INT > 8) {
                TraeAudioManager.this._am.stopBluetoothSco();
            }
        }
    }

    class headsetSwitchThread
    extends switchThread {
        headsetSwitchThread() {
        }

        @Override
        public void _run() {
            int i = 0;
            if (!IsMusicScene && IsUpdateSceneFlag) {
                TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, false);
                TraeAudioManager.this._am.setWiredHeadsetOn(true);
            }
            this.updateStatus();
            if (IsMusicScene || !IsUpdateSceneFlag) {
                QLog.w(TraeAudioManager.TAG, "connect headset: do nothing");
                return;
            }
            while (this._running) {
                try {
                    if (TraeAudioManager.this._am.isSpeakerphoneOn()) {
                        TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(i < 5 ? 1000L : 4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_WIREDHEADSET;
        }

        @Override
        public void _quit() {
        }
    }

    class speakerSwitchThread
    extends switchThread {
        speakerSwitchThread() {
        }

        @Override
        public void _run() {
            int i = 0;
            if (!IsMusicScene && IsUpdateSceneFlag) {
                TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, TraeAudioManager.this._speakerOn);
            }
            this.updateStatus();
            if (IsMusicScene || !IsUpdateSceneFlag) {
                QLog.w(TraeAudioManager.TAG, "connect speakerPhone: do nothing");
                return;
            }
            QLog.w(TraeAudioManager.TAG, " _run:" + this.getDeviceName() + " _running:" + this._running);
            while (this._running) {
                try {
                    if (TraeAudioManager.this._am.isSpeakerphoneOn() != TraeAudioManager.this._speakerOn) {
                        TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, TraeAudioManager.this._speakerOn);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(i < 5 ? 1000L : 4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        @Override
        public void _quit() {
        }
    }

    class earphoneSwitchThread
    extends switchThread {
        earphoneSwitchThread() {
        }

        @Override
        public void _run() {
            int i = 0;
            if (IsUpdateSceneFlag) {
                TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, TraeAudioManager.this._speakerOn);
            }
            this.updateStatus();
            if (!IsUpdateSceneFlag) {
                QLog.w(TraeAudioManager.TAG, "connect earphone: do nothing");
                return;
            }
            while (this._running) {
                if (TraeAudioManager.this._am.isSpeakerphoneOn() != TraeAudioManager.this._speakerOn) {
                    TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, TraeAudioManager.this._speakerOn);
                }
                try {
                    Thread.sleep(i < 5 ? 1000L : 4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_EARPHONE;
        }

        @Override
        public void _quit() {
        }
    }

    abstract class switchThread
    extends Thread {
        boolean _running = true;
        boolean[] _exited = new boolean[]{false};
        HashMap<String, Object> _params = null;
        long _usingtime = 0L;

        switchThread() {
            QLog.w(TraeAudioManager.TAG, " ++switchThread:" + this.getDeviceName());
        }

        public void setDeviceConnectParam(HashMap<String, Object> params) {
            this._params = params;
        }

        void updateStatus() {
            TraeAudioManager.this._deviceConfigManager.setConnected(this.getDeviceName());
            this.processDeviceConnectRes(0);
        }

        void processDeviceConnectRes(int err) {
            TraeAudioManager.this._deviceConfigManager.setConnected(this.getDeviceName());
            TraeAudioManager.this.InternalNotifyDeviceChangableUpdate();
            AudioDeviceInterface.LogTraceEntry(this.getDeviceName() + " err:" + err);
            if (this._params == null) {
                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                return;
            }
            TraeAudioManager.this.sessionConnectedDev = TraeAudioManager.this._deviceConfigManager.getConnectedDevice();
            Long sid = (Long)this._params.get(TraeAudioManager.PARAM_SESSIONID);
            QLog.w(TraeAudioManager.TAG, " sessonID:" + sid);
            if (sid == null || sid == Long.MIN_VALUE) {
                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                QLog.w(TraeAudioManager.TAG, "processDeviceConnectRes sid null,don't send res");
                return;
            }
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.CONNECTDEVICE_RESULT_DEVICENAME, (String)this._params.get(TraeAudioManager.PARAM_DEVICE));
            if (TraeAudioManager.this.sendResBroadcast(intent, this._params, err) == 0) {
                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
            }
            AudioDeviceInterface.LogTraceExit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AudioDeviceInterface.LogTraceEntry(this.getDeviceName());
            TraeAudioManager.this.InternalNotifyDeviceChangableUpdate();
            this._run();
            boolean[] blArray = this._exited;
            synchronized (this._exited) {
                this._exited[0] = true;
                this._exited.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            AudioDeviceInterface.LogTraceEntry(this.getDeviceName());
            this._running = false;
            QLog.w(TraeAudioManager.TAG, " quit:" + this.getDeviceName() + " _running:" + this._running);
            this.interrupt();
            boolean[] blArray = this._exited;
            synchronized (this._exited) {
                if (!this._exited[0]) {
                    try {
                        this._exited.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this._quit();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        public abstract String getDeviceName();

        public abstract void _run();

        public abstract void _quit();
    }

    class TraeAudioManagerLooper
    extends Thread {
        public static final int MESSAGE_BEGIN = 32768;
        public static final int MESSAGE_ENABLE = 32772;
        public static final int MESSAGE_DISABLE = 32773;
        public static final int MESSAGE_GETDEVICELIST = 32774;
        public static final int MESSAGE_CONNECTDEVICE = 32775;
        public static final int MESSAGE_EARACTION = 32776;
        public static final int MESSAGE_ISDEVICECHANGABLED = 32777;
        public static final int MESSAGE_GETCONNECTEDDEVICE = 32778;
        public static final int MESSAGE_GETCONNECTINGDEVICE = 32779;
        public static final int MESSAGE_VOICECALLPREPROCESS = 32780;
        public static final int MESSAGE_VOICECALLPOSTPROCESS = 32781;
        public static final int MESSAGE_STARTRING = 32782;
        public static final int MESSAGE_STOPRING = 32783;
        public static final int MESSAGE_GETSTREAMTYPE = 32784;
        public static final int MESSAGE_AUTO_DEVICELIST_UPDATE = 32785;
        public static final int MESSAGE_AUTO_DEVICELIST_PLUGIN_UPDATE = 32786;
        public static final int MESSAGE_AUTO_DEVICELIST_PLUGOUT_UPDATE = 32787;
        public static final int MESSAGE_VOICECALL_AUIDOPARAM_CHANGED = 32788;
        public static final int MESSAGE_CONNECT_HIGHEST_PRIORITY_DEVICE = 32789;
        public static final int MESSAGE_REQUEST_RELEASE_AUDIO_FOCUS = 32790;
        public static final int MESSAGE_RECOVER_AUDIO_FOCUS = 32791;
        public static final int MESSAGE_FORCE_CONNECTDEVICE = 32792;
        Handler mMsgHandler = null;
        TraeMediaPlayer _ringPlayer = null;
        long _ringSessionID = -1L;
        String _ringOperation = "";
        String _ringUserdata = "";
        final boolean[] _started = new boolean[]{false};
        boolean _enabled = false;
        TraeAudioManager _parent = null;
        String _lastCfg = "";
        int _preServiceMode = 0;
        int _preRingMode = 0;
        boolean IsFirstConnectDeviceFlag = true;
        long _voiceCallSessionID = -1L;
        String _voiceCallOperation = "";
        AudioManager.OnAudioFocusChangeListener mAudioFocusChangeListener = null;
        int _focusSteamType = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TraeAudioManagerLooper(TraeAudioManager parent) {
            this._parent = parent;
            long lasttime = SystemClock.elapsedRealtime();
            QLog.e(TraeAudioManager.TAG, "TraeAudioManagerLooper start...");
            this.start();
            boolean[] blArray = this._started;
            synchronized (this._started) {
                if (!this._started[0]) {
                    try {
                        this._started.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                QLog.e(TraeAudioManager.TAG, "  start used:" + (SystemClock.elapsedRealtime() - lasttime) + "ms");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            AudioDeviceInterface.LogTraceEntry("");
            if (null == this.mMsgHandler) {
                return;
            }
            long lasttime = SystemClock.elapsedRealtime();
            this.mMsgHandler.getLooper().quit();
            boolean[] blArray = this._started;
            synchronized (this._started) {
                if (this._started[0]) {
                    try {
                        this._started.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                QLog.e(TraeAudioManager.TAG, "  quit used:" + (SystemClock.elapsedRealtime() - lasttime) + "ms");
                this.mMsgHandler = null;
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        public int sendMessage(int nMsg, HashMap<String, Object> params) {
            if (null == this.mMsgHandler) {
                AudioDeviceInterface.LogTraceEntry(" fail mMsgHandler==null _enabled:" + (this._enabled ? "Y" : "N") + " activeMode:" + TraeAudioManager.this._activeMode + " msg:" + nMsg);
                return -1;
            }
            Message msg = Message.obtain((Handler)this.mMsgHandler, (int)nMsg, params);
            return this.mMsgHandler.sendMessage(msg) ? 0 : -1;
        }

        void startService(HashMap<String, Object> params) {
            String strCfg = (String)params.get(TraeAudioManager.EXTRA_DATA_DEVICECONFIG);
            Log.w((String)TraeAudioManager.TAG, (String)("startService cfg:" + strCfg));
            AudioDeviceInterface.LogTraceEntry(" _enabled:" + (this._enabled ? "Y" : "N") + " activeMode:" + TraeAudioManager.this._activeMode + " cfg:" + strCfg);
            if (TraeAudioManager.this._context == null) {
                return;
            }
            if (strCfg.equals("resume service")) {
                strCfg = this._lastCfg;
            }
            QLog.w(TraeAudioManager.TAG, "   startService:" + strCfg);
            if (this._enabled && this._lastCfg.equals(strCfg) || TraeAudioManager.this._activeMode != 0) {
                return;
            }
            if (this._enabled) {
                this.stopService();
            }
            this._prev_startService();
            AudioManager am = (AudioManager)TraeAudioManager.this._context.getSystemService("audio");
            TraeAudioManager.this._deviceConfigManager.clearConfig();
            TraeAudioManager.this._deviceConfigManager.init(strCfg);
            this._lastCfg = strCfg;
            if (TraeAudioManager.this._am != null) {
                this._preServiceMode = TraeAudioManager.this._am.getMode();
            }
            this._enabled = true;
            if (this._ringPlayer == null) {
                this._ringPlayer = new TraeMediaPlayer(TraeAudioManager.this._context, new TraeMediaPlayer.OnCompletionListener(){

                    @Override
                    public void onCompletion() {
                        QLog.w(TraeAudioManager.TAG, "_ringPlayer onCompletion _activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + TraeAudioManagerLooper.this._preRingMode);
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put(TraeAudioManager.PARAM_ISHOSTSIDE, true);
                        TraeAudioManagerLooper.this.sendMessage(32783, params);
                        TraeAudioManagerLooper.this.notifyRingCompletion();
                    }
                });
            }
            this.notifyServiceState(this._enabled);
            TraeAudioManager.this.updateDeviceStatus();
            AudioDeviceInterface.LogTraceExit();
        }

        boolean isNeedForceVolumeType() {
            if (ClientInfo.MANUFACTURER.equals("Xiaomi")) {
                if (ClientInfo.MODEL.equals("MI 5")) {
                    return true;
                }
                if (ClientInfo.MODEL.equals("MI 5s")) {
                    return true;
                }
                if (ClientInfo.MODEL.equals("MI 5s Plus")) {
                    return true;
                }
            }
            return false;
        }

        void stopService() {
            AudioDeviceInterface.LogTraceEntry(" _enabled:" + (this._enabled ? "Y" : "N") + " activeMode:" + TraeAudioManager.this._activeMode);
            if (!this._enabled) {
                return;
            }
            if (TraeAudioManager.this._activeMode == 1) {
                this.interruptVoicecallPostprocess();
            } else if (TraeAudioManager.this._activeMode == 2) {
                this.interruptRing();
            }
            if (TraeAudioManager.this._switchThread != null) {
                QLog.w(TraeAudioManager.TAG, "_switchThread:" + TraeAudioManager.this._switchThread.getDeviceName());
                TraeAudioManager.this._switchThread.quit();
                TraeAudioManager.this._switchThread = null;
            }
            if (this._ringPlayer != null) {
                this._ringPlayer.stopRing();
            }
            this._ringPlayer = null;
            this._enabled = false;
            this.notifyServiceState(this._enabled);
            if (TraeAudioManager.this._am != null && TraeAudioManager.this._context != null) {
                try {
                    TraeAudioManager.this.InternalSetMode(0);
                    QLog.w(TraeAudioManager.TAG, "forceVolumeControlStream: -1");
                    TraeAudioManager.forceVolumeControlStream(TraeAudioManager.this._am, -1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._post_stopService();
            AudioDeviceInterface.LogTraceExit();
        }

        int notifyServiceState(boolean on) {
            if (null == TraeAudioManager.this._context) {
                return -1;
            }
            Intent intent = new Intent();
            intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
            intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_SERVICE_STATE);
            intent.putExtra(TraeAudioManager.NOTIFY_SERVICE_STATE_DATE, on);
            if (TraeAudioManager.this._context != null) {
                intent.setPackage(TraeAudioManager.this._context.getPackageName());
            }
            TraeAudioManager.this._context.sendBroadcast(intent);
            return 0;
        }

        String msgToText(int what) {
            String result = "MESSAGE_NONE";
            switch (what) {
                case 32768: {
                    result = "MESSAGE_BEGIN";
                    break;
                }
                case 32769: {
                    result = "MESSAGE_SETWIREDHEADSET";
                    break;
                }
                case 32770: {
                    result = "MESSAGE_SETBLUETOOTHHEADSET";
                    break;
                }
                case 32771: {
                    result = "MESSAGE_SETDEVICECONFIG";
                    break;
                }
                case 32772: {
                    result = "MESSAGE_ENABLE";
                    break;
                }
                case 32773: {
                    result = "MESSAGE_DISABLE";
                    break;
                }
                case 32774: {
                    result = "MESSAGE_GETDEVICELIST";
                    break;
                }
                case 32775: {
                    result = "MESSAGE_CONNECTDEVICE";
                    break;
                }
                case 32776: {
                    result = "MESSAGE_EARACTION";
                    break;
                }
                case 32777: {
                    result = "MESSAGE_ISDEVICECHANGABLED";
                    break;
                }
                case 32778: {
                    result = "MESSAGE_GETCONNECTEDDEVICE";
                    break;
                }
                case 32779: {
                    result = "MESSAGE_GETCONNECTINGDEVICE";
                    break;
                }
                case 32780: {
                    result = "MESSAGE_VOICECALLPREPROCESS";
                    break;
                }
                case 32781: {
                    result = "MESSAGE_VOICECALLPOSTPROCESS";
                    break;
                }
                case 32782: {
                    result = "MESSAGE_STARTRING";
                    break;
                }
                case 32783: {
                    result = "MESSAGE_STOPRING";
                    break;
                }
                case 32784: {
                    result = "MESSAGE_GETSTREAMTYPE";
                    break;
                }
                case 32785: {
                    result = "MESSAGE_AUTO_DEVICELIST_UPDATE";
                    break;
                }
                case 32786: {
                    result = "MESSAGE_AUTO_DEVICELIST_PLUGIN_UPDATE";
                    break;
                }
                case 32787: {
                    result = "MESSAGE_AUTO_DEVICELIST_PLUGOUT_UPDATE";
                    break;
                }
                case 32788: {
                    result = "MESSAGE_VOICECALL_AUIDOPARAM_CHANGED";
                    break;
                }
                case 32789: {
                    result = "MESSAGE_CONNECT_HIGHEST_PRIORITY_DEVICE";
                    break;
                }
                case 32790: {
                    result = "MESSAGE_REQUEST_RELEASE_AUDIO_FOCUS";
                    break;
                }
                case 32791: {
                    result = "MESSAGE_RECOVER_AUDIO_FOCUS";
                    break;
                }
                case 32792: {
                    result = "MESSAGE_FORCE_CONNECTDEVICE";
                    break;
                }
                default: {
                    result = "MESSAGE_NONE";
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AudioDeviceInterface.LogTraceEntry("");
            Looper.prepare();
            this.mMsgHandler = new Handler(){

                public void handleMessage(Message msg) {
                    String highestDev = null;
                    String connectedDev = null;
                    String plugDev = null;
                    HashMap params = null;
                    try {
                        params = (HashMap)msg.obj;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    QLog.w(TraeAudioManager.TAG, "TraeAudioManagerLooper msg:" + msg.what + ":" + TraeAudioManagerLooper.this.msgToText(msg.what) + " _enabled:" + (TraeAudioManagerLooper.this._enabled ? "Y" : "N"));
                    if (msg.what == 32772) {
                        TraeAudioManagerLooper.this.startService(params);
                    } else if (!TraeAudioManagerLooper.this._enabled) {
                        QLog.w(TraeAudioManager.TAG, "******* disabled ,skip msg******");
                        Intent intent = new Intent();
                        TraeAudioManager.this.sendResBroadcast(intent, params, 1);
                    } else {
                        switch (msg.what) {
                            case 32773: {
                                TraeAudioManagerLooper.this.stopService();
                                break;
                            }
                            case 32774: {
                                TraeAudioManagerLooper.this.InternalSessionGetDeviceList(params);
                                break;
                            }
                            case 32777: {
                                TraeAudioManager.this.InternalSessionIsDeviceChangabled(params);
                                break;
                            }
                            case 32778: {
                                TraeAudioManager.this.InternalSessionGetConnectedDevice(params);
                                break;
                            }
                            case 32779: {
                                TraeAudioManager.this.InternalSessionGetConnectingDevice(params);
                                break;
                            }
                            case 32780: {
                                TraeAudioManagerLooper.this.InternalVoicecallPreprocess(params);
                                break;
                            }
                            case 32781: {
                                TraeAudioManagerLooper.this.InternalVoicecallPostprocess(params);
                                break;
                            }
                            case 32788: {
                                Integer st = (Integer)params.get(TraeAudioManager.PARAM_STREAMTYPE);
                                if (st == null) {
                                    QLog.e(TraeAudioManager.TAG, " MESSAGE_VOICECALL_AUIDOPARAM_CHANGED params.get(PARAM_STREAMTYPE)==null!!");
                                    break;
                                }
                                TraeAudioManager.this._streamType = st;
                                TraeAudioManagerLooper.this.InternalNotifyStreamTypeUpdate(st);
                                break;
                            }
                            case 32782: {
                                TraeAudioManagerLooper.this.InternalStartRing(params);
                                break;
                            }
                            case 32783: {
                                TraeAudioManagerLooper.this.InternalStopRing(params);
                                break;
                            }
                            case 32790: {
                                TraeAudioManagerLooper.this.abandonAudioFocus();
                                break;
                            }
                            case 32791: {
                                TraeAudioManagerLooper.this.requestAudioFocus(TraeAudioManager.this._streamType);
                                break;
                            }
                            case 32784: {
                                TraeAudioManagerLooper.this.InternalGetStreamType(params);
                                break;
                            }
                            case 32775: {
                                TraeAudioManager.this.InternalSessionConnectDevice(params, false);
                                break;
                            }
                            case 32792: {
                                highestDev = TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice();
                                TraeAudioManager.this.InternalConnectDevice(highestDev, null, true);
                                break;
                            }
                            case 32776: {
                                TraeAudioManager.this.InternalSessionEarAction(params);
                                break;
                            }
                            case 32785: 
                            case 32789: {
                                highestDev = TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice();
                                connectedDev = TraeAudioManager.this._deviceConfigManager.getConnectedDevice();
                                QLog.w(TraeAudioManager.TAG, "MESSAGE_AUTO_DEVICELIST_UPDATE  connectedDev:" + connectedDev + " highestDev" + highestDev);
                                if (IsUpdateSceneFlag && TraeAudioManagerLooper.this.IsFirstConnectDeviceFlag) {
                                    TraeAudioManagerLooper.this.IsFirstConnectDeviceFlag = false;
                                    if (IsMusicScene && !TraeAudioManager.this.IsBluetoothA2dpExisted) {
                                        TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice(TraeAudioManager.DEVICE_BLUETOOTHHEADSET), null, true);
                                        break;
                                    }
                                    TraeAudioManager.this.InternalConnectDevice(highestDev, null, true);
                                    break;
                                }
                                if (!highestDev.equals(connectedDev)) {
                                    TraeAudioManager.this.InternalConnectDevice(highestDev, null, false);
                                    break;
                                }
                                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                                break;
                            }
                            case 32786: {
                                plugDev = (String)params.get(TraeAudioManager.PARAM_DEVICE);
                                if (TraeAudioManager.this.InternalConnectDevice(plugDev, null, false) == 0) break;
                                QLog.w(TraeAudioManager.TAG, " plugin dev:" + plugDev + " sessionConnectedDev:" + TraeAudioManager.this.sessionConnectedDev + " connected fail,auto switch!");
                                TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice(), null, false);
                                break;
                            }
                            case 32787: {
                                if (TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this.sessionConnectedDev, null, false) == 0) break;
                                plugDev = (String)params.get(TraeAudioManager.PARAM_DEVICE);
                                QLog.w(TraeAudioManager.TAG, " plugout dev:" + plugDev + " sessionConnectedDev:" + TraeAudioManager.this.sessionConnectedDev + " connected fail,auto switch!");
                                TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice(), null, false);
                                break;
                            }
                        }
                    }
                }
            };
            this._init();
            boolean[] blArray = this._started;
            synchronized (this._started) {
                this._started[0] = true;
                this._started.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                Looper.loop();
                this._uninit();
                blArray = this._started;
                synchronized (this._started) {
                    this._started[0] = false;
                    this._started.notifyAll();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    AudioDeviceInterface.LogTraceExit();
                    return;
                }
            }
        }

        void _init() {
            AudioDeviceInterface.LogTraceEntry("");
            try {
                TraeAudioManager.this._audioSessionHost = new TraeAudioSessionHost();
                TraeAudioManager.this._deviceConfigManager = new DeviceConfigManager();
                _gHostProcessId = Process.myPid();
                TraeAudioManager.this._am = (AudioManager)TraeAudioManager.this._context.getSystemService("audio");
                TraeAudioManager.this._bluetoothCheck = TraeAudioManager.this.CreateBluetoothCheck(TraeAudioManager.this._context, TraeAudioManager.this._deviceConfigManager);
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.intent.action.HEADSET_PLUG");
                filter.addAction("android.media.AUDIO_BECOMING_NOISY");
                TraeAudioManager.this._bluetoothCheck.addAction(filter);
                filter.addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                if (ClientInfo.VERSION_SDK_INT >= 31) {
                    TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, filter, 2);
                } else {
                    TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, filter);
                }
            }
            catch (Exception e) {
                QLog.w(TraeAudioManager.TAG, "======7");
            }
            AudioDeviceInterface.LogTraceExit();
        }

        void _prev_startService() {
            try {
                TraeAudioManager.this._am = (AudioManager)TraeAudioManager.this._context.getSystemService("audio");
                if (TraeAudioManager.this._bluetoothCheck == null) {
                    TraeAudioManager.this._bluetoothCheck = TraeAudioManager.this.CreateBluetoothCheck(TraeAudioManager.this._context, TraeAudioManager.this._deviceConfigManager);
                }
                TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.intent.action.HEADSET_PLUG");
                filter.addAction("android.media.AUDIO_BECOMING_NOISY");
                TraeAudioManager.this._bluetoothCheck.addAction(filter);
                filter.addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                if (ClientInfo.VERSION_SDK_INT >= 31) {
                    TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, filter, 2);
                } else {
                    TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, filter);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void _post_stopService() {
            try {
                if (TraeAudioManager.this._bluetoothCheck != null) {
                    TraeAudioManager.this._bluetoothCheck.release();
                }
                TraeAudioManager.this._bluetoothCheck = null;
                if (TraeAudioManager.this._context != null) {
                    TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                    IntentFilter filter = new IntentFilter();
                    filter.addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                    if (ClientInfo.VERSION_SDK_INT >= 31) {
                        TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, filter, 2);
                    } else {
                        TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, filter);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void _uninit() {
            AudioDeviceInterface.LogTraceEntry("");
            try {
                this.stopService();
                if (TraeAudioManager.this._bluetoothCheck != null) {
                    TraeAudioManager.this._bluetoothCheck.release();
                }
                TraeAudioManager.this._bluetoothCheck = null;
                if (null != TraeAudioManager.this._context) {
                    TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                    TraeAudioManager.this._context = null;
                }
                if (TraeAudioManager.this._deviceConfigManager != null) {
                    TraeAudioManager.this._deviceConfigManager.clearConfig();
                }
                TraeAudioManager.this._deviceConfigManager = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            AudioDeviceInterface.LogTraceExit();
        }

        int InternalSessionGetDeviceList(HashMap<String, Object> params) {
            Intent intent = new Intent();
            HashMap<String, Object> resParams = TraeAudioManager.this._deviceConfigManager.getSnapParams();
            ArrayList list = (ArrayList)resParams.get(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST);
            String con = (String)resParams.get(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE);
            String prevCon = (String)resParams.get(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE);
            intent.putExtra(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, list.toArray(new String[0]));
            intent.putExtra(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, con);
            intent.putExtra(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, prevCon);
            intent.putExtra(TraeAudioManager.EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME, TraeAudioManager.this._deviceConfigManager.getBluetoothName());
            TraeAudioManager.this.sendResBroadcast(intent, params, 0);
            return 0;
        }

        @TargetApi(value=8)
        void requestAudioFocus(int streamType) {
            if (ClientInfo.VERSION_SDK_INT <= 8) {
                return;
            }
            if (this.mAudioFocusChangeListener == null) {
                this.mAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

                    @TargetApi(value=8)
                    public void onAudioFocusChange(int focusChange) {
                        QLog.w(TraeAudioManager.TAG, "focusChange:" + focusChange + " _focusSteamType:" + TraeAudioManagerLooper.this._focusSteamType + " currMode:" + TraeAudioManager.this._am.getMode() + " _activeMode:" + TraeAudioManager.this._activeMode);
                        if (focusChange == -1 || focusChange == -2 || focusChange == -3 || focusChange == 1) {
                            // empty if block
                        }
                    }
                };
                if (TraeAudioManager.this._am != null) {
                    try {
                        int ret = TraeAudioManager.this._am.requestAudioFocus(this.mAudioFocusChangeListener, streamType, 1);
                        if (ret != 1) {
                            QLog.e(TraeAudioManager.TAG, "request audio focus fail. " + ret + " mode:" + TraeAudioManager.this._am.getMode());
                        }
                        this._focusSteamType = streamType;
                        QLog.w(TraeAudioManager.TAG, "-------requestAudioFocus _focusSteamType:" + this._focusSteamType);
                    }
                    catch (SecurityException ignored) {
                        QLog.e(TraeAudioManager.TAG, "request audio focus exception. " + ignored);
                    }
                }
            }
        }

        @TargetApi(value=8)
        void abandonAudioFocus() {
            if (ClientInfo.VERSION_SDK_INT <= 8) {
                return;
            }
            if (TraeAudioManager.this._am != null && this.mAudioFocusChangeListener != null) {
                QLog.w(TraeAudioManager.TAG, "-------abandonAudioFocus _focusSteamType:" + this._focusSteamType);
                TraeAudioManager.this._am.abandonAudioFocus(this.mAudioFocusChangeListener);
                this.mAudioFocusChangeListener = null;
            }
        }

        int InternalVoicecallPreprocess(HashMap<String, Object> params) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (null == params) {
                return -1;
            }
            if (TraeAudioManager.this._am == null) {
                QLog.e(TraeAudioManager.TAG, " InternalVoicecallPreprocess am==null!!");
                return -1;
            }
            if (TraeAudioManager.this._activeMode == 1) {
                Intent intent = new Intent();
                TraeAudioManager.this.sendResBroadcast(intent, params, 2);
                return -1;
            }
            this._voiceCallSessionID = (Long)params.get(TraeAudioManager.PARAM_SESSIONID);
            this._voiceCallOperation = (String)params.get(TraeAudioManager.PARAM_OPERATION);
            TraeAudioManager.this._activeMode = 1;
            TraeAudioManager.this._prevMode = TraeAudioManager.this._am.getMode();
            Integer mode = -1;
            Integer streamType = 0;
            mode = (Integer)params.get(TraeAudioManager.PARAM_MODEPOLICY);
            if (mode == null) {
                QLog.e(TraeAudioManager.TAG, " params.get(PARAM_MODEPOLICY)==null!!");
                TraeAudioManager.this._modePolicy = -1;
            } else {
                TraeAudioManager.this._modePolicy = mode;
            }
            QLog.e(TraeAudioManager.TAG, "  _modePolicy:" + TraeAudioManager.this._modePolicy);
            streamType = (Integer)params.get(TraeAudioManager.PARAM_STREAMTYPE);
            if (streamType == null) {
                QLog.e(TraeAudioManager.TAG, " params.get(PARAM_STREAMTYPE)==null!!");
                TraeAudioManager.this._streamType = 0;
            } else {
                TraeAudioManager.this._streamType = streamType;
            }
            if ((nSceneMode == 6 || nSceneMode == 8) && nSpecialModeBypass3A == 1 && nSpeakerStreamType == 1) {
                QLog.w(TraeAudioManager.TAG, "VOIP select different mode,bypass 3A");
                if (TraeAudioManager.this._deviceConfigManager.getConnectedDevice().equals(TraeAudioManager.DEVICE_WIREDHEADSET)) {
                    TraeAudioManager.this.InternalSetMode(0);
                } else if (TraeAudioManager.isCloseSystemAPM(TraeAudioManager.this._modePolicy) && TraeAudioManager.this._activeMode != 2 && TraeAudioManager.this._deviceConfigManager != null) {
                    if (TraeAudioManager.this._deviceConfigManager.getConnectedDevice().equals(TraeAudioManager.DEVICE_SPEAKERPHONE)) {
                        TraeAudioManager.this.InternalSetMode(0);
                    } else {
                        TraeAudioManager.this.InternalSetMode(3);
                    }
                } else {
                    TraeAudioManager.this.InternalSetMode(TraeAudioManager.getCallAudioMode(TraeAudioManager.this._modePolicy));
                }
            } else if (TraeAudioManager.isCloseSystemAPM(TraeAudioManager.this._modePolicy) && TraeAudioManager.this._activeMode != 2 && TraeAudioManager.this._deviceConfigManager != null) {
                if (TraeAudioManager.this._deviceConfigManager.getConnectedDevice().equals(TraeAudioManager.DEVICE_SPEAKERPHONE)) {
                    TraeAudioManager.this.InternalSetMode(0);
                } else {
                    TraeAudioManager.this.InternalSetMode(3);
                }
            } else {
                TraeAudioManager.this.InternalSetMode(TraeAudioManager.getCallAudioMode(TraeAudioManager.this._modePolicy));
            }
            Intent intent = new Intent();
            TraeAudioManager.this.sendResBroadcast(intent, params, 0);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalVoicecallPostprocess(HashMap<String, Object> params) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (TraeAudioManager.this._am == null) {
                QLog.e(TraeAudioManager.TAG, " InternalVoicecallPostprocess am==null!!");
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 1) {
                QLog.e(TraeAudioManager.TAG, " not ACTIVE_VOICECALL!!");
                Intent intent = new Intent();
                TraeAudioManager.this.sendResBroadcast(intent, params, 3);
                return -1;
            }
            TraeAudioManager.this._activeMode = 0;
            if (TraeAudioManager.this._switchThread != null) {
                QLog.w(TraeAudioManager.TAG, "_switchThread:" + TraeAudioManager.this._switchThread.getDeviceName());
                TraeAudioManager.this._switchThread.quit();
                TraeAudioManager.this._switchThread = null;
            }
            this.abandonAudioFocus();
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int interruptVoicecallPostprocess() {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (TraeAudioManager.this._am == null) {
                QLog.e(TraeAudioManager.TAG, " am==null!!");
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 1) {
                QLog.e(TraeAudioManager.TAG, " not ACTIVE_RING!!");
                return -1;
            }
            TraeAudioManager.this._activeMode = 0;
            if (TraeAudioManager.this._prevMode != -1) {
                TraeAudioManager.this.InternalSetMode(TraeAudioManager.this._prevMode);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(TraeAudioManager.PARAM_SESSIONID, this._voiceCallSessionID);
            params.put(TraeAudioManager.PARAM_OPERATION, this._voiceCallOperation);
            Intent intent = new Intent();
            TraeAudioManager.this.sendResBroadcast(intent, params, 6);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalStartRing(HashMap<String, Object> params) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (TraeAudioManager.this._am == null) {
                QLog.e(TraeAudioManager.TAG, " InternalStartRing am==null!!");
                return -1;
            }
            if (TraeAudioManager.this._activeMode == 2) {
                this.interruptRing();
            }
            int dataSource = 0;
            int rsId = -1;
            Uri res = null;
            String strFilePath = null;
            boolean bLoop = false;
            int loopCount = 1;
            boolean ringMode = false;
            try {
                this._ringSessionID = (Long)params.get(TraeAudioManager.PARAM_SESSIONID);
                this._ringOperation = (String)params.get(TraeAudioManager.PARAM_OPERATION);
                this._ringUserdata = (String)params.get(TraeAudioManager.PARAM_RING_USERDATA_STRING);
                dataSource = (Integer)params.get(TraeAudioManager.PARAM_RING_DATASOURCE);
                QLog.w(TraeAudioManager.TAG, "  dataSource:" + dataSource);
                rsId = (Integer)params.get(TraeAudioManager.PARAM_RING_RSID);
                res = (Uri)params.get(TraeAudioManager.PARAM_RING_URI);
                strFilePath = (String)params.get(TraeAudioManager.PARAM_RING_FILEPATH);
                bLoop = (Boolean)params.get(TraeAudioManager.PARAM_RING_LOOP);
                loopCount = (Integer)params.get(TraeAudioManager.PARAM_RING_LOOPCOUNT);
                ringMode = (Boolean)params.get(TraeAudioManager.PARAM_RING_MODE);
            }
            catch (Exception e) {
                QLog.e(TraeAudioManager.TAG, " startRing err params");
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 1) {
                TraeAudioManager.this._activeMode = 2;
            }
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, params, 0);
            this._preRingMode = TraeAudioManager.this._am.getMode();
            this._ringPlayer.playRing(dataSource, rsId, res, strFilePath, bLoop, loopCount, ringMode, TraeAudioManager.this._activeMode == 1, TraeAudioManager.this._streamType);
            QLog.w(TraeAudioManager.TAG, " _ringUserdata:" + this._ringUserdata + " DurationMS:" + this._ringPlayer.getDuration());
            if (!this._ringPlayer.hasCall()) {
                this.requestAudioFocus(this._ringPlayer.getStreamType());
            }
            this.InternalNotifyStreamTypeUpdate(this._ringPlayer.getStreamType());
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalStopRing(HashMap<String, Object> params) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + this._preRingMode);
            if (TraeAudioManager.this._am == null || this._ringPlayer == null) {
                QLog.e(TraeAudioManager.TAG, " InternalStopRing am==null!!");
                return -1;
            }
            this._ringPlayer.stopRing();
            if (!this._ringPlayer.hasCall() && TraeAudioManager.this._activeMode == 2) {
                this.abandonAudioFocus();
                TraeAudioManager.this._activeMode = 0;
            }
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, params, 0);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalGetStreamType(HashMap<String, Object> params) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + this._preRingMode);
            if (TraeAudioManager.this._am == null) {
                QLog.e(TraeAudioManager.TAG, " InternalStopRing am==null!!");
                return -1;
            }
            int st = -1;
            st = TraeAudioManager.this._activeMode == 2 ? this._ringPlayer.getStreamType() : TraeAudioManager.this._streamType;
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.EXTRA_DATA_STREAMTYPE, st);
            TraeAudioManager.this.sendResBroadcast(intent, params, 0);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalNotifyStreamTypeUpdate(int st) {
            if (null == TraeAudioManager.this._context) {
                return -1;
            }
            final int TAMst = st;
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent();
                    intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                    intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_STREAMTYPE_UPDATE);
                    intent.putExtra(TraeAudioManager.EXTRA_DATA_STREAMTYPE, TAMst);
                    if (TraeAudioManager.this._context != null) {
                        intent.setPackage(TraeAudioManager.this._context.getPackageName());
                    }
                    TraeAudioManager.this._context.sendBroadcast(intent);
                }
            });
            return 0;
        }

        int interruptRing() {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + this._preRingMode);
            if (TraeAudioManager.this._am == null) {
                QLog.e(TraeAudioManager.TAG, " interruptRing am==null!!");
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 2) {
                QLog.e(TraeAudioManager.TAG, " not ACTIVE_RING!!");
                return -1;
            }
            this._ringPlayer.stopRing();
            this.abandonAudioFocus();
            TraeAudioManager.this._activeMode = 0;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(TraeAudioManager.PARAM_SESSIONID, this._ringSessionID);
            params.put(TraeAudioManager.PARAM_OPERATION, this._ringOperation);
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, params, 4);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        void notifyRingCompletion() {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(TraeAudioManager.PARAM_SESSIONID, this._ringSessionID);
            params.put(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_RING_COMPLETION);
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, params, 0);
        }
    }

    class DeviceConfigManager {
        HashMap<String, DeviceConfig> deviceConfigs = new HashMap();
        String prevConnectedDevice = "DEVICE_NONE";
        String connectedDevice = "DEVICE_NONE";
        String connectingDevice = "DEVICE_NONE";
        ReentrantLock mLock = new ReentrantLock();
        boolean visiableUpdate = false;
        String _bluetoothDevName = "unknow";

        public boolean init(String strConfigs) {
            String[] configs;
            AudioDeviceInterface.LogTraceEntry(" strConfigs:" + strConfigs);
            if (null == strConfigs || strConfigs.length() <= 0) {
                return false;
            }
            strConfigs = strConfigs.replace("\n", "");
            if (null == (strConfigs = strConfigs.replace("\r", "")) || strConfigs.length() <= 0) {
                return false;
            }
            if (0 > strConfigs.indexOf(";")) {
                strConfigs = strConfigs + ";";
            }
            if (null == (configs = strConfigs.split(";")) || 1 > configs.length) {
                return false;
            }
            this.mLock.lock();
            for (int i = 0; i < configs.length; ++i) {
                this._addConfig(configs[i], i);
            }
            this.mLock.unlock();
            TraeAudioManager.this.printDevices();
            return true;
        }

        boolean _addConfig(String strDeviceName, int nPriority) {
            AudioDeviceInterface.LogTraceEntry(" devName:" + strDeviceName + " priority:" + nPriority);
            DeviceConfig dc = new DeviceConfig();
            if (dc.init(strDeviceName, nPriority)) {
                if (this.deviceConfigs.containsKey(strDeviceName)) {
                    QLog.e(TraeAudioManager.TAG, "err dev exist!");
                    return false;
                }
                this.deviceConfigs.put(strDeviceName, dc);
                this.visiableUpdate = true;
                QLog.w(TraeAudioManager.TAG, " n" + this.getDeviceNumber() + " 0:" + this.getDeviceName(0));
                AudioDeviceInterface.LogTraceExit();
                return true;
            }
            QLog.e(TraeAudioManager.TAG, " err dev init!");
            return false;
        }

        public void clearConfig() {
            this.mLock.lock();
            this.deviceConfigs.clear();
            this.prevConnectedDevice = TraeAudioManager.DEVICE_NONE;
            this.connectedDevice = TraeAudioManager.DEVICE_NONE;
            CurConnectedDevice = TraeAudioManager.DEVICE_NONE;
            this.connectingDevice = TraeAudioManager.DEVICE_NONE;
            this.mLock.unlock();
        }

        public boolean getVisiableUpdateFlag() {
            boolean res = false;
            this.mLock.lock();
            res = this.visiableUpdate;
            this.mLock.unlock();
            return res;
        }

        public void resetVisiableUpdateFlag() {
            this.mLock.lock();
            this.visiableUpdate = false;
            this.mLock.unlock();
        }

        public boolean setVisible(String strDeviceName, boolean bVisible) {
            boolean bRet = false;
            this.mLock.lock();
            DeviceConfig dc = this.deviceConfigs.get(strDeviceName);
            if (dc != null && dc.getVisible() != bVisible) {
                dc.setVisible(bVisible);
                this.visiableUpdate = true;
                QLog.w(TraeAudioManager.TAG, " ++setVisible:" + strDeviceName + (bVisible ? " Y" : " N"));
                bRet = true;
            }
            this.mLock.unlock();
            return bRet;
        }

        public void setBluetoothName(String btName) {
            if (btName == null) {
                this._bluetoothDevName = "unknow";
                return;
            }
            this._bluetoothDevName = btName.isEmpty() ? "unknow" : btName;
        }

        public String getBluetoothName() {
            return this._bluetoothDevName;
        }

        public boolean getVisible(String strDeviceName) {
            boolean bRet = false;
            this.mLock.lock();
            DeviceConfig dc = this.deviceConfigs.get(strDeviceName);
            if (null != dc) {
                bRet = dc.getVisible();
            }
            this.mLock.unlock();
            return bRet;
        }

        public int getPriority(String strDeviceName) {
            int nRet = -1;
            this.mLock.lock();
            DeviceConfig dc = this.deviceConfigs.get(strDeviceName);
            if (null != dc) {
                nRet = dc.getPriority();
            }
            this.mLock.unlock();
            return nRet;
        }

        public int getDeviceNumber() {
            this.mLock.lock();
            int n = this.deviceConfigs.size();
            this.mLock.unlock();
            return n;
        }

        public String getDeviceName(int id) {
            String str = TraeAudioManager.DEVICE_NONE;
            int i = 0;
            this.mLock.lock();
            DeviceConfig _dc = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                if (i == id) {
                    _dc = entry.getValue();
                    break;
                }
                ++i;
            }
            if (_dc != null) {
                str = _dc.getDeviceName();
            }
            this.mLock.unlock();
            return str;
        }

        public String getAvailabledHighestPriorityDevice(String IgnoreDeviceName) {
            DeviceConfig dst = null;
            this.mLock.lock();
            DeviceConfig _dc = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                String key = entry.getKey();
                DeviceConfig val = entry.getValue();
                _dc = entry.getValue();
                if (_dc == null || !_dc.getVisible() || _dc.getDeviceName().equals(IgnoreDeviceName)) continue;
                if (dst == null) {
                    dst = _dc;
                    continue;
                }
                if (_dc.getPriority() < dst.getPriority()) continue;
                dst = _dc;
            }
            this.mLock.unlock();
            return dst != null ? dst.getDeviceName() : TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        public String getAvailabledHighestPriorityDevice() {
            DeviceConfig dst = null;
            this.mLock.lock();
            DeviceConfig _dc = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                String key = entry.getKey();
                DeviceConfig val = entry.getValue();
                _dc = entry.getValue();
                if (_dc == null || !_dc.getVisible()) continue;
                if (dst == null) {
                    dst = _dc;
                    continue;
                }
                if (_dc.getPriority() < dst.getPriority()) continue;
                dst = _dc;
            }
            this.mLock.unlock();
            return dst != null ? dst.getDeviceName() : TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        public String getConnectingDevice() {
            String str = TraeAudioManager.DEVICE_NONE;
            this.mLock.lock();
            str = null;
            DeviceConfig dc = this.deviceConfigs.get(this.connectingDevice);
            if (null != dc && dc.getVisible()) {
                str = this.connectingDevice;
            }
            this.mLock.unlock();
            return str;
        }

        public String getConnectedDevice() {
            String str = TraeAudioManager.DEVICE_NONE;
            this.mLock.lock();
            str = this._getConnectedDevice();
            this.mLock.unlock();
            return str;
        }

        public String getPrevConnectedDevice() {
            String str = TraeAudioManager.DEVICE_NONE;
            this.mLock.lock();
            str = this._getPrevConnectedDevice();
            this.mLock.unlock();
            return str;
        }

        public boolean setConnecting(String strDeviceName) {
            boolean res = false;
            this.mLock.lock();
            DeviceConfig dc = this.deviceConfigs.get(strDeviceName);
            if (dc != null && dc.getVisible()) {
                this.connectingDevice = strDeviceName;
                res = true;
            }
            this.mLock.unlock();
            return res;
        }

        public boolean setConnected(String strDeviceName) {
            boolean res = false;
            this.mLock.lock();
            DeviceConfig dc = this.deviceConfigs.get(strDeviceName);
            if (dc != null && dc.getVisible()) {
                if (this.connectedDevice != null && !this.connectedDevice.equals(strDeviceName)) {
                    this.prevConnectedDevice = this.connectedDevice;
                }
                this.connectedDevice = strDeviceName;
                CurConnectedDevice = strDeviceName;
                this.connectingDevice = "";
                res = true;
            }
            this.mLock.unlock();
            return res;
        }

        public boolean isConnected(String strDeviceName) {
            boolean res = false;
            this.mLock.lock();
            DeviceConfig dc = this.deviceConfigs.get(strDeviceName);
            if (dc != null && dc.getVisible()) {
                res = this.connectedDevice.equals(strDeviceName);
            }
            this.mLock.unlock();
            return res;
        }

        public HashMap<String, Object> getSnapParams() {
            HashMap<String, Object> params = new HashMap<String, Object>();
            this.mLock.lock();
            params.put(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, this._getAvailableDeviceList());
            params.put(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, this._getConnectedDevice());
            params.put(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, this._getPrevConnectedDevice());
            this.mLock.unlock();
            return params;
        }

        public ArrayList<String> getAvailableDeviceList() {
            ArrayList<String> list = new ArrayList();
            this.mLock.lock();
            list = this._getAvailableDeviceList();
            this.mLock.unlock();
            return list;
        }

        ArrayList<String> _getAvailableDeviceList() {
            ArrayList<String> list = new ArrayList<String>();
            DeviceConfig _dc = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                _dc = entry.getValue();
                if (_dc == null || !_dc.getVisible()) continue;
                list.add(_dc.getDeviceName());
            }
            return list;
        }

        String _getConnectedDevice() {
            String str = TraeAudioManager.DEVICE_NONE;
            DeviceConfig dc = this.deviceConfigs.get(this.connectedDevice);
            if (null != dc && dc.getVisible()) {
                str = this.connectedDevice;
            }
            return str;
        }

        String _getPrevConnectedDevice() {
            String str = TraeAudioManager.DEVICE_NONE;
            DeviceConfig dc = this.deviceConfigs.get(this.prevConnectedDevice);
            if (null != dc && dc.getVisible()) {
                str = this.prevConnectedDevice;
            }
            return str;
        }

        public class DeviceConfig {
            String deviceName = "DEVICE_NONE";
            boolean visible = false;
            int priority = 0;

            public boolean init(String strDeviceName, int nPriority) {
                if (null == strDeviceName || strDeviceName.length() <= 0) {
                    return false;
                }
                if (!TraeAudioManager.checkDevName(strDeviceName)) {
                    return false;
                }
                this.deviceName = strDeviceName;
                this.priority = nPriority;
                return true;
            }

            public String getDeviceName() {
                return this.deviceName;
            }

            public boolean getVisible() {
                return this.visible;
            }

            public int getPriority() {
                return this.priority;
            }

            public void setVisible(boolean arg) {
                this.visible = arg;
            }
        }
    }

    public static interface Bluetooth_State {
        public static final int UNINITIALIZED = 1;
        public static final int ERROR = 2;
        public static final int HEADSET_UNAVAILABLE = 3;
        public static final int HEADSET_AVAILABLE = 4;
        public static final int SCO_DISCONNECTING = 5;
        public static final int SCO_CONNECTING = 6;
        public static final int SCO_CONNECTED = 7;
    }

    public class Parameters {
        public static final String CONTEXT = "com.gme.sharpgme.TraeAudioManager.Parameters.CONTEXT";
        public static final String MODEPOLICY = "com.gme.sharpgme.TraeAudioManager.Parameters.MODEPOLICY";
        public static final String BLUETOOTHPOLICY = "com.gme.sharpgme.TraeAudioManager.Parameters.BLUETOOTHPOLICY";
        public static final String DEVICECONFIG = "com.gme.sharpgme.TraeAudioManager.Parameters.DEVICECONFIG";
    }
}

