/*
 * Decompiled with CFR 0.152.
 */
package com.gme.sharpgme.jni;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import com.gme.av.utils.ClientInfo;
import com.gme.av.utils.QLog;
import com.gme.sharpgme.jni.TraeAudioCodecList;
import com.gme.sharpgme.jni.TraeAudioManager;
import com.gme.sharpgme.jni.TraeAudioSession;
import com.gme.sharpgme.jni.VivoKTVHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=16)
public class AudioDeviceInterface {
    private static final String TAG = "TRAEJava";
    private AudioTrack _audioTrack = null;
    private AudioRecord _audioRecord = null;
    private static boolean _startRecordRefuse = false;
    private static AudioRecord _lastAudioRecord = null;
    private int _streamType = 0;
    private int _playSamplerate = 8000;
    private int _channelOutType = 4;
    private int _audioSource = 0;
    private int _deviceStat = 0;
    private int _sceneMode = 0;
    private int _sessionId = 0;
    private Context _context = null;
    private int _modePolicy = -1;
    private int _audioSourcePolicy = -1;
    private int _audioStreamTypePolicy = -1;
    private AudioManager _audioManager = null;
    private ByteBuffer _playBuffer;
    private ByteBuffer _recBuffer;
    private byte[] _tempBufPlay;
    private byte[] _tempBufRec;
    private boolean _doPlayInit = true;
    private boolean _doRecInit = true;
    private boolean _isRecording = false;
    private boolean _isPlaying = false;
    private int _bufferedRecSamples = 0;
    private int _bufferedPlaySamples = 0;
    private int _playPosition = 0;
    private File _rec_dump = null;
    private File _play_dump = null;
    private FileOutputStream _rec_out = null;
    private FileOutputStream _play_out = null;
    private static boolean _dumpEnable = false;
    private static boolean _logEnable = true;
    private int nRecordLengthMs = 0;
    private int nPlayLengthMs = 0;
    private TraeAudioCodecList _traeAudioCodecList = null;
    private static String[] mDeviceList = null;
    private static VivoKTVHelper mVivoKTVHelper = null;
    private static boolean isSupportVivoKTVHelper = false;
    private static boolean isUseForceVolumeControl = false;
    static int weatherRequest = 0;
    private TraeAudioSession _as = null;
    private String _connectedDev = "DEVICE_NONE";
    private boolean _audioRouteChanged = false;
    private ReentrantLock _prelock = new ReentrantLock();
    private Condition _precon = this._prelock.newCondition();
    private boolean _preDone = false;
    private boolean usingJava = true;
    private int switchState = 0;
    private static int lastSwitchState = 0;
    private TraeAudioSession _asAudioManager = null;
    public static final int OUTPUT_MODE_HEADSET = 0;
    public static final int OUTPUT_MODE_SPEAKER = 1;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (path.charAt(i) >= '0' && path.charAt(i) <= '9') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public static void setStartRecordRefuse(boolean refuse) {
        _startRecordRefuse = refuse;
    }

    public AudioDeviceInterface() {
        try {
            this._playBuffer = ByteBuffer.allocateDirect(1920);
            this._recBuffer = ByteBuffer.allocateDirect(1920);
        }
        catch (Exception e) {
            QLog.w(TAG, e.getMessage());
        }
        this._tempBufPlay = new byte[1920];
        this._tempBufRec = new byte[1920];
        this._traeAudioCodecList = new TraeAudioCodecList();
        int apiLevel = ClientInfo.VERSION_SDK_INT;
        QLog.w(TAG, "AudioDeviceInterface apiLevel:" + apiLevel);
        QLog.w(TAG, " SDK_INT:" + ClientInfo.VERSION_SDK_INT);
        if (apiLevel <= 0) {
            apiLevel = 0;
        }
        QLog.w(TAG, "manufacture:" + ClientInfo.MANUFACTURER);
        QLog.w(TAG, "MODEL:" + ClientInfo.MODEL);
    }

    public void setContext(Context ctx) {
        this._context = ctx;
    }

    private int getLowlatencySamplerate() {
        if (this._context == null || ClientInfo.VERSION_SDK_INT < 9) {
            QLog.e(TAG, "getLowlatencySamplerate err, _context:" + this._context + " api:" + ClientInfo.VERSION_SDK_INT);
            return 0;
        }
        PackageManager pm = this._context.getPackageManager();
        boolean claimsFeature = pm.hasSystemFeature("android.hardware.audio.low_latency");
        QLog.w(TAG, "LOW_LATENCY:" + (claimsFeature ? "Y" : "N"));
        if (ClientInfo.VERSION_SDK_INT < 17) {
            QLog.e(TAG, "API Level too low not support PROPERTY_OUTPUT_SAMPLE_RATE");
            return 0;
        }
        QLog.e(TAG, "getLowlatencySamplerate not support right now!");
        return 0;
    }

    private int getLowlatencyFramesPerBuffer() {
        if (this._context == null || ClientInfo.VERSION_SDK_INT < 9) {
            QLog.e(TAG, "getLowlatencySamplerate err, _context:" + this._context + " api:" + ClientInfo.VERSION_SDK_INT);
            return 0;
        }
        PackageManager pm = this._context.getPackageManager();
        boolean claimsFeature = pm.hasSystemFeature("android.hardware.audio.low_latency");
        QLog.w(TAG, "LOW_LATENCY:" + (claimsFeature ? "Y" : "N"));
        if (ClientInfo.VERSION_SDK_INT < 17) {
            QLog.e(TAG, "API Level too low not support PROPERTY_OUTPUT_SAMPLE_RATE");
            return 0;
        }
        return 0;
    }

    @TargetApi(value=16)
    private int getAudioSessionId(AudioRecord record) {
        return 0;
    }

    private boolean IsContainRecordAbility() {
        boolean flag = false;
        if (this._deviceStat == 0 || this._deviceStat == 1 || this._deviceStat == 3 || this._deviceStat == 5) {
            flag = true;
        }
        return flag;
    }

    private int OpenSpeaker(boolean speakerOn) {
        return TraeAudioManager.OpenSpeaker(speakerOn);
    }

    private int InitSetting(int audioSourcePolicy, int audioStreamTypePolicy, int modePolicy, int DeviceStat, int sceneMode) {
        this._audioSourcePolicy = audioSourcePolicy;
        this._audioStreamTypePolicy = audioStreamTypePolicy;
        this._modePolicy = modePolicy;
        this._deviceStat = DeviceStat;
        this._sceneMode = sceneMode;
        TraeAudioManager.IsMusicScene = this._deviceStat == 1 || this._deviceStat == 5 || this._deviceStat == 2 || this._deviceStat == 3;
        TraeAudioManager.IsEarPhoneSupported = this._sceneMode == 0 || this._sceneMode == 4;
        TraeAudioManager.IsUpdateSceneFlag = true;
        TraeAudioManager.nSceneMode = sceneMode;
        QLog.w(TAG, "InitSetting: _audioSourcePolicy:" + this._audioSourcePolicy + " _audioStreamTypePolicy:" + this._audioStreamTypePolicy + " _modePolicy:" + this._modePolicy + " DeviceStat:" + DeviceStat + " isSupportVivoKTVHelper:" + isSupportVivoKTVHelper + " sceneMode:" + sceneMode);
        return 0;
    }

    private int SetAudParam(int specialModeBypass3A, int speakerStreamType) {
        TraeAudioManager.nSpecialModeBypass3A = specialModeBypass3A;
        TraeAudioManager.nSpeakerStreamType = speakerStreamType;
        QLog.w(TAG, "SetAudParam: specialModeBypass3A:" + specialModeBypass3A + " speakerStreamType:" + speakerStreamType);
        return 0;
    }

    private int InitRecording(int sampleRate, int nChannels) {
        QLog.w(TAG, "InitRecording entry:" + sampleRate);
        if (this._isRecording || this._audioRecord != null || nChannels > 2) {
            QLog.e(TAG, "InitRecording _isRecording:" + this._isRecording);
            return -1;
        }
        int _channelInType = 16;
        if (nChannels == 2) {
            _channelInType = 12;
        }
        if (_startRecordRefuse) {
            QLog.e(TAG, "InitRecording _startRecordRefuse:" + _startRecordRefuse);
            return -1;
        }
        int minRecBufSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)_channelInType, (int)2);
        int framesize = 20 * sampleRate * nChannels * 2 / 1000;
        QLog.w(TAG, "InitRecording: min rec buf size is " + minRecBufSize + " sr:" + this.getLowlatencySamplerate() + " fp" + this.getLowlatencyFramesPerBuffer() + " 20msFZ:" + framesize);
        this._bufferedRecSamples = 5 * sampleRate / 200;
        QLog.w(TAG, "  rough rec delay set to " + this._bufferedRecSamples);
        if (this._audioRecord != null) {
            this._audioRecord.release();
            this._audioRecord = null;
        }
        int[] as = new int[]{0, 1, 5, 0};
        as[0] = TraeAudioManager.getAudioSource(this._audioSourcePolicy);
        int recBufSize = minRecBufSize;
        block2: for (int i = 0; i < as.length && this._audioRecord == null; ++i) {
            this._audioSource = as[i];
            for (int j = 1; j <= 2; ++j) {
                recBufSize = minRecBufSize * j;
                if (recBufSize < framesize * 4 && j < 2) continue;
                try {
                    this.nRecordLengthMs = recBufSize * 500 / (sampleRate * nChannels);
                    if (TraeAudioManager.nSpecialModeBypass3A == 1 && TraeAudioManager.nSpeakerStreamType == 1 && TraeAudioManager.getConnectedDevice().equals("DEVICE_WIREDHEADSET") && (this._sceneMode == 6 || this._sceneMode == 8)) {
                        this._audioSource = 1;
                    }
                    this._audioRecord = new AudioRecord(this._audioSource, sampleRate, _channelInType, 2, recBufSize);
                }
                catch (Exception e) {
                    QLog.w(TAG, e.getMessage() + " _audioRecord:" + this._audioRecord);
                    if (this._audioRecord != null) {
                        this._audioRecord.release();
                    }
                    this._audioRecord = null;
                    continue;
                }
                if (this._audioRecord.getState() == 1) continue block2;
                QLog.w(TAG, "InitRecording:  rec not initialized,try agine,  minbufsize:" + recBufSize + " sr:" + sampleRate + " as:" + this._audioSource);
                this._audioRecord.release();
                this._audioRecord = null;
            }
        }
        if (this._audioRecord == null) {
            QLog.w(TAG, "InitRecording fail!!!");
            return -1;
        }
        QLog.w(TAG, " [Config] InitRecording: audioSession:" + this._sessionId + " audioSource:" + this._audioSource + " rec sample rate set to " + sampleRate + " recBufSize:" + recBufSize + " nRecordLengthMs:" + this.nRecordLengthMs);
        QLog.w(TAG, "InitRecording exit");
        return this._bufferedRecSamples;
    }

    private int InitPlayback(int sampleRate, int nChannels) {
        int nStreamTypeTmp;
        QLog.w(TAG, "InitPlayback entry: sampleRate " + sampleRate);
        if (this._isPlaying || this._audioTrack != null || nChannels > 2) {
            QLog.e(TAG, "InitPlayback _isPlaying:" + this._isPlaying);
            return -1;
        }
        if (this._audioManager == null) {
            try {
                this._audioManager = (AudioManager)this._context.getSystemService("audio");
            }
            catch (Exception e) {
                QLog.w(TAG, e.getMessage());
                return -1;
            }
        }
        this._channelOutType = nChannels == 2 ? 12 : 4;
        this._playSamplerate = sampleRate;
        int minPlayBufSize = AudioTrack.getMinBufferSize((int)sampleRate, (int)this._channelOutType, (int)2);
        if (this._channelOutType == 12) {
            QLog.w(TAG, "InitPlayback, _channelOutType stero");
        } else if (this._channelOutType == 4) {
            QLog.w(TAG, "InitPlayback, _channelOutType Mono");
        }
        int framesize = 20 * sampleRate * 1 * 2 / 1000;
        if (this._channelOutType == 12) {
            framesize *= 2;
        }
        QLog.w(TAG, "InitPlayback: minPlayBufSize:" + minPlayBufSize + " 20msFz:" + framesize);
        this._bufferedPlaySamples = 0;
        if (this._audioTrack != null) {
            this._audioTrack.release();
            this._audioTrack = null;
        }
        int[] st = new int[]{0, 0, 3, 1};
        this._streamType = TraeAudioManager.getAudioStreamType(this._audioStreamTypePolicy);
        if (this._audioRouteChanged) {
            QLog.w(TAG, "_audioRouteChanged:" + this._audioRouteChanged + " _streamType:" + this._streamType);
            this._streamType = this._audioManager.getMode() == 0 && this._connectedDev.equals("DEVICE_SPEAKERPHONE") ? 3 : 0;
            this._audioRouteChanged = false;
        }
        st[0] = this._streamType;
        int playBufSize = minPlayBufSize;
        block4: for (int i = 0; i < st.length && this._audioTrack == null; ++i) {
            this._streamType = st[i];
            QLog.w(TAG, "InitPlayback: min play buf size is " + minPlayBufSize + " hw_sr:" + AudioTrack.getNativeOutputSampleRate((int)this._streamType));
            for (int j = 1; j <= 2; ++j) {
                playBufSize = minPlayBufSize * j;
                if (playBufSize < framesize * 4 && j < 2) continue;
                try {
                    if (ClientInfo.VERSION_SDK_INT >= 31) {
                        int try_count = 10;
                        if (TraeAudioManager.bluetoothState == 5) {
                            QLog.w(TAG, "InitPlayback: waiting for sco disconnect");
                            while (TraeAudioManager.bluetoothState == 5 && try_count-- > 0) {
                                Thread.sleep(200L);
                            }
                        }
                        if (TraeAudioManager.bluetoothState == 4 && TraeAudioManager.needStopBluetoothSco && this._streamType != 0) {
                            QLog.w(TAG, "InitPlayback: waiting 2s for sco ready");
                            Thread.sleep(2000L);
                        }
                        TraeAudioManager.needStopBluetoothSco = false;
                    }
                    this.nPlayLengthMs = playBufSize * 500 / (sampleRate * nChannels);
                    this._audioTrack = new AudioTrack(this._streamType, this._playSamplerate, this._channelOutType, 2, playBufSize, 1);
                }
                catch (Exception e) {
                    QLog.w(TAG, e.getMessage() + " _audioTrack:" + this._audioTrack);
                    if (this._audioTrack != null) {
                        this._audioTrack.release();
                    }
                    this._audioTrack = null;
                    continue;
                }
                if (this._audioTrack.getState() == 1) continue block4;
                QLog.w(TAG, "InitPlayback: play not initialized playBufSize:" + playBufSize + " sr:" + this._playSamplerate);
                this._audioTrack.release();
                this._audioTrack = null;
            }
        }
        if (this._audioTrack == null) {
            QLog.w(TAG, "InitPlayback fail!!!");
            return -1;
        }
        if (this._as != null && this._audioManager != null) {
            this._as.voiceCallAudioParamChanged(this._audioManager.getMode(), this._streamType);
        }
        this._playPosition = this._audioTrack.getPlaybackHeadPosition();
        QLog.w(TAG, "InitPlayback exit: streamType:" + this._streamType + " samplerate:" + this._playSamplerate + " _playPosition:" + this._playPosition + " playBufSize:" + playBufSize + " nPlayLengthMs:" + this.nPlayLengthMs);
        int n = nStreamTypeTmp = this._connectedDev.equals("DEVICE_BLUETOOTHHEADSET") ? 6 : this._audioTrack.getStreamType();
        if ((!isUseForceVolumeControl || this._sceneMode != 6 && this._sceneMode != 8 || TraeAudioManager.nSpecialModeBypass3A != 1 || TraeAudioManager.nSpeakerStreamType != 1) && this._audioManager != null) {
            QLog.w(TAG, "InitPlayback forceVolumeControlStream");
            TraeAudioManager.forceVolumeControlStream(this._audioManager, nStreamTypeTmp);
            isUseForceVolumeControl = true;
        }
        if (nStreamTypeTmp != 0) {
            isUseForceVolumeControl = false;
        }
        return 0;
    }

    private int getPlayRecordSysBufferMs() {
        return (this.nRecordLengthMs + this.nPlayLengthMs) * 2;
    }

    private String getDumpFilePath(String filename, int mode) {
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String formattedDate = currentDate.format(formatter);
        String str = this._context.getExternalFilesDir(null).getAbsolutePath() + "/trae-dump-" + formattedDate + "/MF-" + ClientInfo.MANUFACTURER + "-M-" + ClientInfo.MODEL + "-as-" + TraeAudioManager.getAudioSource(this._audioSourcePolicy) + "-st-" + this._streamType + "-m-" + mode + "-" + filename;
        QLog.w(TAG, "dump:" + str);
        QLog.w(TAG, "dump replace:" + str.replace(" ", "_"));
        return str.replace(" ", "_");
    }

    private int StartRecording() {
        String filePath;
        File file;
        boolean isOppoHit;
        QLog.w(TAG, "StartRecording entry  " + this);
        if (this._isRecording) {
            QLog.e(TAG, "StartRecording _isRecording:" + this._isRecording);
            return -1;
        }
        if (this._audioRecord == null) {
            QLog.e(TAG, "StartRecording _audioRecord:" + this._audioRecord);
            return -1;
        }
        if (_startRecordRefuse) {
            QLog.e(TAG, "StartRecording _startRecordRefuse:" + _startRecordRefuse);
            return -1;
        }
        long startRecordTime = System.currentTimeMillis();
        try {
            this._audioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            QLog.e(TAG, "StartRecording fail");
            e.printStackTrace();
            return -1;
        }
        boolean isVivoHit = Build.BRAND.equals("vivo") && ClientInfo.VERSION_SDK_INT >= 22 && ClientInfo.VERSION_SDK_INT <= 26;
        boolean bl = isOppoHit = Build.BRAND.equals("OPPO") && (ClientInfo.VERSION_SDK_INT == 22 || ClientInfo.VERSION_SDK_INT == 23);
        if (System.currentTimeMillis() - startRecordTime > 100L && this._audioRecord.getRecordingState() != 3 && (isVivoHit || isOppoHit)) {
            _startRecordRefuse = true;
            QLog.e(TAG, "StartRecording startRecording refuse by user  " + this);
            _lastAudioRecord = this._audioRecord;
            this._audioRecord = null;
            return -1;
        }
        if (this._context != null && (file = new File(filePath = this._context.getExternalFilesDir(null).getAbsolutePath() + "/trae-dump/WRITE_PCM.config")).exists()) {
            _dumpEnable = true;
        }
        if (_dumpEnable) {
            this._rec_dump = new File(this.getDumpFilePath("jnirecord.pcm", this._audioManager != null ? this._audioManager.getMode() : -1));
            try {
                this._rec_out = new FileOutputStream(this._rec_dump);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        this._isRecording = true;
        QLog.w(TAG, "StartRecording ok");
        return 0;
    }

    private int StartPlayback() {
        String filePath;
        File file;
        if (this._isPlaying) {
            QLog.e(TAG, "StartPlayback _isPlaying");
            return -1;
        }
        if (this._audioTrack == null) {
            QLog.e(TAG, "StartPlayback _audioTrack:" + this._audioTrack);
            return -1;
        }
        try {
            this._audioTrack.play();
        }
        catch (IllegalStateException e) {
            QLog.e(TAG, "StartPlayback fail");
            e.printStackTrace();
            return -1;
        }
        if (this._context != null && (file = new File(filePath = this._context.getExternalFilesDir(null).getAbsolutePath() + "/trae-dump/WRITE_PCM.config")).exists()) {
            _dumpEnable = true;
        }
        if (_dumpEnable) {
            this._play_dump = new File(this.getDumpFilePath("jniplay.pcm", this._audioManager != null ? this._audioManager.getMode() : -1));
            try {
                this._play_out = new FileOutputStream(this._play_dump);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        this._isPlaying = true;
        QLog.w(TAG, "StartPlayback ok");
        return 0;
    }

    private int StopRecording() {
        QLog.w(TAG, "StopRecording entry");
        if (this._audioRecord == null) {
            QLog.e(TAG, "UnintRecord:" + this._audioRecord);
            return -1;
        }
        if (_startRecordRefuse) {
            QLog.e(TAG, "StopRecording _startRecordRefuse:" + _startRecordRefuse);
            return -1;
        }
        try {
            if (this._audioRecord.getRecordingState() == 3) {
                try {
                    QLog.w(TAG, "StopRecording stop... state:" + this._audioRecord.getRecordingState());
                    this._audioRecord.stop();
                }
                catch (IllegalStateException e) {
                    QLog.e(TAG, "StopRecording  err");
                    e.printStackTrace();
                    int n = -1;
                    this._audioManager.setMode(0);
                    return n;
                }
            }
            QLog.w(TAG, "StopRecording releaseing... state:" + this._audioRecord.getRecordingState());
            this._audioRecord.release();
            this._audioRecord = null;
            this._isRecording = false;
        }
        finally {
            this._audioManager.setMode(0);
        }
        QLog.w(TAG, "StopRecording exit ok");
        return 0;
    }

    private int StopPlayback() {
        QLog.w(TAG, "StopPlayback entry _isPlaying:" + this._isPlaying);
        if (this._audioTrack == null) {
            QLog.e(TAG, "StopPlayback _isPlaying:" + this._isPlaying + " " + this._audioTrack);
            return -1;
        }
        if (this._audioTrack.getPlayState() == 3) {
            try {
                QLog.w(TAG, "StopPlayback stoping...");
                this._audioTrack.stop();
            }
            catch (IllegalStateException e) {
                QLog.e(TAG, "StopPlayback err");
                e.printStackTrace();
                return -1;
            }
            QLog.w(TAG, "StopPlayback flushing... state:" + this._audioTrack.getPlayState());
            this._audioTrack.flush();
        }
        QLog.w(TAG, "StopPlayback releaseing... state:" + this._audioTrack.getPlayState());
        this._audioTrack.release();
        this._audioTrack = null;
        this._isPlaying = false;
        QLog.w(TAG, "StopPlayback exit ok");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int PlayAudio(int lengthInBytes) {
        int writeBytes;
        block33: {
            int bufferedSamples;
            block34: {
                boolean _needResetAudioTrack;
                block32: {
                    writeBytes = 0;
                    if (!this._isPlaying | this._audioTrack == null) {
                        QLog.e(TAG, "PlayAudio: _isPlaying " + this._isPlaying + " " + this._audioTrack);
                        return -1;
                    }
                    bufferedSamples = 0;
                    if (this._audioTrack != null) break block32;
                    int n = -2;
                    return n;
                }
                if (this._doPlayInit) {
                    try {
                        Process.setThreadPriority((int)-19);
                    }
                    catch (Exception e) {
                        QLog.w(TAG, "Set play thread priority failed: " + e.getMessage());
                    }
                    this._doPlayInit = false;
                }
                if (!this._audioRouteChanged) {
                    _needResetAudioTrack = false;
                } else {
                    if (this._audioManager == null && this._context != null) {
                        this._audioManager = (AudioManager)this._context.getSystemService("audio");
                    }
                    this._streamType = this._audioManager != null && this._audioManager.getMode() == 0 && this._connectedDev.equals("DEVICE_SPEAKERPHONE") ? 3 : 0;
                    _needResetAudioTrack = this._streamType != this._audioTrack.getStreamType();
                    this._audioRouteChanged = false;
                }
                this._playBuffer.get(this._tempBufPlay);
                if (_dumpEnable && this._play_out != null) {
                    try {
                        this._play_out.write(this._tempBufPlay, 0, lengthInBytes);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (_needResetAudioTrack) {
                    writeBytes = lengthInBytes;
                    this._playBuffer.rewind();
                    long lasttime = SystemClock.elapsedRealtime();
                    QLog.w(TAG, " track resting: _streamType:" + this._streamType + " at.st:" + this._audioTrack.getStreamType());
                    if (this._audioTrack.getPlayState() == 3) {
                        try {
                            QLog.w(TAG, "StopPlayback stoping...");
                            this._audioTrack.stop();
                            this._audioTrack.flush();
                            QLog.w(TAG, "StopPlayback flushing... state:" + this._audioTrack.getPlayState());
                            this._audioTrack.release();
                            QLog.w(TAG, "StopPlayback releaseing... state:" + this._audioTrack.getPlayState());
                            this._audioTrack = null;
                        }
                        catch (IllegalStateException e) {
                            QLog.e(TAG, "StopPlayback err");
                        }
                    }
                    int minPlayBufSize = AudioTrack.getMinBufferSize((int)this._playSamplerate, (int)this._channelOutType, (int)2);
                    int[] st = new int[]{0, 0, 3, 1};
                    st[0] = this._streamType;
                    int framesize = 20 * this._playSamplerate * 1 * 2 / 1000;
                    if (this._channelOutType == 12) {
                        framesize *= 2;
                    }
                    block16: for (int i = 0; i < st.length && this._audioTrack == null; ++i) {
                        this._streamType = st[i];
                        QLog.w(TAG, "InitPlayback: min play buf size is " + minPlayBufSize + " hw_sr:" + AudioTrack.getNativeOutputSampleRate((int)this._streamType));
                        for (int j = 1; j <= 2; ++j) {
                            int playBufSize = minPlayBufSize * j;
                            if (playBufSize < framesize * 4 && j < 2) continue;
                            try {
                                this._audioTrack = new AudioTrack(this._streamType, this._playSamplerate, this._channelOutType, 2, playBufSize, 1);
                            }
                            catch (Exception e) {
                                QLog.w(TAG, e.getMessage() + " _audioTrack:" + this._audioTrack);
                                if (this._audioTrack != null) {
                                    this._audioTrack.release();
                                }
                                this._audioTrack = null;
                                continue;
                            }
                            QLog.w(TAG, " _audioTrack:" + this._audioTrack);
                            if (this._audioTrack.getState() == 1) continue block16;
                            QLog.w(TAG, "InitPlayback: play not initialized playBufSize:" + playBufSize + " sr:" + this._playSamplerate);
                            this._audioTrack.release();
                            this._audioTrack = null;
                        }
                    }
                    if (this._audioTrack != null) {
                        try {
                            this._audioTrack.play();
                            this._as.voiceCallAudioParamChanged(this._audioManager.getMode(), this._streamType);
                            TraeAudioManager.forceVolumeControlStream(this._audioManager, this._connectedDev.equals("DEVICE_BLUETOOTHHEADSET") ? 6 : this._audioTrack.getStreamType());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    QLog.e(TAG, "  track reset used:" + (SystemClock.elapsedRealtime() - lasttime) + "ms");
                    break block33;
                }
                writeBytes = this._audioTrack.write(this._tempBufPlay, 0, lengthInBytes);
                this._playBuffer.rewind();
                if (writeBytes >= 0) break block34;
                QLog.e(TAG, "Could not write data from sc (write = " + writeBytes + ", length = " + lengthInBytes + ")");
                int lasttime = -1;
                return lasttime;
            }
            try {
                if (writeBytes != lengthInBytes) {
                    QLog.e(TAG, "Could not write all data from sc (write = " + writeBytes + ", length = " + lengthInBytes + ")");
                }
                this._bufferedPlaySamples += writeBytes >> 1;
                int pos = this._audioTrack.getPlaybackHeadPosition();
                if (pos < this._playPosition) {
                    this._playPosition = 0;
                }
                this._bufferedPlaySamples -= pos - this._playPosition;
                this._playPosition = pos;
                if (!this._isRecording) {
                    bufferedSamples = this._bufferedPlaySamples;
                }
            }
            catch (Exception e) {
                QLog.e(TAG, "PlayAudio Exception: " + e.getMessage());
            }
        }
        return writeBytes;
    }

    private int OpenslesNeedResetAudioTrack(boolean b_IsFirstStart) {
        block8: {
            block9: {
                block7: {
                    if (TraeAudioManager.isCloseSystemAPM(this._modePolicy)) break block7;
                    int n = -1;
                    return n;
                }
                if (!this._audioRouteChanged && !b_IsFirstStart) break block8;
                if (this._audioManager == null && this._context != null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                }
                if (this._audioManager != null) break block9;
                int n = 0;
                return n;
            }
            try {
                this._audioStreamTypePolicy = this._audioManager.getMode() == 0 && this._connectedDev.equals("DEVICE_SPEAKERPHONE") ? 3 : 0;
                this._audioRouteChanged = false;
            }
            catch (Exception e) {
                QLog.e(TAG, "PlayAudio Exception: " + e.getMessage());
            }
        }
        return this._audioStreamTypePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int RecordAudio(int lengthInBytes) {
        int readBytes;
        block15: {
            block14: {
                readBytes = 0;
                if (!this._isRecording) {
                    QLog.e(TAG, "RecordAudio: _isRecording " + this._isRecording);
                    return -1;
                }
                if (this._audioRecord != null) break block14;
                int n = -2;
                return n;
            }
            if (this._doRecInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception e) {
                    QLog.w(TAG, "Set rec thread priority failed: " + e.getMessage());
                }
                this._doRecInit = false;
            }
            this._recBuffer.rewind();
            readBytes = this._audioRecord.read(this._tempBufRec, 0, lengthInBytes);
            if (readBytes >= 0) break block15;
            QLog.e(TAG, "Could not read data from sc (read = " + readBytes + ", length = " + lengthInBytes + ")");
            int e = -1;
            return e;
        }
        try {
            this._recBuffer.put(this._tempBufRec, 0, readBytes);
            if (_dumpEnable && this._rec_out != null) {
                try {
                    this._rec_out.write(this._tempBufRec, 0, readBytes);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (readBytes != lengthInBytes) {
                QLog.e(TAG, "Could not read all data from sc (read = " + readBytes + ", length = " + lengthInBytes + ")");
                int e = -1;
                return e;
            }
        }
        catch (Exception e) {
            QLog.e(TAG, "RecordAudio Exception: " + e.getMessage());
        }
        return readBytes;
    }

    private int SetPlayoutVolume(int level) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int retVal = -1;
        if (this._audioManager != null) {
            this._audioManager.setStreamVolume(0, level, 0);
            retVal = 0;
        }
        return retVal;
    }

    private int GetPlayoutVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int level = -1;
        if (this._audioManager != null) {
            level = this._audioManager.getStreamVolume(0);
        }
        return level;
    }

    public static String getTraceInfo() {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stacks = new Throwable().getStackTrace();
        int stacksLen = stacks.length;
        sb.append("").append(stacks[2].getClassName()).append(".").append(stacks[2].getMethodName()).append(": ").append(stacks[2].getLineNumber());
        return sb.toString();
    }

    public static final void LogTraceEntry(String msg) {
        if (!_logEnable) {
            return;
        }
        String str = AudioDeviceInterface.getTraceInfo() + " entry:" + msg;
        QLog.w(TAG, str);
    }

    public static final void LogTraceExit() {
        if (!_logEnable) {
            return;
        }
        String str = AudioDeviceInterface.getTraceInfo() + " exit";
        QLog.w(TAG, str);
    }

    private void onOutputChanage(String strDeviceName) {
        QLog.w(TAG, " onOutputChanage:" + strDeviceName);
        this.setAudioRouteSwitchState(strDeviceName);
        if (!TraeAudioManager.isCloseSystemAPM(this._modePolicy)) {
            return;
        }
        if (this._deviceStat == 1 || this._deviceStat == 5 || this._deviceStat == 2 || this._deviceStat == 3) {
            return;
        }
        this._connectedDev = strDeviceName;
        QLog.w(TAG, " onOutputChanage:" + strDeviceName + (this._audioManager == null ? " am==null" : " mode:" + this._audioManager.getMode()) + " st:" + this._streamType + (this._audioTrack == null ? "_audioTrack==null" : " at.st:" + this._audioTrack.getStreamType()));
        try {
            if (this._audioManager == null) {
                this._audioManager = (AudioManager)this._context.getSystemService("audio");
            }
            QLog.w(TAG, " curr mode:" + strDeviceName + (this._audioManager == null ? "am==null" : " mode:" + this._audioManager.getMode()));
            if (this._audioManager != null && this._connectedDev.equals("DEVICE_SPEAKERPHONE")) {
                this._audioManager.setMode(0);
            }
        }
        catch (Exception e) {
            QLog.w(TAG, e.getMessage());
        }
        this._audioRouteChanged = true;
    }

    @SuppressLint(value={"NewApi"})
    public int requestRecordPermission() {
        if (!this.IsContainRecordAbility()) {
            QLog.w(TAG, "audience not need record permission");
            return -1;
        }
        try {
            QLog.w(TAG, "requestRecordPermission");
            if (this._context != null) {
                SharedPreferences _sharedPrefrences = this._context.getSharedPreferences("GMEApplyForAudioRecord", 0);
                SharedPreferences.Editor edit = _sharedPrefrences.edit();
                edit.putInt("GMEApplyForAudioRecord", 1);
                edit.apply();
                String recordAudioStr = "android.permission.RECORD_AUDIO";
                if (weatherRequest == 0 && ClientInfo.VERSION_SDK_INT >= 23 && this._context instanceof Activity) {
                    weatherRequest = 1;
                    Activity mActivity = (Activity)this._context;
                    if (mActivity.checkSelfPermission(recordAudioStr) != 0) {
                        String[] permissions = new String[]{recordAudioStr};
                        mActivity.requestPermissions(permissions, 101);
                    }
                }
            }
        }
        catch (Exception e) {
            QLog.e(TAG, "requestPermissions error");
        }
        return 0;
    }

    private int reConnectDevice() {
        String re_connect_device_ = "DEVICE_NONE";
        re_connect_device_ = lastSwitchState == 1 ? "DEVICE_EARPHONE" : (lastSwitchState == 2 ? "DEVICE_SPEAKERPHONE" : (lastSwitchState == 3 ? "DEVICE_WIREDHEADSET" : (lastSwitchState == 4 ? "DEVICE_BLUETOOTHHEADSET" : "DEVICE_NONE")));
        if (this._as != null) {
            if (re_connect_device_.equals("DEVICE_NONE")) {
                QLog.w(TAG, "TraeAudioSession connectHighestPriorityDevice ");
                this._as.connectHighestPriorityDevice();
            } else {
                QLog.w(TAG, "TraeAudioSession reConnectDevice ");
                this._as.forceConnectDevice(re_connect_device_);
            }
        } else {
            return -1;
        }
        return 0;
    }

    public int call_preprocess() {
        AudioDeviceInterface.LogTraceEntry("");
        this.requestRecordPermission();
        this.switchState = 0;
        this._streamType = TraeAudioManager.getAudioStreamType(this._audioStreamTypePolicy);
        if (this._as == null) {
            this._as = new TraeAudioSession(this._context, new TraeAudioSession.ITraeAudioCallback(){

                @Override
                public void onServiceStateUpdate(boolean on) {
                    if (!on) {
                        try {
                            AudioDeviceInterface.this._prelock.lock();
                            AudioDeviceInterface.this._preDone = true;
                            QLog.e(AudioDeviceInterface.TAG, "onServiceStateUpdate signalAll");
                            AudioDeviceInterface.this._precon.signalAll();
                            AudioDeviceInterface.this._prelock.unlock();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }

                @Override
                public void onDeviceListUpdate(String[] strDeviceList, String strConnectedDeviceName, String strPrevConnectedDeviceName, String strBluetoothNameIFHAS) {
                    AudioDeviceInterface.access$302(strDeviceList);
                    if (AudioDeviceInterface.this.usingJava) {
                        AudioDeviceInterface.this.onOutputChanage(strConnectedDeviceName);
                    }
                }

                @Override
                public void onDeviceChangabledUpdate(boolean bCanChangabled) {
                }

                @Override
                public void onGetDeviceListRes(int err, String[] strDeviceList, String strConnectedDeviceName, String strPrevConnectedDeviceName, String strBluetoothNameIFHAS) {
                    AudioDeviceInterface.access$302(strDeviceList);
                }

                @Override
                public void onConnectDeviceRes(int err, String strDeviceName, boolean bIsConnected) {
                }

                @Override
                public void onIsDeviceChangabledRes(int err, boolean bCanChangabled) {
                }

                @Override
                public void onGetConnectedDeviceRes(int err, String strDeviceName) {
                    if (err == 0) {
                        AudioDeviceInterface.this.onOutputChanage(strDeviceName);
                    }
                }

                @Override
                public void onGetConnectingDeviceRes(int err, String strDeviceName) {
                }

                @Override
                public void onRingCompletion(int err, String userData) {
                }

                @Override
                public void onStreamTypeUpdate(int streamType) {
                }

                @Override
                public void onGetStreamTypeRes(int err, int streamType) {
                }

                @Override
                public void onVoicecallPreprocessRes(int err) {
                    try {
                        AudioDeviceInterface.this._prelock.lock();
                        AudioDeviceInterface.this._preDone = true;
                        QLog.e(AudioDeviceInterface.TAG, "onVoicecallPreprocessRes signalAll");
                        AudioDeviceInterface.this._precon.signalAll();
                        AudioDeviceInterface.this._prelock.unlock();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void onAudioRouteSwitchStart(String fromDev, String toDev) {
                }

                @Override
                public void onAudioRouteSwitchEnd(String connectedDev, long timeMs) {
                }
            });
        }
        this._preDone = false;
        if (this._as != null) {
            this._prelock.lock();
            try {
                int i;
                if (this._audioManager == null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                }
                if (this._audioManager != null) {
                    if (this._audioManager.getMode() == 2) {
                        i = 5;
                        while (i-- > 0 && this._audioManager.getMode() == 2) {
                            QLog.e(TAG, "call_preprocess waiting...  mode:" + this._audioManager.getMode());
                            Thread.sleep(500L);
                        }
                    }
                    if (this._audioManager.isMicrophoneMute()) {
                        this._audioManager.setMicrophoneMute(false);
                        QLog.e(TAG, "media call_preprocess setMicrophoneMute false");
                    }
                }
                this._as.voiceCallPreprocess(this._modePolicy, this._streamType);
                TraeAudioManager.IsUpdateSceneFlag = true;
                this.reConnectDevice();
                try {
                    i = 7;
                    while (i-- > 0 && !this._preDone) {
                        this._precon.await(1L, TimeUnit.SECONDS);
                        QLog.e(TAG, "call_preprocess waiting...  as:" + (Object)((Object)this._as));
                    }
                    QLog.e(TAG, "call_preprocess done!");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this._as.getConnectedDevice();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this._prelock.unlock();
            }
        }
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public int call_postprocess() {
        AudioDeviceInterface.LogTraceEntry("");
        this.switchState = 0;
        if (this._as != null) {
            this._as.voiceCallPostprocess();
            this._as.release();
            this._as = null;
        }
        TraeAudioManager.IsUpdateSceneFlag = false;
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public int call_preprocess_media() {
        AudioDeviceInterface.LogTraceEntry("");
        this.requestRecordPermission();
        this.switchState = 0;
        if (mVivoKTVHelper != null && isSupportVivoKTVHelper) {
            mVivoKTVHelper.openKTVDevice();
            mVivoKTVHelper.setPreModeParam(1);
            mVivoKTVHelper.setPlayFeedbackParam(1);
            mVivoKTVHelper.setPlayFeedbackParam(0);
        }
        if (this._as == null) {
            this._as = new TraeAudioSession(this._context, new TraeAudioSession.ITraeAudioCallback(){

                @Override
                public void onServiceStateUpdate(boolean on) {
                }

                @Override
                public void onDeviceListUpdate(String[] strDeviceList, String strConnectedDeviceName, String strPrevConnectedDeviceName, String strBluetoothNameIFHAS) {
                    AudioDeviceInterface.access$302(strDeviceList);
                    if (AudioDeviceInterface.this.usingJava) {
                        AudioDeviceInterface.this.onOutputChanage(strConnectedDeviceName);
                    }
                }

                @Override
                public void onDeviceChangabledUpdate(boolean bCanChangabled) {
                }

                @Override
                public void onGetDeviceListRes(int err, String[] strDeviceList, String strConnectedDeviceName, String strPrevConnectedDeviceName, String strBluetoothNameIFHAS) {
                    AudioDeviceInterface.access$302(strDeviceList);
                }

                @Override
                public void onConnectDeviceRes(int err, String strDeviceName, boolean bIsConnected) {
                }

                @Override
                public void onIsDeviceChangabledRes(int err, boolean bCanChangabled) {
                }

                @Override
                public void onGetConnectedDeviceRes(int err, String strDeviceName) {
                    if (err == 0) {
                        AudioDeviceInterface.this.onOutputChanage(strDeviceName);
                    }
                }

                @Override
                public void onGetConnectingDeviceRes(int err, String strDeviceName) {
                }

                @Override
                public void onRingCompletion(int err, String userData) {
                }

                @Override
                public void onStreamTypeUpdate(int streamType) {
                }

                @Override
                public void onGetStreamTypeRes(int err, int streamType) {
                }

                @Override
                public void onVoicecallPreprocessRes(int err) {
                }

                @Override
                public void onAudioRouteSwitchStart(String fromDev, String toDev) {
                }

                @Override
                public void onAudioRouteSwitchEnd(String connectedDev, long timeMs) {
                }
            });
        }
        if (this._as != null) {
            try {
                if (this._audioManager == null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                }
                if (this._audioManager != null) {
                    if (this._audioManager.getMode() == 2) {
                        int i = 5;
                        while (i-- > 0 && this._audioManager.getMode() == 2) {
                            QLog.e(TAG, "media call_preprocess_media waiting...  mode:" + this._audioManager.getMode());
                            Thread.sleep(500L);
                        }
                    }
                    if (this._deviceStat == 7) {
                        if (this._audioManager.getMode() != 3) {
                            QLog.w(TAG, "call_preprocess_media _audioManager setMode 3");
                            this._audioManager.setMode(3);
                        }
                    } else if (this._audioManager.getMode() != 0) {
                        QLog.w(TAG, "call_preprocess_media _audioManager setMode 0");
                        this._audioManager.setMode(0);
                    }
                    if (this._audioManager.isMicrophoneMute()) {
                        this._audioManager.setMicrophoneMute(false);
                        QLog.e(TAG, "media call_preprocess_media setMicrophoneMute false");
                    }
                }
                TraeAudioManager.IsUpdateSceneFlag = true;
                this.reConnectDevice();
                this._as.getConnectedDevice();
                QLog.e(TAG, "call_preprocess_media done!");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public int call_postprocess_media() {
        AudioDeviceInterface.LogTraceEntry("");
        this.switchState = 0;
        if (this._as != null) {
            this._as.release();
            this._as = null;
        }
        TraeAudioManager.IsUpdateSceneFlag = false;
        if (mVivoKTVHelper != null && isSupportVivoKTVHelper) {
            mVivoKTVHelper.closeKTVDevice();
        }
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public void setJavaInterface(int flg) {
        this.usingJava = flg != 0;
        QLog.w(TAG, "setJavaInterface flg:" + flg);
    }

    private void setAudioRouteSwitchState(String strDeviceName) {
        this.switchState = strDeviceName.equals("DEVICE_EARPHONE") ? 1 : (strDeviceName.equals("DEVICE_SPEAKERPHONE") ? 2 : (strDeviceName.equals("DEVICE_WIREDHEADSET") ? 3 : (strDeviceName.equals("DEVICE_BLUETOOTHHEADSET") ? 4 : 0)));
        lastSwitchState = this.switchState;
    }

    public int getAudioRouteSwitchState() {
        return this.switchState;
    }

    private void initTRAEAudioManager() {
        lastSwitchState = 0;
        if (this._context != null) {
            TraeAudioManager.init(this._context);
            QLog.w(TAG, "initTRAEAudioManager , TraeAudioSession create");
            if (this._asAudioManager == null) {
                this._asAudioManager = new TraeAudioSession(this._context, new TraeAudioSession.ITraeAudioCallback(){

                    @Override
                    public void onServiceStateUpdate(boolean on) {
                    }

                    @Override
                    public void onDeviceListUpdate(String[] strDeviceList, String strConnectedDeviceName, String strPrevConnectedDeviceName, String strBluetoothNameIFHAS) {
                        AudioDeviceInterface.access$302(strDeviceList);
                        if (AudioDeviceInterface.this.usingJava) {
                            AudioDeviceInterface.this.onOutputChanage(strConnectedDeviceName);
                        }
                    }

                    @Override
                    public void onDeviceChangabledUpdate(boolean bCanChangabled) {
                    }

                    @Override
                    public void onGetDeviceListRes(int err, String[] strDeviceList, String strConnectedDeviceName, String strPrevConnectedDeviceName, String strBluetoothNameIFHAS) {
                        AudioDeviceInterface.access$302(strDeviceList);
                    }

                    @Override
                    public void onConnectDeviceRes(int err, String strDeviceName, boolean bIsConnected) {
                    }

                    @Override
                    public void onIsDeviceChangabledRes(int err, boolean bCanChangabled) {
                    }

                    @Override
                    public void onGetConnectedDeviceRes(int err, String strDeviceName) {
                        if (err == 0) {
                            AudioDeviceInterface.this.onOutputChanage(strDeviceName);
                        }
                    }

                    @Override
                    public void onGetConnectingDeviceRes(int err, String strDeviceName) {
                    }

                    @Override
                    public void onRingCompletion(int err, String userData) {
                    }

                    @Override
                    public void onStreamTypeUpdate(int streamType) {
                    }

                    @Override
                    public void onGetStreamTypeRes(int err, int streamType) {
                    }

                    @Override
                    public void onVoicecallPreprocessRes(int err) {
                    }

                    @Override
                    public void onAudioRouteSwitchStart(String fromDev, String toDev) {
                    }

                    @Override
                    public void onAudioRouteSwitchEnd(String connectedDev, long timeMs) {
                    }
                });
            }
        }
    }

    private int startService(String deviceConfig) {
        QLog.w(TAG, "TraeAudioSession startService: " + (Object)((Object)this._asAudioManager) + " deviceConfig:" + deviceConfig);
        if (this._asAudioManager != null) {
            return this._asAudioManager.startService(deviceConfig);
        }
        return -1;
    }

    private int stopService() {
        QLog.w(TAG, "TraeAudioSession stopService: " + (Object)((Object)this._asAudioManager));
        if (this._asAudioManager != null) {
            return this._asAudioManager.stopService();
        }
        return -1;
    }

    private int SetAudioOutputMode(int outputMode) {
        QLog.w(TAG, "TraeAudioSession SetAudioOutputMode: " + outputMode);
        if (0 == outputMode) {
            if (null == mDeviceList || null == this._asAudioManager) {
                return -1;
            }
            boolean isSwitched = false;
            block0: do {
                int i;
                for (i = 0; i < mDeviceList.length && !isSwitched; ++i) {
                    if (!"DEVICE_WIREDHEADSET".equals(mDeviceList[i])) continue;
                    this._asAudioManager.connectDevice("DEVICE_WIREDHEADSET");
                    isSwitched = true;
                    break;
                }
                for (i = 0; i < mDeviceList.length && !isSwitched; ++i) {
                    if (!"DEVICE_BLUETOOTHHEADSET".equals(mDeviceList[i])) continue;
                    this._asAudioManager.connectDevice("DEVICE_BLUETOOTHHEADSET");
                    isSwitched = true;
                    break;
                }
                for (i = 0; i < mDeviceList.length && !isSwitched; ++i) {
                    if (!"DEVICE_EARPHONE".equals(mDeviceList[i])) continue;
                    this._asAudioManager.connectDevice("DEVICE_EARPHONE");
                    isSwitched = true;
                    continue block0;
                }
            } while (!isSwitched);
        } else {
            if (1 == outputMode) {
                if (this._asAudioManager == null) {
                    return -1;
                }
                this._asAudioManager.connectDevice("DEVICE_SPEAKERPHONE");
                return 0;
            }
            return -1;
        }
        return 0;
    }

    private int getAndroidSdkVersion() {
        return ClientInfo.VERSION_SDK_INT;
    }

    public int getNumberOfCPUCores() {
        int cores;
        if (ClientInfo.VERSION_SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
        }
        catch (SecurityException e) {
            cores = -1;
        }
        catch (NullPointerException e) {
            cores = -1;
        }
        return cores;
    }

    static boolean isHardcodeOpenSles() {
        if (ClientInfo.MANUFACTURER.equals("Xiaomi")) {
            if (ClientInfo.MODEL.equals("MI 5")) {
                return true;
            }
            if (ClientInfo.MODEL.equals("MI 5s")) {
                return true;
            }
            if (ClientInfo.MODEL.equals("MI 5s Plus")) {
                return true;
            }
        } else if (ClientInfo.MANUFACTURER.equals("samsung") && ClientInfo.MODEL.equals("SM-G9350")) {
            return true;
        }
        return false;
    }

    private int isSupportLowLatency() {
        return 0;
    }

    private int isSupportVivoKTVHelper() {
        if (this._context != null && (mVivoKTVHelper = VivoKTVHelper.getInstance(this._context)) != null) {
            isSupportVivoKTVHelper = mVivoKTVHelper.isDeviceSupportKaraoke();
        }
        return isSupportVivoKTVHelper ? 1 : 0;
    }

    private int EnableVivoKTVLoopback(int state) {
        QLog.w(TAG, "EnableVivoKTVLoopback: " + state + " isSupportVivoKTVHelper:" + isSupportVivoKTVHelper + " mVivoKTVHelper:" + mVivoKTVHelper);
        if (mVivoKTVHelper != null && isSupportVivoKTVHelper) {
            mVivoKTVHelper.setPlayFeedbackParam(state);
            return 0;
        }
        return -1;
    }

    private int isVivoKTVLoopback() {
        if (mVivoKTVHelper != null && isSupportVivoKTVHelper) {
            return mVivoKTVHelper.getPlayFeedbackParam();
        }
        return 0;
    }

    private void uninitTRAEAudioManager() {
        if (this._context != null) {
            QLog.w(TAG, "uninitTRAEAudioManager , stopService");
            if (this._asAudioManager != null) {
                this._asAudioManager.stopService();
                this._asAudioManager.release();
                this._asAudioManager = null;
            }
        } else {
            QLog.w(TAG, "uninitTRAEAudioManager , context null");
        }
    }

    static /* synthetic */ String[] access$302(String[] x0) {
        mDeviceList = x0;
        return x0;
    }
}

