/*
 * Decompiled with CFR 0.152.
 */
package com.gme.sharpgme.jni;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.util.Log;
import com.gme.av.utils.ClientInfo;
import com.gme.av.utils.QLog;
import com.gme.sharpgme.jni.RingBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AudioDecoder {
    private static final String TAG = "AudioDecoder";
    private String srcPath;
    private MediaCodec mediaDecode = null;
    private MediaExtractor mediaExtractor = null;
    private ByteBuffer[] decodeInputBuffers = null;
    private ByteBuffer[] decodeOutputBuffers = null;
    private MediaCodec.BufferInfo decodeBufferInfo = null;
    private OnCompleteListener onCompleteListener = null;
    private OnProgressListener onProgressListener = null;
    private long fileTotalMs = 0L;
    private RingBuffer decRingBuffer = null;
    int sampleRate = 0;
    int channels = 0;
    int nFrameSize = 3840;
    boolean IsTenFramesReady = false;
    int nFirstThreeFrameInfo = 3;
    int m_nIndex = 0;
    private boolean codeOver = true;

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public long getFileTotalMs() {
        return this.fileTotalMs;
    }

    public int getFrameSize() {
        return this.nFrameSize;
    }

    public void setIOPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public void setIndex(int index) {
        this.m_nIndex = index;
    }

    public int prepare(int frame) {
        if (this.srcPath == null) {
            return -1;
        }
        return this.initMediaDecode(frame);
    }

    @SuppressLint(value={"NewApi"})
    private int initMediaDecode(int frame) {
        try {
            this.mediaExtractor = new MediaExtractor();
            this.mediaExtractor.setDataSource(this.srcPath);
            if (this.mediaExtractor.getTrackCount() > 1) {
                QLog.w(TAG, "m_nIndex: " + this.m_nIndex + " initMediaDecode mediaExtractor container video, getTrackCount: " + this.mediaExtractor.getTrackCount());
                this.codeOver = true;
                return -2;
            }
            for (int i = 0; i < this.mediaExtractor.getTrackCount(); ++i) {
                MediaFormat format = this.mediaExtractor.getTrackFormat(i);
                String mime = format.getString("mime");
                QLog.w(TAG, "m_nIndex: " + this.m_nIndex + " initMediaDecode mediaExtractor audio type:" + mime);
                if (!mime.startsWith("audio/mpeg")) continue;
                this.mediaExtractor.selectTrack(i);
                this.mediaDecode = MediaCodec.createDecoderByType((String)mime);
                this.mediaDecode.configure(format, null, null, 0);
                this.sampleRate = format.getInteger("sample-rate");
                this.channels = format.getInteger("channel-count");
                long duration = format.getLong("durationUs");
                this.fileTotalMs = duration / 1000L;
                this.nFrameSize = this.sampleRate * this.channels * 2 * 20 / 1000;
                this.decRingBuffer = new RingBuffer(frame * this.nFrameSize);
                QLog.w(TAG, "m_nIndex: " + this.m_nIndex + " initMediaDecode open succeed, mp3 format:(" + this.sampleRate + "," + this.channels + "), fileTotalMs:" + this.fileTotalMs + "ms RingBufferFrame:" + frame);
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.codeOver = true;
            return -1;
        }
        if (this.mediaDecode == null) {
            Log.e((String)TAG, (String)("m_nIndex: " + this.m_nIndex + " initMediaDecode create mediaDecode failed"));
            this.codeOver = true;
            return -1;
        }
        if (this.decRingBuffer == null) {
            Log.e((String)TAG, (String)("m_nIndex: " + this.m_nIndex + " initMediaDecode create decRingBuffer failed"));
            this.codeOver = true;
            return -1;
        }
        this.mediaDecode.start();
        this.decodeInputBuffers = this.mediaDecode.getInputBuffers();
        this.decodeOutputBuffers = this.mediaDecode.getOutputBuffers();
        this.decodeBufferInfo = new MediaCodec.BufferInfo();
        this.codeOver = false;
        this.IsTenFramesReady = false;
        this.nFirstThreeFrameInfo = 3;
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    private void srcAudioFormatToPCM() {
        try {
            if (this.decodeInputBuffers.length <= 1) {
                QLog.w(TAG, "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM decodeInputBuffers.length to small," + this.decodeInputBuffers.length);
                this.codeOver = true;
                return;
            }
            int inputIndex = this.mediaDecode.dequeueInputBuffer(200L);
            if (inputIndex < 0) {
                QLog.w(TAG, "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM decodeInputBuffers.inputIndex <0");
                this.codeOver = true;
                return;
            }
            int version = ClientInfo.VERSION_SDK_INT;
            ByteBuffer inputBuffer = version >= 21 ? this.mediaDecode.getInputBuffer(inputIndex) : this.decodeInputBuffers[inputIndex];
            inputBuffer.clear();
            int sampleSize = this.mediaExtractor.readSampleData(inputBuffer, 0);
            if (sampleSize < 0) {
                QLog.w(TAG, "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM readSampleData over,end");
                this.codeOver = true;
            } else {
                this.mediaDecode.queueInputBuffer(inputIndex, 0, sampleSize, 0L, 0);
                this.mediaExtractor.advance();
            }
            int outputIndex = this.mediaDecode.dequeueOutputBuffer(this.decodeBufferInfo, 10000L);
            while (outputIndex >= 0) {
                ByteBuffer outputBuffer = version >= 21 ? this.mediaDecode.getOutputBuffer(outputIndex) : this.decodeOutputBuffers[outputIndex];
                byte[] chunkPCM = new byte[this.decodeBufferInfo.size];
                try {
                    outputBuffer.get(chunkPCM);
                }
                catch (Exception e) {
                    QLog.w(TAG, "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM wrong outputIndex: " + outputIndex);
                    this.codeOver = true;
                    return;
                }
                outputBuffer.clear();
                if (this.decRingBuffer != null && this.decodeBufferInfo.size > 0) {
                    this.decRingBuffer.Push(chunkPCM, this.decodeBufferInfo.size);
                    if (this.nFirstThreeFrameInfo-- > 0) {
                        QLog.w(TAG, "m_nIndex: " + this.m_nIndex + " DecodeOneFrame size: " + this.decodeBufferInfo.size + " Remain: " + this.decRingBuffer.RemainRead() / this.nFrameSize);
                    }
                }
                this.mediaDecode.releaseOutputBuffer(outputIndex, false);
                if (this.decodeBufferInfo.size <= 0) {
                    outputIndex = this.mediaDecode.dequeueOutputBuffer(this.decodeBufferInfo, 10000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"NewApi"})
    public int SeekTo(int timeMs) {
        if (this.mediaExtractor != null) {
            long t1 = this.mediaExtractor.getSampleTime();
            QLog.w(TAG, "m_nIndex: " + this.m_nIndex + " current PlayMs: " + t1 / 1000L + " SeekTo: " + (timeMs += this.decRingBuffer.RemainRead() * 20 / this.nFrameSize));
            this.mediaExtractor.seekTo((long)(timeMs * 1000), 2);
            long t2 = this.mediaExtractor.getSampleTime();
            int seekTime = (int)((t2 - t1) / 1000L);
            QLog.w(TAG, "m_nIndex: " + this.m_nIndex + " total SeekTo time: " + seekTime + " t2:" + t2 / 1000L);
            return seekTime;
        }
        return 0;
    }

    public int ReadOneFrame(byte[] pBuf, int nLen) {
        int i;
        int nReadLen = -1;
        if (!this.IsTenFramesReady) {
            i = 20;
            while (this.decRingBuffer.RemainRead() / this.nFrameSize < 10 && i-- > 0 && !this.codeOver) {
                this.srcAudioFormatToPCM();
            }
            QLog.w(TAG, "m_nIndex: " + this.m_nIndex + " 10 FramesReady Remain frame: " + this.decRingBuffer.RemainRead() / this.nFrameSize);
            this.IsTenFramesReady = true;
        }
        i = 20;
        while (!this.codeOver && this.decRingBuffer.RemainRead() / this.nFrameSize < 10 && i-- > 0) {
            this.srcAudioFormatToPCM();
        }
        if (this.decRingBuffer.RemainRead() >= nLen) {
            this.decRingBuffer.Pop(pBuf, nLen);
            nReadLen = nLen;
        }
        return nReadLen;
    }

    @SuppressLint(value={"NewApi"})
    public void release() {
        try {
            QLog.w(TAG, "release mediaDecode");
            if (this.mediaDecode != null) {
                this.mediaDecode.stop();
                this.mediaDecode.release();
                this.mediaDecode = null;
            }
            if (this.mediaExtractor != null) {
                this.mediaExtractor.release();
                this.mediaExtractor = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.onCompleteListener != null) {
            this.onCompleteListener = null;
        }
        if (this.onProgressListener != null) {
            this.onProgressListener = null;
        }
    }

    public void setOnCompleteListener(OnCompleteListener onCompleteListener) {
        this.onCompleteListener = onCompleteListener;
    }

    public void setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
    }

    private void showLog(String msg) {
        Log.e((String)"AudioCodec", (String)msg);
    }

    public static interface OnProgressListener {
        public void progress();
    }

    public static interface OnCompleteListener {
        public void completed();
    }
}

