/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.utils;

import android.text.TextUtils;
import com.gme.av.ptt.SHA1Utils;
import com.gme.av.sdk.HttpParam;
import com.gme.av.utils.FileTransferUtils;
import com.gme.av.utils.QLog;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class S3FileTransfer {
    public static final String TAG = "S3FileTransfer";

    public static void uploadFile(final String srcPath, final String strUrl, final HttpParam params, final Object userData, final FileTransferUtils.UploadFileListener listener) {
        Thread fetchTask = new Thread(new Runnable(){

            @Override
            public void run() {
                FileInputStream fis = null;
                HttpURLConnection conn = null;
                OutputStream out = null;
                BufferedReader reader = null;
                int errCode = 0;
                Object fileID = null;
                String uploadResult = "";
                File srcFile = FileTransferUtils.openFile(srcPath);
                if (srcFile == null) {
                    errCode = 8193;
                } else {
                    String sha1 = SHA1Utils.getFileSHA1(srcPath);
                    try {
                        fis = new FileInputStream(srcFile);
                        URL url = new URL(strUrl);
                        conn = (HttpURLConnection)url.openConnection();
                        conn.setConnectTimeout(5000);
                        conn.setReadTimeout(30000);
                        conn.setDoOutput(true);
                        conn.setDoInput(true);
                        conn.setUseCaches(false);
                        conn.setRequestMethod("PUT");
                        conn.setRequestProperty("Connection", "Keep-Alive");
                        conn.setRequestProperty("Content-Length", srcFile.length() + "");
                        conn.setRequestProperty("Authorization", params.signature);
                        conn.setRequestProperty("x-amz-date", params.date);
                        conn.setRequestProperty("x-amz-content-sha256", "UNSIGNED-PAYLOAD");
                        out = new DataOutputStream(conn.getOutputStream());
                        int bytes = 0;
                        byte[] bufferOut = new byte[1024];
                        while ((bytes = fis.read(bufferOut)) != -1) {
                            out.write(bufferOut, 0, bytes);
                        }
                        int rcode = conn.getResponseCode();
                        QLog.e(S3FileTransfer.TAG, "uploadFileImpl|rcode=" + rcode);
                        if (rcode != 200) {
                            QLog.e(S3FileTransfer.TAG, "uploadFileImpl|upload file failed. http response code =" + rcode);
                            errCode = 8195;
                        }
                    }
                    catch (UnknownHostException e) {
                        QLog.e(S3FileTransfer.TAG, "uploadFileImpl|upload file failed. neteork is invalid.");
                        errCode = 8195;
                        e.printStackTrace();
                        QLog.e(S3FileTransfer.TAG, e.getMessage());
                    }
                    catch (IOException e) {
                        QLog.e(S3FileTransfer.TAG, "uploadFileImpl|upload file failed. io exception. path=" + srcPath);
                        errCode = 8193;
                        QLog.e(S3FileTransfer.TAG, e.getMessage());
                        e.printStackTrace();
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        QLog.e(S3FileTransfer.TAG, e.getMessage());
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        QLog.e(S3FileTransfer.TAG, e.getMessage());
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        QLog.e(S3FileTransfer.TAG, e.getMessage());
                    }
                }
                if (conn != null) {
                    conn.disconnect();
                }
                if (listener != null) {
                    listener.onCompleted(errCode, uploadResult, userData);
                }
            }
        });
        fetchTask.start();
    }

    public static void downloadFile(final String downloadUrl, final String savePath, final HttpParam params, final Object userData, final FileTransferUtils.DownloadFileListener listener) {
        Thread downloadTask = new Thread(new Runnable(){

            @Override
            public void run() {
                int errCode;
                HttpURLConnection connection;
                InputStream is;
                FileOutputStream fos;
                block23: {
                    fos = null;
                    is = null;
                    connection = null;
                    errCode = 0;
                    if (TextUtils.isEmpty((CharSequence)downloadUrl)) {
                        QLog.i(S3FileTransfer.TAG, "downloadFileImpl| file url is empty.");
                        errCode = 12292;
                    } else if (TextUtils.isEmpty((CharSequence)savePath)) {
                        QLog.i(S3FileTransfer.TAG, "downloadFileImpl| save path is empty.");
                        errCode = 12289;
                    } else {
                        try {
                            URL url = new URL(downloadUrl);
                            connection = (HttpURLConnection)url.openConnection();
                            connection.setRequestMethod("GET");
                            connection.setRequestProperty("Connection", "Keep-Alive");
                            connection.setRequestProperty("Authorization", params.signature);
                            connection.setRequestProperty("x-amz-date", params.date);
                            connection.setRequestProperty("x-amz-content-sha256", "UNSIGNED-PAYLOAD");
                            int code = connection.getResponseCode();
                            if (code == 200) {
                                File file = new File(savePath);
                                if (!file.exists()) {
                                    file.createNewFile();
                                }
                                fos = new FileOutputStream(file);
                                is = connection.getInputStream();
                                byte[] buffer = new byte[1024];
                                int length = 0;
                                try {
                                    is = connection.getInputStream();
                                }
                                catch (IOException e) {
                                    QLog.i(S3FileTransfer.TAG, "downloadFileImpl|download file failed. neteork is invalid.");
                                    errCode = 12291;
                                    e.printStackTrace();
                                    break block23;
                                }
                                while ((length = is.read(buffer)) != -1) {
                                    fos.write(buffer, 0, length);
                                }
                                break block23;
                            }
                            QLog.i(S3FileTransfer.TAG, "downloadFileImpl| errCode=" + code);
                            if (code == 404) {
                                errCode = 12292;
                                QLog.i(S3FileTransfer.TAG, "downloadFileImpl| remote file is not exist. url=" + downloadUrl);
                            } else {
                                errCode = 12291;
                                QLog.i(S3FileTransfer.TAG, "downloadFileImpl| network invalid. url=" + downloadUrl);
                            }
                        }
                        catch (MalformedURLException e) {
                            errCode = 12292;
                            QLog.i(S3FileTransfer.TAG, "downloadFileImpl| remote file is not exist. url=" + downloadUrl);
                            QLog.e(S3FileTransfer.TAG, e.getMessage());
                            e.printStackTrace();
                        }
                        catch (UnknownHostException e) {
                            errCode = 12291;
                            QLog.i(S3FileTransfer.TAG, "downloadFileImpl| download file failed. neteork is invalid.");
                            QLog.e(S3FileTransfer.TAG, e.getMessage());
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            errCode = 12289;
                            QLog.i(S3FileTransfer.TAG, "downloadFileImpl| write file faile. path=" + savePath);
                            QLog.e(S3FileTransfer.TAG, e.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        QLog.e(S3FileTransfer.TAG, e.getMessage());
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        QLog.e(S3FileTransfer.TAG, e.getMessage());
                        e.printStackTrace();
                    }
                }
                if (connection != null) {
                    connection.disconnect();
                }
                if (listener != null) {
                    listener.onCompleted(errCode, userData);
                }
            }
        });
        downloadTask.start();
    }
}

