/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.utils;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.gme.av.utils.ClientInfo;
import com.gme.av.utils.QLog;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Executor;

public class PhoneStateManager
extends PhoneStateListener {
    private static final String TAG = "PhoneStateManager";
    private TelephonyManager mTelephonyManager;
    private AudioManager mAudioManager;
    private PhoneStatusListener mAudioStateListener;
    private Class<?> mOnModeChangedListenerClass;
    private Object mOnModeChangedListenerProxyInstance;
    Context mContext;
    private int mCurrentCallState = 0;
    private boolean mInterrupt = false;
    Handler mMainHandler;
    private boolean mTimerRunning = false;
    private int mLastMode = 0;
    private final long TIMER_INTERVAL = 1000L;
    private final Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            PhoneStatusListener phoneStatusListener = PhoneStateManager.this.mAudioStateListener;
            if (PhoneStateManager.this.mTimerRunning && phoneStatusListener != null) {
                int mode = PhoneStateManager.this.mLastMode;
                try {
                    mode = PhoneStateManager.this.mAudioManager.getMode();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (PhoneStateManager.this.mLastMode != mode) {
                    PhoneStateManager.this.mLastMode = mode;
                    QLog.i(PhoneStateManager.TAG, "Audio mode changed. mode=" + mode);
                }
                if (mode == 2 && !PhoneStateManager.this.mInterrupt) {
                    PhoneStateManager.this.mInterrupt = true;
                    phoneStatusListener.onInterruptedByPhoneCall();
                } else if (PhoneStateManager.this.mInterrupt) {
                    PhoneStateManager.this.mInterrupt = false;
                    phoneStatusListener.onResumedByPhoneCall();
                }
                PhoneStateManager.this.mMainHandler.postDelayed(PhoneStateManager.this.mRunnable, 1000L);
            }
        }
    };

    public PhoneStateManager(Context context, PhoneStatusListener audioStateListener) {
        this.mContext = context;
        this.mAudioStateListener = audioStateListener;
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        Looper mainLooper = Looper.getMainLooper();
        this.mMainHandler = new Handler(mainLooper);
    }

    public void start() {
        if (this.checkPhonePermission()) {
            this.initPhoneStateListener();
        } else if (ClientInfo.VERSION_SDK_INT >= 31) {
            this.addOnModeChangedListener();
        } else {
            this.startPhoneStateTimer();
        }
    }

    public void stop() {
        if (this.checkPhonePermission()) {
            this.unInitPhoneStateListener();
        } else if (ClientInfo.VERSION_SDK_INT >= 31) {
            this.removeOnModeChangedListener();
        } else {
            this.stopPhoneStateTimer();
        }
    }

    public void onCallStateChanged(int state, String phoneNumber) {
        PhoneStatusListener audioStateListener = this.mAudioStateListener;
        if (audioStateListener == null) {
            return;
        }
        if (this.mCurrentCallState == state) {
            return;
        }
        this.mCurrentCallState = state;
        if (this.mCurrentCallState == 2) {
            audioStateListener.onInterruptedByPhoneCall();
        } else if (this.mCurrentCallState == 0) {
            audioStateListener.onResumedByPhoneCall();
        }
    }

    private void initPhoneStateListener() {
        try {
            if (this.mTelephonyManager != null) {
                this.mTelephonyManager.listen((PhoneStateListener)this, 32);
            } else {
                QLog.w(TAG, "TelephonyManager is null, start listen phone state failed.");
            }
        }
        catch (Throwable throwable) {
            QLog.e(TAG, "start listen phone state failed, " + throwable.getMessage());
        }
    }

    private void unInitPhoneStateListener() {
        try {
            if (this.mTelephonyManager != null) {
                this.mTelephonyManager.listen((PhoneStateListener)this, 0);
            }
            this.mCurrentCallState = 0;
        }
        catch (Throwable throwable) {
            QLog.e(TAG, "stop listen phone state failed, " + throwable.getMessage());
        }
    }

    private boolean checkPhonePermission() {
        Context context = this.mContext.getApplicationContext();
        if (context == null) {
            return false;
        }
        boolean has_permission = true;
        try {
            has_permission = 0 == context.checkPermission("android.permission.READ_PHONE_STATE", Process.myPid(), Process.myUid());
        }
        catch (Throwable e) {
            QLog.e(TAG, "check permission exception, " + e.getMessage());
        }
        return has_permission;
    }

    private void addOnModeChangedListener() {
        try {
            if (this.mOnModeChangedListenerClass == null) {
                this.mOnModeChangedListenerClass = Class.forName("android.media.AudioManager$OnModeChangedListener");
            }
            if (this.mOnModeChangedListenerProxyInstance == null) {
                AudioModeChangedListener listener = new AudioModeChangedListener(this);
                this.mOnModeChangedListenerProxyInstance = Proxy.newProxyInstance(this.mOnModeChangedListenerClass.getClassLoader(), new Class[]{this.mOnModeChangedListenerClass}, (InvocationHandler)listener);
            }
            Method addOnModeChangedListenerMethod = AudioManager.class.getMethod("addOnModeChangedListener", Executor.class, this.mOnModeChangedListenerClass);
            Executor executor = new Executor(){

                @Override
                public void execute(Runnable runnable) {
                    PhoneStateManager.this.mMainHandler.post(runnable);
                }
            };
            addOnModeChangedListenerMethod.invoke((Object)this.mAudioManager, executor, this.mOnModeChangedListenerProxyInstance);
        }
        catch (Throwable e) {
            QLog.e(TAG, "add mode changed listener failed, " + e.getMessage());
        }
    }

    private void removeOnModeChangedListener() {
        try {
            if (this.mOnModeChangedListenerClass != null && this.mOnModeChangedListenerProxyInstance != null) {
                Method removeOnModeChangedListenerMethod = AudioManager.class.getMethod("removeOnModeChangedListener", this.mOnModeChangedListenerClass);
                removeOnModeChangedListenerMethod.invoke((Object)this.mAudioManager, this.mOnModeChangedListenerProxyInstance);
            }
        }
        catch (Throwable e) {
            QLog.e(TAG, "remove mode changed listener failed, " + e.getMessage());
        }
    }

    private void startPhoneStateTimer() {
        if (!this.mTimerRunning) {
            this.mTimerRunning = true;
            this.mMainHandler.postDelayed(this.mRunnable, 1000L);
            QLog.i(TAG, "startPhoneStateTimer");
        }
    }

    private void stopPhoneStateTimer() {
        if (this.mTimerRunning) {
            QLog.i(TAG, "stoPhoneStateTimer");
            this.mTimerRunning = false;
        }
    }

    static class AudioModeChangedListener
    implements InvocationHandler {
        private final WeakReference<PhoneStateManager> mPhoneStateManagerWeakReference;

        AudioModeChangedListener(PhoneStateManager phoneStateManager) {
            this.mPhoneStateManagerWeakReference = new WeakReference<PhoneStateManager>(phoneStateManager);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            try {
                if ("onModeChanged".equals(method.getName())) {
                    this.notifyAudioStateChanged((Integer)args[0]);
                }
            }
            catch (Throwable e) {
                QLog.e(PhoneStateManager.TAG, "notify mode changed failed, " + e.getMessage());
            }
            return proxy;
        }

        private void notifyAudioStateChanged(int mode) {
            QLog.i(PhoneStateManager.TAG, "Audio mode changed. mode=" + mode);
            PhoneStateManager phoneStateManager = (PhoneStateManager)((Object)this.mPhoneStateManagerWeakReference.get());
            if (phoneStateManager == null) {
                return;
            }
            PhoneStatusListener audioStateListener = phoneStateManager.mAudioStateListener;
            if (audioStateListener == null) {
                return;
            }
            if (mode == 2) {
                phoneStateManager.mInterrupt = true;
                audioStateListener.onInterruptedByPhoneCall();
            } else if (phoneStateManager.mInterrupt) {
                phoneStateManager.mInterrupt = false;
                audioStateListener.onResumedByPhoneCall();
            }
        }
    }

    public static interface PhoneStatusListener {
        public void onInterruptedByPhoneCall();

        public void onResumedByPhoneCall();
    }
}

