/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.utils;

import android.text.TextUtils;
import com.gme.av.ptt.SHA1Utils;
import com.gme.av.utils.FileTransferUtils;
import com.gme.av.utils.QLog;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;

public class CosFileTransfer {
    public static final String TAG = "CosFileTransfer";

    public static void uploadFile(final String srcPath, final String strUrl, final String sign, final int maxSize, final Object param, final FileTransferUtils.UploadFileListener listener) {
        Thread fetchTask = new Thread(new Runnable(){

            @Override
            public void run() {
                FileInputStream fis = null;
                HttpURLConnection conn = null;
                OutputStream out = null;
                BufferedReader reader = null;
                int errCode = 0;
                Object fileID = null;
                String uploadResult = "";
                File srcFile = FileTransferUtils.openFile(srcPath);
                if (srcFile == null) {
                    errCode = 8193;
                } else {
                    String sha1 = SHA1Utils.getFileSHA1(srcPath);
                    try {
                        fis = new FileInputStream(srcFile);
                        int size = fis.available();
                        if (size <= 0 || size > maxSize) {
                            QLog.e(CosFileTransfer.TAG, "uploadFileImpl| file size is invalid. path=" + srcPath + ", size=" + size);
                            errCode = 8193;
                        } else {
                            URL url = new URL(strUrl);
                            String BOUNDARY = "----------------------------aa502a40917c";
                            conn = (HttpURLConnection)url.openConnection();
                            conn.setConnectTimeout(5000);
                            conn.setReadTimeout(30000);
                            conn.setDoOutput(true);
                            conn.setDoInput(true);
                            conn.setUseCaches(false);
                            conn.setRequestMethod("POST");
                            conn.setRequestProperty("Connection", "Keep-Alive");
                            conn.setRequestProperty("Authorization", sign);
                            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                            out = new DataOutputStream(conn.getOutputStream());
                            HashMap<String, String> paramMap = new HashMap<String, String>(3);
                            paramMap.put("op", "upload");
                            paramMap.put("sha", sha1);
                            paramMap.put("biz_attr", "");
                            String paramString = FileTransferUtils.getParamString(paramMap, BOUNDARY);
                            paramString = paramString + "--" + BOUNDARY + "\r\n";
                            paramString = paramString + "Content-Disposition: form-data; name=\"filecontent\"; filename=\"" + srcPath + "\"\r\n";
                            paramString = paramString + "Content-Type: application/octet-stream\r\n\r\n";
                            out.write(paramString.getBytes());
                            int bytes = 0;
                            byte[] bufferOut = new byte[1024];
                            while ((bytes = fis.read(bufferOut)) != -1) {
                                out.write(bufferOut, 0, bytes);
                            }
                            String endString = "\r\n--" + BOUNDARY + "--\r\n";
                            out.write(endString.getBytes());
                            out.flush();
                            int rcode = conn.getResponseCode();
                            QLog.e(CosFileTransfer.TAG, "uploadFileImpl|rcode=" + rcode);
                            if (rcode == 200) {
                                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                                String line = null;
                                while ((line = reader.readLine()) != null) {
                                    uploadResult = uploadResult + line;
                                }
                                QLog.e(CosFileTransfer.TAG, "uploadFileImpl|upload result=" + uploadResult);
                            } else {
                                QLog.e(CosFileTransfer.TAG, "uploadFileImpl|upload file failed. http response code =" + rcode);
                                errCode = 8195;
                            }
                        }
                    }
                    catch (UnknownHostException e) {
                        QLog.e(CosFileTransfer.TAG, "uploadFileImpl|upload file failed. neteork is invalid.");
                        errCode = 8195;
                        e.printStackTrace();
                        QLog.e(CosFileTransfer.TAG, e.getMessage());
                    }
                    catch (IOException e) {
                        QLog.e(CosFileTransfer.TAG, "uploadFileImpl|upload file failed. io exception. path=" + srcPath);
                        errCode = 8193;
                        QLog.e(CosFileTransfer.TAG, e.getMessage());
                        e.printStackTrace();
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        QLog.e(CosFileTransfer.TAG, e.getMessage());
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        QLog.e(CosFileTransfer.TAG, e.getMessage());
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        QLog.e(CosFileTransfer.TAG, e.getMessage());
                    }
                }
                if (conn != null) {
                    conn.disconnect();
                }
                if (listener != null) {
                    listener.onCompleted(errCode, uploadResult, param);
                }
            }
        });
        fetchTask.start();
    }

    public static void downloadFile(final String downloadUrl, final String savePath, final String sign, final Object param, final FileTransferUtils.DownloadFileListener listener) {
        Thread downloadTask = new Thread(new Runnable(){

            @Override
            public void run() {
                int errCode;
                HttpURLConnection connection;
                InputStream is;
                FileOutputStream fos;
                block23: {
                    fos = null;
                    is = null;
                    connection = null;
                    errCode = 0;
                    if (TextUtils.isEmpty((CharSequence)downloadUrl)) {
                        QLog.i(CosFileTransfer.TAG, "downloadFileImpl| file url is empty.");
                        errCode = 12292;
                    } else if (TextUtils.isEmpty((CharSequence)savePath)) {
                        QLog.i(CosFileTransfer.TAG, "downloadFileImpl| save path is empty.");
                        errCode = 12289;
                    } else {
                        try {
                            URL url = new URL(downloadUrl);
                            connection = (HttpURLConnection)url.openConnection();
                            connection.setRequestMethod("GET");
                            connection.setRequestProperty("Authorization", sign);
                            connection.setRequestProperty("Connection", "Keep-Alive");
                            connection.setRequestProperty("Accept", "*/*");
                            int code = connection.getResponseCode();
                            if (code == 200) {
                                File file = new File(savePath);
                                if (!file.exists()) {
                                    file.createNewFile();
                                }
                                fos = new FileOutputStream(file);
                                try {
                                    is = connection.getInputStream();
                                }
                                catch (IOException e) {
                                    QLog.i(CosFileTransfer.TAG, "downloadFileImpl|download file failed. neteork is invalid.");
                                    errCode = 12291;
                                    e.printStackTrace();
                                    break block23;
                                }
                                is = connection.getInputStream();
                                byte[] buffer = new byte[1024];
                                int length = 0;
                                while ((length = is.read(buffer)) != -1) {
                                    fos.write(buffer, 0, length);
                                }
                                break block23;
                            }
                            if (code == 404) {
                                errCode = 12292;
                                QLog.i(CosFileTransfer.TAG, "downloadFileImpl| remote file is not exist. url=" + downloadUrl);
                            } else {
                                errCode = 12291;
                                QLog.i(CosFileTransfer.TAG, "downloadFileImpl| network invalid. url=" + downloadUrl);
                            }
                        }
                        catch (MalformedURLException e) {
                            errCode = 12292;
                            QLog.i(CosFileTransfer.TAG, "downloadFileImpl| remote file is not exist. url=" + downloadUrl);
                            QLog.e(CosFileTransfer.TAG, e.getMessage());
                            e.printStackTrace();
                        }
                        catch (UnknownHostException e) {
                            errCode = 12291;
                            QLog.i(CosFileTransfer.TAG, "downloadFileImpl| download file failed. neteork is invalid.");
                            QLog.e(CosFileTransfer.TAG, e.getMessage());
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            errCode = 12289;
                            QLog.i(CosFileTransfer.TAG, "downloadFileImpl| write file faile. path=" + savePath);
                            QLog.e(CosFileTransfer.TAG, e.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        QLog.e(CosFileTransfer.TAG, e.getMessage());
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        QLog.e(CosFileTransfer.TAG, e.getMessage());
                        e.printStackTrace();
                    }
                }
                if (connection != null) {
                    connection.disconnect();
                }
                if (listener != null) {
                    listener.onCompleted(errCode, param);
                }
            }
        });
        downloadTask.start();
    }
}

