/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.signature;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.Deflater;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;
import org.json.JSONObject;

public class GenerateTestUserSig {
    public static final int SDKAPPID = 1400399197;
    private static final int EXPIRETIME = 604800;
    private static String SECRETKEY = "";

    public static void setSecretkey(String key) {
        SECRETKEY = key;
    }

    public static String genTestUserSig(String userId) {
        return GenerateTestUserSig.GenTLSSignature(1400399197L, userId, 604800L, null, SECRETKEY);
    }

    private static String GenTLSSignature(long sdkappid, String userId, long expire, byte[] userbuf, String priKeyContent) {
        String sig;
        if (TextUtils.isEmpty((CharSequence)priKeyContent)) {
            return "";
        }
        long currTime = System.currentTimeMillis() / 1000L;
        JSONObject sigDoc = new JSONObject();
        try {
            sigDoc.put("TLS.ver", (Object)"2.0");
            sigDoc.put("TLS.identifier", (Object)userId);
            sigDoc.put("TLS.sdkappid", sdkappid);
            sigDoc.put("TLS.expire", expire);
            sigDoc.put("TLS.time", currTime);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String base64UserBuf = null;
        if (null != userbuf) {
            base64UserBuf = Base64.encodeToString((byte[])userbuf, (int)2);
            try {
                sigDoc.put("TLS.userbuf", (Object)base64UserBuf);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if ((sig = GenerateTestUserSig.hmacsha256(sdkappid, userId, currTime, expire, priKeyContent, base64UserBuf)).length() == 0) {
            return "";
        }
        try {
            sigDoc.put("TLS.sig", (Object)sig);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Deflater compressor = new Deflater();
        compressor.setInput(sigDoc.toString().getBytes(Charset.forName("UTF-8")));
        compressor.finish();
        byte[] compressedBytes = new byte[2048];
        int compressedBytesLength = compressor.deflate(compressedBytes);
        compressor.end();
        return new String(GenerateTestUserSig.base64EncodeUrl(Arrays.copyOfRange(compressedBytes, 0, compressedBytesLength)));
    }

    private static String hmacsha256(long sdkappid, String userId, long currTime, long expire, String priKeyContent, String base64Userbuf) {
        String contentToBeSigned = "TLS.identifier:" + userId + "\nTLS.sdkappid:" + sdkappid + "\nTLS.time:" + currTime + "\nTLS.expire:" + expire + "\n";
        if (null != base64Userbuf) {
            contentToBeSigned = contentToBeSigned + "TLS.userbuf:" + base64Userbuf + "\n";
        }
        try {
            byte[] byteKey = priKeyContent.getBytes("UTF-8");
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec keySpec = new SecretKeySpec(byteKey, "HmacSHA256");
            hmac.init(keySpec);
            byte[] byteSig = hmac.doFinal(contentToBeSigned.getBytes("UTF-8"));
            return new String(Base64.encode((byte[])byteSig, (int)2));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        catch (InvalidKeyException e) {
            return "";
        }
    }

    private static byte[] base64EncodeUrl(byte[] input) {
        byte[] base64 = new String(Base64.encode((byte[])input, (int)2)).getBytes();
        block5: for (int i = 0; i < base64.length; ++i) {
            switch (base64[i]) {
                case 43: {
                    base64[i] = 42;
                    continue block5;
                }
                case 47: {
                    base64[i] = 45;
                    continue block5;
                }
                case 61: {
                    base64[i] = 95;
                    continue block5;
                }
            }
        }
        return base64;
    }
}

