/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.sdk;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.gme.av.utils.QLog;

public class NetworkHelp {
    public static final String TAG = "NetworkHelp";
    public static final int AP_UNKNOWN = 0;
    public static final int AP_WIFI = 1;
    public static final int AP_2G = 2;
    public static final int AP_3G = 3;
    public static final int AP_4G = 4;
    public static final int AP_5G = 5;

    protected static APInfo getAPInfo(Context context) {
        APInfo apInfo = new APInfo();
        if (context == null) {
            QLog.e(TAG, "getAPInfo initial context is null");
            return apInfo;
        }
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            switch (networkInfo.getType()) {
                case 1: {
                    apInfo.apType = 1;
                    apInfo.apName = "AP_WIFI";
                    break;
                }
                case 0: {
                    apInfo = NetworkHelp.getMobileAPInfo(context, networkInfo.getSubtype());
                    break;
                }
            }
        }
        return apInfo;
    }

    private static APInfo getMobileAPInfo(Context context, int subtype) {
        APInfo apInfo = new APInfo();
        switch (subtype) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                apInfo.apType = 2;
                apInfo.apName = "AP_2G";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                apInfo.apType = 3;
                apInfo.apName = "AP_3G";
                break;
            }
            case 13: {
                apInfo.apType = 4;
                apInfo.apName = "AP_4G";
                break;
            }
            case 20: {
                apInfo.apType = 5;
                apInfo.apName = "AP_5G";
                break;
            }
        }
        return apInfo;
    }

    public static class APInfo {
        public int apType = 0;
        public String apName = "AP_UNKNOWN";
    }
}

