/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.sdk;

import com.gme.av.sdk.HttpParam;
import com.gme.av.utils.HttpHelper;
import java.util.HashMap;

public class HttpClient {
    public static String LOGTAG = "HttpClient";
    public long mNativeEntity;

    public HttpClient(long nativeEntity) {
        this.mNativeEntity = nativeEntity;
    }

    public void uninit() {
        this.mNativeEntity = 0L;
    }

    public void httpGet(String url, String strFilePath, int timeout) {
        CsCmdCallbackImpl callback = new CsCmdCallbackImpl();
        HttpHelper.httpGetRequest(url, strFilePath, null, timeout, callback);
    }

    public void httpPost(String url, byte[] request, int timeout) {
        CsCmdCallbackImpl callback = new CsCmdCallbackImpl();
        HttpHelper.httpPostRequest(url, request, null, null, timeout, callback);
    }

    public void httpPost(String url, byte[] request, int timeout, String hostName) {
        CsCmdCallbackImpl callback = new CsCmdCallbackImpl();
        if (hostName.length() == 0) {
            HttpHelper.httpPostRequest(url, request, null, null, timeout, callback);
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Host", hostName);
            HttpHelper.httpPostRequest(url, request, map, null, timeout, callback);
        }
    }

    public void uploadFileToCos(String url, String strFilePath, String strToken) {
        CsCmdCallbackImpl callback = new CsCmdCallbackImpl();
        HttpHelper.uploadFileToCosRequest(url, strFilePath, strToken, callback);
    }

    public void uploadFileToS3(String url, String strFilePath, HttpParam params) {
        CsCmdCallbackImpl callback = new CsCmdCallbackImpl();
        HttpHelper.uploadFileToS3Request(url, strFilePath, params, callback);
    }

    public native void nativeHttpResult(long var1, MultiVideoResult var3);

    public native boolean nativeOnProcess(long var1, String var3, int var4, int var5);

    public class MultiVideoResult {
        public int result = 7001;
        public int statusCode;
        public String errorInfo;
        public byte[] response;
    }

    public class CsCmdCallbackImpl
    implements HttpHelper.HttpRequestListener {
        @Override
        public void onCompleted(String url, int ret, String errInfo, byte[] resp, Object param) {
            MultiVideoResult result = new MultiVideoResult();
            result.statusCode = ret;
            result.errorInfo = errInfo;
            if (resp == null || resp.length == 0) {
                result.result = 7001;
            } else {
                result.result = 0;
                result.response = resp;
            }
            HttpClient.this.nativeHttpResult(HttpClient.this.mNativeEntity, result);
        }

        @Override
        public boolean onProcess(String url, int totalSize, int downloadSize) {
            return HttpClient.this.nativeOnProcess(HttpClient.this.mNativeEntity, url, totalSize, downloadSize);
        }
    }
}

