/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.sdk;

import android.content.Context;
import com.gme.av.utils.QLog;

public class GMELibLoader {
    private static boolean sLoadLibrary = false;
    private static final String TAG = "SoUtil";
    private static String gmesoVersion = "2_9_15_6fa587cb";

    public static int loadSdkLibrary(Context context) {
        boolean is_match = true;
        if (!sLoadLibrary) {
            sLoadLibrary = GMELibLoader.loadSo("gmesdk");
            if (!sLoadLibrary) {
                return 7014;
            }
            is_match = GMELibLoader.checkSo();
            GMELibLoader.loadSo("gmefaad2");
            GMELibLoader.loadSo("gmefdkaac");
            GMELibLoader.loadSo("gmelamemp3");
            GMELibLoader.loadSo("gmeogg");
            GMELibLoader.loadSo("gmesoundtouch");
            GMELibLoader.loadSo("xnn_core");
            GMELibLoader.loadSo("gmevoicechanger");
            GMELibLoader.loadSo("YTCommon");
            GMELibLoader.loadSo("YT3DAvatar");
            GMELibLoader.loadSo("YTFaceTracker");
            GMELibLoader.loadSo("gmeposetracker");
        }
        if (!is_match) {
            return 7015;
        }
        return 0;
    }

    public static String getGMEVersion() {
        return gmesoVersion;
    }

    public static boolean checkSo() {
        boolean is_match = true;
        try {
            if (!gmesoVersion.equals("localGmeSoVersion")) {
                String nativeGmeSoVersion = GMELibLoader.nativeGetGmeSoVersion();
                is_match = gmesoVersion.equals(nativeGmeSoVersion);
                QLog.d(TAG, "gmeSoVersion =  " + gmesoVersion + "nativeGmeSoVersion = " + nativeGmeSoVersion);
            }
        }
        catch (UnsatisfiedLinkError e) {
            QLog.d(TAG, "call nativeGetGmeVersion failed: " + e.getMessage());
            return false;
        }
        return is_match;
    }

    public static boolean loadSo(String libName) {
        try {
            System.loadLibrary(libName);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            QLog.d(TAG, "load so failed: " + e.getMessage());
            return false;
        }
    }

    public static boolean isLoadLibrary() {
        return sLoadLibrary;
    }

    private static native String nativeGetGmeSoVersion();
}

