/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.ptt;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import com.gme.av.ptt.RingBuffer;
import com.gme.av.ptt.TraeJni;
import com.gme.av.utils.QLog;
import java.util.Arrays;

public class Recorder {
    AudioRecord mRecord = null;
    AudioManager mAudioManager = null;
    private static final int SAMPLE_RATE_IN_HZ = 16000;
    private static final int CHANNEL_CONFIG = 16;
    private static final int AUDIO_FORMAT = 2;
    private static final int DEFAULT_RECORDER_INIT_BUFFER_SIZE = 20480;
    private static final int DEFAULT_FRAME_LENGTH_PER_READ = 800;
    private int recorderInitBufSize = 20480;
    private int frameLengthPerRead = 800;
    public int recordLevel = 0;
    public int recordGain = 100;
    private static final int FRAME_LENGTH_160 = 160;
    private static final String TAG = "Recorder";
    private int MAX_NO_DATA_TIME_MS = 1000;
    private Context context = null;
    private static final int INVALID_VALUE = -1;
    private int mMode = -1;
    private int mAudioSource = -1;
    private static final int ABNORMAL_NO_DATA = 0;
    private int MAX_RECORD_TIME = 59000;
    private int MIN_RECORD_TIME = 0;
    private long maxRecorderTime = this.MAX_RECORD_TIME;
    public static final int VOLUME_STATE_INIT = 0;
    public static final int VOLUME_STATE_LOW = 1;
    public static final int VOLUME_STATE_NORMAL = 2;
    public String pcmFilePath = null;
    private String deviceInfo = "";
    private String DEVICE_VIVO = "vivo";
    private String DEVICE_OPPO = "oppo";
    private String DEVICE_BBK = "bbk";
    private String DEVICE_MEIZU = "meizu";
    private int IGNORE_DATA_FRAME_NORMAL = 10;
    private int IGNORE_DATA_FRAME_MEIZU = 15;
    private OnQQRecorderListener mListener = null;
    private RingBuffer ringBuffer = null;
    private static int weatherRequest = 0;
    RecordThread recordThread = null;

    public void setQQRecorderListener(OnQQRecorderListener listener) {
        QLog.i(TAG, "setQQRecorderListener");
        if (listener == null) {
            QLog.i(TAG, "setQQRecorderListener--> listener is null");
        } else {
            this.mListener = listener;
        }
    }

    public void setMaxRecorderTime(int time) {
        this.maxRecorderTime = time <= this.MAX_RECORD_TIME ? (long)time : (long)this.MAX_RECORD_TIME;
    }

    public Recorder(Context context) {
        this.context = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.ringBuffer = new RingBuffer(6400);
        this.deviceInfo = Build.MANUFACTURER;
        QLog.i(TAG, "device info = " + this.deviceInfo);
        this.mMode = 0;
        this.mAudioSource = 0;
        QLog.i(TAG, "mMode = " + this.mMode + " | mAudioSource = " + this.mAudioSource + " | recorderBufSize = " + this.recorderInitBufSize + " | readLength = " + this.frameLengthPerRead);
    }

    private void initBufferSize(int ratio, int bufferSize, int readLength) {
        if (ratio != -1) {
            int minBufSize = AudioRecord.getMinBufferSize((int)16000, (int)16, (int)2);
            if (minBufSize != -2 && minBufSize != -1) {
                this.recorderInitBufSize = minBufSize * ratio;
            }
        } else if (bufferSize != -1) {
            this.recorderInitBufSize = bufferSize;
        }
        if (readLength != -1) {
            this.frameLengthPerRead = readLength;
        }
    }

    public void start() {
        QLog.i(TAG, "QQRecord Start");
        if (this.recordThread == null) {
            this.recordThread = new RecordThread();
            TraeJni.getInstance().initTRAE();
            this.recordThread.start();
        } else {
            QLog.i(TAG, "Record :start --> Record is Not Ready");
            if (this.mListener != null) {
                this.mListener.onRecorderFailed("", 1);
            }
        }
    }

    public void stop() {
        QLog.i(TAG, "QQRecord Stop");
        if (this.recordThread != null) {
            this.recordThread.isRunning = false;
        }
    }

    @SuppressLint(value={"NewApi"})
    private void requestRecordPermission() {
        try {
            QLog.w(TAG, "requestRecordPermission");
            if (this.context != null) {
                SharedPreferences _sharedPrefrences = this.context.getSharedPreferences("GMEApplyForAudioRecord", 0);
                SharedPreferences.Editor edit = _sharedPrefrences.edit();
                edit.putInt("GMEApplyForAudioRecord", 1);
                edit.apply();
                String recordAudioStr = "android.permission.RECORD_AUDIO";
                if (weatherRequest == 0 && Build.VERSION.SDK_INT >= 23 && this.context instanceof Activity) {
                    weatherRequest = 1;
                    Activity mActivity = (Activity)this.context;
                    if (mActivity.checkSelfPermission(recordAudioStr) != 0) {
                        String[] permissions = new String[]{recordAudioStr};
                        mActivity.requestPermissions(permissions, 101);
                    }
                }
            }
        }
        catch (Exception e) {
            QLog.e(TAG, "requestPermissions error");
        }
    }

    public boolean initRecording() {
        this.requestRecordPermission();
        if (null != this.mRecord) {
            this.mRecord.release();
            this.mRecord = null;
        }
        int mode = 0;
        if (this.mAudioManager != null) {
            mode = this.mAudioManager.getMode();
        }
        QLog.i(TAG, "Record :startRecording | audio mode = " + mode);
        if (this.mAudioManager != null && this.mMode != -1) {
            QLog.i(TAG, "Record :initRecording --> SetMode ,mode = " + this.mMode);
            this.mAudioManager.setMode(this.mMode);
        }
        if (this.mRecord == null) {
            QLog.i(TAG, "Record: new AudioRecord --> mAudioSource = " + this.mAudioSource + " ,SAMPLE_RATE_IN_HZ =" + 16000 + " ,CHANNEL_CONFIG = " + 16 + " ,AUDIO_FORMAT =" + 2 + " ,recorderInitBufSize = " + this.recorderInitBufSize);
            try {
                this.mRecord = new AudioRecord(this.mAudioSource, 16000, 16, 2, this.recorderInitBufSize);
            }
            catch (IllegalArgumentException e) {
                QLog.i(TAG, "Record : new AudioRecord Failed:" + Log.getStackTraceString((Throwable)e), e);
                return false;
            }
        }
        if (this.mRecord.getState() != 1) {
            int state = this.mRecord.getState();
            QLog.i(TAG, "Record State = " + state);
            if (null != this.mRecord) {
                this.mRecord.release();
            }
            this.mRecord = null;
            return false;
        }
        return true;
    }

    private void releaseRecordThreadResource() {
        if (this.mRecord != null) {
            this.mRecord.release();
        }
        this.mRecord = null;
        this.recordLevel = 0;
        this.recordThread = null;
    }

    public boolean isStop() {
        if (this.recordThread == null) {
            return true;
        }
        return !this.recordThread.isRunning;
    }

    public boolean isRecording() {
        return this.recordThread != null;
    }

    private native int nativeProcess(byte[] var1, int var2, int var3, int var4, int var5);

    class RecordThread
    extends Thread {
        public volatile boolean isRunning = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QLog.i(Recorder.TAG, "RecordThread Start : " + this);
            byte[] remainderBuf = null;
            int silkCount = 0;
            try {
                if (Recorder.this.mListener != null) {
                    Recorder.this.mListener.onRecorderPrepare("");
                }
                long pcmDataSize = 0L;
                byte[] srcData = new byte[Recorder.this.frameLengthPerRead];
                if (Recorder.this.mRecord == null) {
                    if (Recorder.this.mListener != null) {
                        Recorder.this.mListener.onRecorderFailed("", 4);
                    }
                    Recorder.this.releaseRecordThreadResource();
                    return;
                }
                Recorder.this.mRecord.startRecording();
                if (Recorder.this.mListener != null) {
                    Recorder.this.mListener.onRecorderStart();
                }
                long samplingStartTime = 0L;
                boolean abnormalChecked = false;
                while (this.isRunning) {
                    if (samplingStartTime != 0L && SystemClock.elapsedRealtime() - samplingStartTime > (long)Recorder.this.MAX_NO_DATA_TIME_MS && !abnormalChecked) {
                        abnormalChecked = true;
                        if (pcmDataSize == 0L && Recorder.this.mListener != null) {
                            Recorder.this.mListener.onRecorderAbnormal(0);
                            this.isRunning = false;
                        }
                    }
                    int srcOffset = 0;
                    if (remainderBuf != null) {
                        srcOffset = remainderBuf.length;
                        System.arraycopy(remainderBuf, 0, srcData, 0, srcOffset);
                    }
                    int size = Recorder.this.mRecord.read(srcData, srcOffset, Recorder.this.frameLengthPerRead - srcOffset);
                    if (samplingStartTime == 0L) {
                        samplingStartTime = SystemClock.elapsedRealtime();
                    }
                    if (Recorder.this.frameLengthPerRead - srcOffset != size) {
                        QLog.i(Recorder.TAG, " Recording --> Request Size = " + (Recorder.this.frameLengthPerRead - srcOffset) + " ,Really Size = " + size);
                    }
                    if (Recorder.this.mListener != null) {
                        Recorder.this.mListener.onBeginReceiveData();
                    }
                    if (size <= 0) {
                        Thread.sleep(10L);
                        continue;
                    }
                    remainderBuf = null;
                    pcmDataSize += (long)size;
                    int remainder = (size += srcOffset) % 160;
                    if (remainder != 0) {
                        remainderBuf = new byte[remainder];
                        System.arraycopy(srcData, size - remainder, remainderBuf, 0, remainder);
                        size -= remainder;
                    }
                    Recorder.this.ringBuffer.Push(srcData, size);
                    byte[] silkByte = new byte[640];
                    while (Recorder.this.ringBuffer.RemainRead() >= 640) {
                        if (!Recorder.this.ringBuffer.Pop(silkByte, 640)) continue;
                        if (Recorder.this.deviceInfo.equalsIgnoreCase(Recorder.this.DEVICE_MEIZU) && ++silkCount <= Recorder.this.IGNORE_DATA_FRAME_MEIZU || silkCount <= Recorder.this.IGNORE_DATA_FRAME_NORMAL) {
                            Arrays.fill(silkByte, (byte)0);
                        }
                        Recorder.this.recordLevel = Recorder.this.nativeProcess(silkByte, silkByte.length, Recorder.this.recordGain, 16000, 1);
                        byte[] silkData = TraeJni.getInstance().turnSilk(silkByte, 640L);
                        byte[] temple = new byte[2 + silkData.length];
                        temple[0] = (byte)(silkData.length & 0xFF);
                        temple[1] = (byte)(silkData.length >>> 8 & 0xFF);
                        System.arraycopy(silkData, 0, temple, 2, silkData.length);
                        Recorder.this.mListener.onReceiveRecordData(temple);
                    }
                }
                if (SystemClock.elapsedRealtime() - samplingStartTime <= (long)Recorder.this.MIN_RECORD_TIME || samplingStartTime == 0L) {
                    if (Recorder.this.mListener != null) {
                        Recorder.this.mListener.onRecorderFailed(null, 5);
                    }
                } else if (Recorder.this.mListener != null) {
                    Recorder.this.mListener.onRecorderEnd();
                }
                if (Recorder.this.mAudioManager != null && Recorder.this.mMode != -1) {
                    Recorder.this.mAudioManager.setMode(0);
                }
            }
            catch (Exception e) {
                QLog.i(Recorder.TAG, "record Exception: " + Log.getStackTraceString((Throwable)e), e);
                if (Recorder.this.mListener != null) {
                    Recorder.this.mListener.onRecorderError("", e.getMessage());
                }
            }
            finally {
                QLog.i(Recorder.TAG, "record silk count = " + silkCount);
                Recorder.this.releaseRecordThreadResource();
            }
        }
    }

    public static interface OnQQRecorderListener {
        public void onRecorderFailed(String var1, int var2);

        public void onRecorderPrepare(String var1);

        public void onRecorderStart();

        public void onBeginReceiveData();

        public void onReceiveRecordData(byte[] var1);

        public void onRecorderEnd();

        public void onRecorderError(String var1, String var2);

        public void onRecorderAbnormal(int var1);
    }

    public static interface RECORDER_FAILED_REASON {
        public static final int RecorderNotReady = 1;
        public static final int CreateFileFailed = 2;
        public static final int InitAudioRecordError = 3;
        public static final int AudioRecordNotInit = 4;
        public static final int AudioTooShort = 5;
    }
}

