/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.ptt;

import android.media.AudioTrack;
import com.gme.av.ptt.PttListener;
import com.gme.av.ptt.TraeJni;
import com.gme.av.utils.QLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class PCMPlayer {
    public String TAG = "PCMPlayer";
    private AudioTrack audioTrack;
    private int bufferSize;
    private int sampleRate = 16000;
    private int channel = 4;
    private int format = 2;
    public int playLevel = 0;
    public int playGain = 100;
    PlayThread pcmPlayer = null;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public PCMPlayer() {
    }

    public PCMPlayer(int rate, int channel, int format) {
        this.sampleRate = rate;
        this.channel = channel;
        this.format = format;
    }

    public boolean initPCMPlayer(int audioCategory) {
        if (this.audioTrack != null) {
            QLog.i(this.TAG, "init pcm player, audio track not null, release first!");
            this.audioTrack.release();
            this.audioTrack = null;
        }
        int streamType = audioCategory == 200 ? 0 : 3;
        this.audioTrack = new AudioTrack(streamType, this.sampleRate, this.channel, this.format, this.format, 1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSilkFilePlayTime(String fileName) {
        int silkCount = 0;
        int playLength = 0;
        int time = 0;
        FileInputStream fis = null;
        try {
            int hlen;
            File silkFile = new File(fileName);
            if (!silkFile.exists()) {
                boolean bl = false;
                return bl ? 1 : 0;
            }
            fis = new FileInputStream(silkFile);
            int length = fis.available();
            byte[] buffer = new byte[length];
            int readLength = fis.read(buffer);
            fis.close();
            fis = null;
            for (playLength = 9; playLength < readLength - 1 && playLength < length - 1; playLength += hlen + 2) {
                ++silkCount;
                hlen = (buffer[playLength + 1] << 8) + buffer[playLength];
                time += 20;
            }
            QLog.i(this.TAG, " getSilkFilePlayTime fileName:" + fileName + "length :" + readLength);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            QLog.i(this.TAG, "playLength = " + playLength + " time = " + time + " , silk count = " + silkCount);
            return time;
        }
    }

    public boolean isPlaying() {
        return this.pcmPlayer != null && this.pcmPlayer.isRunning;
    }

    public void play(String path, PttListener.PlayFileListener callBack) {
        if (path == null || path.length() == 0) {
            callBack.onCompleted(20483, null);
            return;
        }
        if (this.pcmPlayer == null || !this.pcmPlayer.isRunning) {
            this.pcmPlayer = new PlayThread(path, callBack);
            this.audioTrack.play();
            this.pcmPlayer.start();
        } else {
            QLog.i(this.TAG, "file is playing , not play again!");
            callBack.onCompleted(20482, null);
        }
    }

    public void stop() {
        if (this.pcmPlayer != null && this.pcmPlayer.isRunning) {
            QLog.i(this.TAG, "stop silk player ");
            this.pcmPlayer.isRunning = false;
            try {
                this.pcmPlayer.join();
            }
            catch (Exception e) {
                QLog.i(this.TAG, "join  pcmPlayer thread error" + e.getMessage());
            }
        }
        QLog.i(this.TAG, "stop silk player end!");
    }

    private native int nativeProcess(byte[] var1, int var2, int var3, int var4, int var5);

    class PlayThread
    extends Thread {
        public volatile boolean isRunning = true;
        public String playPath = "";
        PttListener.PlayFileListener callBack = null;

        public PlayThread(String path, PttListener.PlayFileListener callBack) {
            this.playPath = path;
            this.callBack = callBack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File file = null;
            FileInputStream fis = null;
            int silkCount = 0;
            try {
                TraeJni.getInstance().initTRAE();
                file = new File(this.playPath);
                fis = new FileInputStream(file);
                int length = fis.available();
                QLog.i(PCMPlayer.this.TAG, "silk file length = " + length);
                byte[] buffer = new byte[length];
                int readLength = fis.read(buffer);
                QLog.i(PCMPlayer.this.TAG, "silk file read length = " + readLength);
                fis.close();
                fis = null;
                int playLength = 0;
                int READ_PER_TIME = 640;
                playLength = 9;
                while (playLength < readLength - 1 && this.isRunning) {
                    int hlen = (buffer[playLength + 1] << 8) + buffer[playLength];
                    byte[] dataBuffer = new byte[hlen];
                    System.arraycopy(buffer, playLength += 2, dataBuffer, 0, hlen);
                    byte[] pcmData = TraeJni.getInstance().turnPCM(dataBuffer, hlen);
                    PCMPlayer.this.playLevel = PCMPlayer.this.nativeProcess(pcmData, pcmData.length, PCMPlayer.this.playGain, PCMPlayer.this.sampleRate, 1);
                    playLength += hlen;
                    PCMPlayer.this.audioTrack.write(pcmData, 0, pcmData.length);
                    ++silkCount;
                }
                this.callBack.onCompleted(0, this.playPath);
            }
            catch (FileNotFoundException e) {
                QLog.i(PCMPlayer.this.TAG, "file not found : " + e);
                this.callBack.onCompleted(20484, null);
            }
            catch (IOException e) {
                QLog.i(PCMPlayer.this.TAG, "file io error : " + e);
                this.callBack.onCompleted(20484, null);
            }
            catch (Exception e) {
                QLog.i(PCMPlayer.this.TAG, "play silk exception : " + e);
                this.callBack.onCompleted(20484, null);
            }
            finally {
                QLog.i(PCMPlayer.this.TAG, "play record end!");
                if (PCMPlayer.this.audioTrack != null) {
                    PCMPlayer.this.audioTrack.stop();
                    PCMPlayer.this.audioTrack.release();
                    PCMPlayer.this.audioTrack = null;
                }
                PCMPlayer.this.playLevel = 0;
                this.isRunning = false;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                QLog.i(PCMPlayer.this.TAG, "play silk file end!");
            }
        }
    }
}

