/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.ptt;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.gme.av.utils.QLog;

public class NetworkProvider {
    private static String TAG = "NetworkProvider";

    public static int getNetTypeName(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null) {
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            if (activeNetworkInfo == null) {
                return 0;
            }
            if (activeNetworkInfo.getType() == 1) {
                return 1;
            }
            if (activeNetworkInfo.getType() == 0) {
                switch (activeNetworkInfo.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 2;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 3;
                    }
                    case 13: {
                        return 4;
                    }
                }
                String subTypeName = activeNetworkInfo.getSubtypeName();
                QLog.i(TAG, "network type = " + subTypeName);
                if (subTypeName.equalsIgnoreCase("TD-SCDMA") || subTypeName.equalsIgnoreCase("WCDMA") || subTypeName.equalsIgnoreCase("CDMA2000")) {
                    return 3;
                }
                QLog.i(TAG, "unknown network type = " + subTypeName);
                return 0;
            }
        }
        return 0;
    }

    public static interface NETWORK_TYPE {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WIFI = 1;
        public static final int TYPE_2G = 2;
        public static final int TYPE_3G = 3;
        public static final int TYPE_4G = 4;
        public static final int TYPE_WIRED = 5;
    }
}

