/*
 * Decompiled with CFR 0.152.
 */
package com.gme.av.audiodispatcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import com.gme.av.audiodispatcher.AudioDispatcher;
import com.gme.av.utils.QLog;

public class GMEAudioBroadcast
extends BroadcastReceiver {
    private static final String TAG = "GMEAudioBroadcast";
    private static GMEAudioBroadcast mGMEAudioBroadcast;
    private static final String ACTION_STRING = "GMEAudioBroadcast";
    private static final String AUDIO_CHANGE_EVENT_ACTION_STRING = "GMEMicUseEventBroadcast";
    private static final int SAMPLE_RATE = 48000;
    private static final int CHANNEL = 2;
    private static final int BIT = 16;
    private static Context mContext;

    public static GMEAudioBroadcast getInstance() {
        if (mGMEAudioBroadcast == null) {
            mGMEAudioBroadcast = new GMEAudioBroadcast();
        }
        return mGMEAudioBroadcast;
    }

    public void registerBroadcast(Context context) {
        try {
            mContext = context;
            IntentFilter filter = new IntentFilter();
            filter.addAction("GMEAudioBroadcast");
            context.registerReceiver((BroadcastReceiver)mGMEAudioBroadcast, filter);
            QLog.e("GMEAudioBroadcast", "registerBroadcast successfully");
        }
        catch (Exception e) {
            QLog.e("GMEAudioBroadcast", "registerBroadcast exception e=" + e.toString());
        }
    }

    public void unRegisterBroadcast(Context context) {
        try {
            context.unregisterReceiver((BroadcastReceiver)mGMEAudioBroadcast);
            QLog.e("GMEAudioBroadcast", "unregisterBroadcast successfully");
        }
        catch (Exception e) {
            QLog.e("GMEAudioBroadcast", "unregisterBroadcast exception e=" + e.toString());
        }
    }

    public void onAudioCaptureChange(final boolean enable) {
        QLog.e("GMEAudioBroadcast", "onAudioCaptureChange " + enable);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.setAction(GMEAudioBroadcast.AUDIO_CHANGE_EVENT_ACTION_STRING);
                intent.putExtra("gme_mic_use_event", enable);
                if (mContext != null) {
                    intent.setPackage(mContext.getPackageName());
                    mContext.sendBroadcast(intent, null);
                }
            }
        }, 500L);
    }

    public void onReceive(Context context, Intent intent) {
        boolean isRecording = this.nativeIsAudioCaptureDeviceEnabled();
        boolean startServerRet = AudioDispatcher.getInstance().startServer();
        int port = AudioDispatcher.getInstance().getPort();
        String responseAction = intent.getStringExtra("from_action");
        Intent responseIntent = new Intent();
        responseIntent.setAction(responseAction);
        responseIntent.putExtra("gme_recording", true);
        responseIntent.putExtra("gme_server_socket_ready", startServerRet);
        responseIntent.putExtra("gme_server_port", port);
        responseIntent.putExtra("gme_audio_sample_rate", 48000);
        responseIntent.putExtra("gme_audio_channel", 2);
        responseIntent.putExtra("gme_audio_bit", 16);
        responseIntent.setPackage(context.getPackageName());
        context.sendBroadcast(responseIntent, null);
        QLog.e("GMEAudioBroadcast", "onReceive start:" + startServerRet + "  port: " + port + " isRecording\uff1a" + isRecording + "  startServerRet: " + startServerRet);
    }

    public native boolean nativeIsAudioCaptureDeviceEnabled();

    static {
        mContext = null;
    }
}

