/*
 * Decompiled with CFR 0.152.
 */
package com.gme.TMG;

import android.content.Intent;
import com.gme.TMG.ITMGContext;
import com.gme.TMG.ITMGRoom;
import com.gme.TMG.TMGCallbackHelper;
import com.gme.TMG.TMGContext;
import com.gme.av.sdk.AVCallback;
import java.util.ArrayList;

public class TMGRoom
extends ITMGRoom {
    TMGContext mTmgContext = null;
    private ITMGRoom.CustomStreamDataCallback customStreamDataCallback;

    TMGRoom(TMGContext tmgContext) {
        this.mTmgContext = tmgContext;
    }

    @Override
    public String GetQualityTips() {
        return this.nativeGetQualityTips();
    }

    @Override
    public int ChangeRoomType(int roomType) {
        final int newRoomType = roomType;
        return this.nativeChangeRoomType(roomType, new AVCallback(){

            @Override
            public void onComplete(int nRet, String strErrMsg) {
                Intent it = TMGCallbackHelper.GetRoomTypeChangedEventIntent(nRet, 4, newRoomType, strErrMsg);
                if (TMGRoom.this.mTmgContext.mTmgDelegate != null) {
                    TMGRoom.this.mTmgContext.mTmgDelegate.OnEvent(ITMGContext.ITMG_MAIN_EVENT_TYPE.ITMG_MAIN_EVENT_TYPE_CHANGE_ROOM_TYPE, it);
                }
            }
        });
    }

    @Override
    public int StartRoomSharing(String targetRoomID, String targetOpenID, byte[] authBuffer) {
        return this.nativeStartRoomSharing(targetRoomID, targetOpenID, authBuffer);
    }

    @Override
    public int SetServerAudioRoute(ITMGContext.ITMG_SERVER_AUDIO_ROUTE_SEND_TYPE sendType, ArrayList<String> SendList, ITMGContext.ITMG_SERVER_AUDIO_ROUTE_RECV_TYPE recvType, ArrayList<String> RecvList) {
        int i;
        String[] openIDForSend = new String[SendList.size()];
        String[] openIDForRecv = new String[RecvList.size()];
        for (i = 0; i < SendList.size(); ++i) {
            openIDForSend[i] = SendList.get(i);
        }
        for (i = 0; i < RecvList.size(); ++i) {
            openIDForRecv[i] = RecvList.get(i);
        }
        return this.nativeSetServerAudioRoute(sendType.getValue(), openIDForSend, recvType.getValue(), openIDForRecv);
    }

    @Override
    public ITMGContext.ITMG_SERVER_AUDIO_ROUTE_SEND_TYPE GetCurrentSendAudioRoute(ArrayList<String> openIDForSend) {
        int[] RouteType = new int[]{1, 1};
        int[] ListLength = new int[]{0, 0};
        String[] SendList = new String[10];
        String[] RecvList = new String[10];
        if (openIDForSend == null) {
            return ITMGContext.ITMG_SERVER_AUDIO_ROUTE_SEND_TYPE.AUDIO_ROUTE_SEND_INQUIRE_ERROR;
        }
        int ret = this.nativeGetServerAudioRoute(RouteType, SendList, RecvList, ListLength);
        if (ret == 0) {
            for (int i = 0; i < ListLength[0] && i < SendList.length; ++i) {
                openIDForSend.add(SendList[i]);
            }
            return ITMGContext.ITMG_SERVER_AUDIO_ROUTE_SEND_TYPE.valueOf(RouteType[0]);
        }
        return ITMGContext.ITMG_SERVER_AUDIO_ROUTE_SEND_TYPE.AUDIO_ROUTE_SEND_INQUIRE_ERROR;
    }

    @Override
    public ITMGContext.ITMG_SERVER_AUDIO_ROUTE_RECV_TYPE GetCurrentRecvAudioRoute(ArrayList<String> openIDForRecv) {
        int[] RouteType = new int[]{1, 1};
        int[] ListLength = new int[]{0, 0};
        String[] SendList = new String[10];
        String[] RecvList = new String[10];
        if (openIDForRecv == null) {
            return ITMGContext.ITMG_SERVER_AUDIO_ROUTE_RECV_TYPE.AUDIO_ROUTE_RECV_INQUIRE_ERROR;
        }
        int ret = this.nativeGetServerAudioRoute(RouteType, SendList, RecvList, ListLength);
        if (ret == 0) {
            for (int i = 0; i < ListLength[1] && i < RecvList.length; ++i) {
                openIDForRecv.add(RecvList[i]);
            }
            return ITMGContext.ITMG_SERVER_AUDIO_ROUTE_RECV_TYPE.valueOf(RouteType[1]);
        }
        return ITMGContext.ITMG_SERVER_AUDIO_ROUTE_RECV_TYPE.AUDIO_ROUTE_RECV_INQUIRE_ERROR;
    }

    @Override
    public int SendCustomData(byte[] data, int repeatCout) {
        return this.nativeSendCustomData(data, repeatCout);
    }

    @Override
    public int StopSendCustomData() {
        return this.nativeStopSendCustomData();
    }

    @Override
    public int StopRoomSharing() {
        return this.nativeStopRoomSharing();
    }

    @Override
    public int GetRoomType() {
        return this.nativeGetRoomType();
    }

    @Override
    public String GetRoomID() {
        return this.nativeGetRoomID();
    }

    @Override
    public int StartChorusWithOpenID(String OpenID) {
        return this.nativeStartChorusWithOpenID(OpenID);
    }

    @Override
    public int StopChorus() {
        return this.nativeStopChorus();
    }

    @Override
    public int StartChorusVocalAccompaniment(String OpenID) {
        return this.nativeStartChorusVocalAccompaniment(OpenID);
    }

    @Override
    public int StopChorusVocalAccompaniment() {
        return this.nativeStopChorusVocalAccompaniment();
    }

    @Override
    public int SendCustomStreamData(byte[] customStreamData) {
        return this.nativeSendCustomStreamData(customStreamData);
    }

    public void ReceiveCustomStreamData(long uin, byte[] data, long timestamp, Object userData) {
        if (null != this.customStreamDataCallback) {
            this.customStreamDataCallback.OnCallback(uin, data, timestamp, userData);
        }
    }

    @Override
    public int SetCustomStreamDataCallback(ITMGRoom.CustomStreamDataCallback callback, Object userData) {
        this.customStreamDataCallback = callback;
        this.nativeSetCustomStreamDataCallback(userData);
        return 0;
    }

    public native int nativeStartRoomSharing(String var1, String var2, byte[] var3);

    public native int nativeStopRoomSharing();

    public native String nativeGetQualityTips();

    public native int nativeChangeRoomType(int var1, AVCallback var2);

    public native int nativeGetRoomType();

    public native String nativeGetRoomID();

    public native int nativeUpdateAudioRecvRange(int var1);

    public native int nativeUpdateSpatializerRecvRange(int var1);

    public native int nativeUpdateSelfPosition(int[] var1, float[] var2, float[] var3, float[] var4);

    public native int nativeUpdateOtherPosition(String var1, int[] var2);

    public native int nativeSetServerAudioRoute(int var1, String[] var2, int var3, String[] var4);

    public native int nativeGetServerAudioRoute(int[] var1, String[] var2, String[] var3, int[] var4);

    public native int nativeSwitchRoom(String var1, byte[] var2);

    public native int nativeSendCustomData(byte[] var1, int var2);

    public native int nativeStopSendCustomData();

    public native int nativeStartChorusWithOpenID(String var1);

    public native int nativeStopChorus();

    public native int nativeStartChorusVocalAccompaniment(String var1);

    public native int nativeStopChorusVocalAccompaniment();

    private native int nativeSendCustomStreamData(byte[] var1);

    private native int nativeSetCustomStreamDataCallback(Object var1);

    @Override
    public int UpdateAudioRecvRange(int range) {
        return this.nativeUpdateAudioRecvRange(range);
    }

    @Override
    public int UpdateSpatializerRecvRange(int range) {
        return this.nativeUpdateSpatializerRecvRange(range);
    }

    @Override
    public int UpdateSelfPosition(int[] position, float[] axisForward, float[] axisRightward, float[] axisUpward) {
        return this.nativeUpdateSelfPosition(position, axisForward, axisRightward, axisUpward);
    }

    @Override
    public int UpdateOtherPosition(String openID, int[] position) {
        return this.nativeUpdateOtherPosition(openID, position);
    }

    @Override
    public int SwitchRoom(String targetRoomID, byte[] authBuffer) {
        return this.nativeSwitchRoom(targetRoomID, authBuffer);
    }

    public static interface EventListener {
        public void onEnterRoomComplete(int var1, String var2);

        public void onExitRoomComplete();

        public void onRoomDisconnect(int var1, String var2);

        public void onEndpointsUpdateInfo(int var1, String[] var2);

        public void onRoomEvent(int var1, int var2, Object var3);

        public void onDisableAudioIssue();
    }
}

